/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.distance_functions;

import timeseriesweka.filters.shapelet_transforms.Shapelet;
import timeseriesweka.filters.shapelet_transforms.distance_functions.SubSeqDistance;
import weka.core.Instances;

public class CachedSubSeqDistance
extends SubSeqDistance {
    protected Stats stats;
    protected double[][] data;

    @Override
    public void init(Instances dataInst) {
        this.stats = new Stats();
        int dataSize = dataInst.numInstances();
        this.data = new double[dataSize][];
        for (int i = 0; i < dataSize; ++i) {
            this.data[i] = this.zNormalise(dataInst.get(i).toDoubleArray(), true);
        }
    }

    @Override
    public void setShapelet(Shapelet shp) {
        super.setShapelet(shp);
        this.stats = null;
    }

    @Override
    public void setSeries(int seriesId) {
        super.setSeries(seriesId);
        this.stats.computeStats(seriesId, this.data);
    }

    @Override
    public double calculate(double[] timeSeries, int timeSeriesId) {
        if (this.stats == null) {
            return super.calculate(timeSeries, timeSeriesId);
        }
        this.stats.setCurrentY(timeSeriesId);
        double minSum = Double.MAX_VALUE;
        int subLength = this.length;
        double xMean = this.stats.getMeanX(this.startPos, subLength);
        double xStdDev = this.stats.getStdDevX(this.startPos, subLength);
        for (int v = 0; v < timeSeries.length - subLength; ++v) {
            double dist;
            double yMean = this.stats.getMeanY(v, subLength);
            double yStdDev = this.stats.getStdDevY(v, subLength);
            double crossProd = this.stats.getSumOfProds(this.startPos, v, subLength);
            double cXY = 0.0;
            if (xStdDev != 0.0 && yStdDev != 0.0) {
                cXY = (crossProd - (double)subLength * xMean * yMean) / ((double)subLength * xStdDev * yStdDev);
            }
            if (!((dist = 2.0 * (1.0 - cXY)) < minSum)) continue;
            minSum = dist;
        }
        return minSum;
    }

    public static class Stats {
        private double[][] cummSums = null;
        private double[][] cummSqSums = null;
        private double[][][] crossProds = null;
        private int xIndex = -1;
        private int yIndex = -1;

        public double[][] getCummSums() {
            return this.cummSums;
        }

        public double[][] getCummSqSums() {
            return this.cummSqSums;
        }

        public double[][][] getCrossProds() {
            return this.crossProds;
        }

        public void setCurrentY(int yIndex) {
            this.yIndex = yIndex;
        }

        public double getMeanX(int startPos, int subLength) {
            double diff = this.cummSums[this.xIndex][startPos + subLength] - this.cummSums[this.xIndex][startPos];
            return diff / (double)subLength;
        }

        public double getMeanY(int startPos, int subLength) {
            double diff = this.cummSums[this.yIndex][startPos + subLength] - this.cummSums[this.yIndex][startPos];
            return diff / (double)subLength;
        }

        public double getStdDevX(int startPos, int subLength) {
            double diff = this.cummSqSums[this.xIndex][startPos + subLength] - this.cummSqSums[this.xIndex][startPos];
            double meanSqrd = this.getMeanX(startPos, subLength) * this.getMeanX(startPos, subLength);
            double temp = diff / (double)subLength;
            double temp1 = temp - meanSqrd;
            return Math.sqrt(temp1);
        }

        public double getStdDevY(int startPos, int subLength) {
            double diff = this.cummSqSums[this.yIndex][startPos + subLength] - this.cummSqSums[this.yIndex][startPos];
            double meanSqrd = this.getMeanX(startPos, subLength) * this.getMeanX(startPos, subLength);
            double temp = diff / (double)subLength;
            double temp1 = temp - meanSqrd;
            return Math.sqrt(temp1);
        }

        public double getSumOfProds(int startX, int startY, int length) {
            return this.crossProds[this.yIndex][startX + length][startY + length] - this.crossProds[this.yIndex][startX][startY];
        }

        private double[][] computeCummSums(double[] currentSeries) {
            double[][] output = new double[][]{new double[currentSeries.length], new double[currentSeries.length]};
            output[0][0] = 0.0;
            output[1][0] = 0.0;
            for (int i = 1; i < currentSeries.length; ++i) {
                output[0][i] = output[0][i - 1] + currentSeries[i - 1];
                output[1][i] = output[1][i - 1] + currentSeries[i - 1] * currentSeries[i - 1];
            }
            return output;
        }

        private double[][] computeCrossProd(double[] x, double[] y) {
            double[][] output = new double[x.length][y.length];
            for (int u = 1; u < x.length; ++u) {
                for (int v = 1; v < y.length; ++v) {
                    int t;
                    if (v < u) {
                        t = u - v;
                        output[u][v] = output[u - 1][v - 1] + x[v - 1 + t] * y[v - 1];
                        continue;
                    }
                    t = v - u;
                    output[u][v] = output[u - 1][v - 1] + x[u - 1] * y[u - 1 + t];
                }
            }
            return output;
        }

        public void computeStats(int candidateInstIndex, double[][] data) {
            this.xIndex = candidateInstIndex;
            if (this.cummSums == null || this.cummSqSums == null) {
                this.cummSums = new double[data.length][];
                this.cummSqSums = new double[data.length][];
            }
            this.crossProds = new double[data.length][][];
            for (int i = 0; i < data.length; ++i) {
                if (this.cummSums[i] == null || this.cummSqSums[i] == null) {
                    double[][] sums = this.computeCummSums(data[i]);
                    this.cummSums[i] = sums[0];
                    this.cummSqSums[i] = sums[1];
                }
                this.crossProds[i] = this.computeCrossProd(data[candidateInstIndex], data[i]);
            }
        }
    }
}

