/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import timeseriesweka.filters.shapelet_transforms.OrderLineObj;
import timeseriesweka.filters.shapelet_transforms.Shapelet;
import timeseriesweka.filters.shapelet_transforms.ShapeletCandidate;
import timeseriesweka.filters.shapelet_transforms.ShapeletTransformFactory;
import timeseriesweka.filters.shapelet_transforms.ShapeletTransformFactoryOptions;
import timeseriesweka.filters.shapelet_transforms.class_value.BinaryClassValue;
import timeseriesweka.filters.shapelet_transforms.class_value.NormalClassValue;
import timeseriesweka.filters.shapelet_transforms.distance_functions.ImprovedOnlineSubSeqDistance;
import timeseriesweka.filters.shapelet_transforms.distance_functions.SubSeqDistance;
import timeseriesweka.filters.shapelet_transforms.quality_measures.ShapeletQuality;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearchFactory;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearchOptions;
import utilities.ClassifierTools;
import utilities.SaveParameterInfo;
import utilities.class_distributions.ClassDistribution;
import weka.classifiers.meta.RotationForest;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.SimpleBatchFilter;

public class ShapeletTransform
extends SimpleBatchFilter
implements SaveParameterInfo,
Serializable {
    protected static long subseqDistOpCount;
    private boolean removeSelfSimilar = true;
    public int dataSet;
    protected boolean supressOutput;
    protected int numShapelets;
    protected ArrayList<Shapelet> shapelets;
    protected String ouputFileLocation = "defaultShapeletOutput.txt";
    protected boolean recordShapelets;
    protected boolean roundRobin;
    public static final int DEFAULT_NUMSHAPELETS = 100;
    public static final int DEFAULT_MINSHAPELETLENGTH = 3;
    public static final int DEFAULT_MAXSHAPELETLENGTH = 23;
    protected transient ShapeletQuality quality;
    protected boolean useCandidatePruning;
    protected boolean useRoundRobin;
    protected Comparator<Shapelet> shapeletComparator;
    protected SubSeqDistance subseqDistance;
    protected NormalClassValue classValue;
    protected ShapeletSearch searchFunction;
    protected String serialName;
    protected Shapelet worstShapelet;
    protected Instances inputData;
    protected ArrayList<Shapelet> kShapelets;
    protected long count;
    protected int candidatePruningStartPercentage;
    protected static final double ROUNDING_ERROR_CORRECTION = 1.0E-15;
    protected int[] dataSourceIDs;

    @Override
    public String globalInfo() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setSubSeqDistance(SubSeqDistance ssd) {
        this.subseqDistance = ssd;
    }

    public long getCount() {
        return this.count;
    }

    public void setClassValue(NormalClassValue cv) {
        this.classValue = cv;
    }

    public void setSearchFunction(ShapeletSearch shapeletSearch) {
        this.searchFunction = shapeletSearch;
    }

    public ShapeletSearch getSearchFunction() {
        return this.searchFunction;
    }

    public void setSerialName(String sName) {
        this.serialName = sName;
    }

    public void useSeparationGap() {
        this.shapeletComparator = new Shapelet.ReverseSeparationGap();
    }

    public void setShapeletComparator(Comparator<Shapelet> comp) {
        this.shapeletComparator = comp;
    }

    public void setUseRoundRobin(boolean b) {
        this.useRoundRobin = b;
    }

    public SubSeqDistance getSubSequenceDistance() {
        return this.subseqDistance;
    }

    public ShapeletTransform() {
        this(100, 3, 23, ShapeletQuality.ShapeletQualityChoice.INFORMATION_GAIN);
    }

    public ShapeletTransform(ArrayList<Shapelet> shapes) {
        this();
        this.shapelets = shapes;
        this.m_FirstBatchDone = true;
        this.numShapelets = this.shapelets.size();
    }

    public ShapeletTransform(int k) {
        this(k, 3, 23, ShapeletQuality.ShapeletQualityChoice.INFORMATION_GAIN);
    }

    public ShapeletTransform(int k, int minShapeletLength, int maxShapeletLength) {
        this(k, minShapeletLength, maxShapeletLength, ShapeletQuality.ShapeletQualityChoice.INFORMATION_GAIN);
    }

    public ShapeletTransform(int k, int minShapeletLength, int maxShapeletLength, ShapeletQuality.ShapeletQualityChoice qualityChoice) {
        this.numShapelets = k;
        this.shapelets = new ArrayList();
        this.m_FirstBatchDone = false;
        this.useCandidatePruning = false;
        this.supressOutput = false;
        this.dataSet = 0;
        this.recordShapelets = true;
        this.roundRobin = false;
        this.useRoundRobin = false;
        this.shapeletComparator = new Shapelet.LongOrder();
        this.kShapelets = new ArrayList();
        this.setQualityMeasure(qualityChoice);
        this.subseqDistance = new SubSeqDistance();
        this.classValue = new NormalClassValue();
        ShapeletSearchOptions sOp = new ShapeletSearchOptions.Builder().setMin(minShapeletLength).setMax(maxShapeletLength).build();
        this.searchFunction = new ShapeletSearchFactory(sOp).getShapeletSearch();
    }

    public ArrayList<Shapelet> getShapelets() {
        return this.shapelets;
    }

    public void setRoundRobin(boolean val) {
        this.roundRobin = val;
    }

    public void supressOutput() {
        this.supressOutput = true;
    }

    public void useCandidatePruning() {
        this.useCandidatePruning = true;
        this.candidatePruningStartPercentage = 10;
    }

    public void useCandidatePruning(int percentage) {
        this.useCandidatePruning = true;
        this.candidatePruningStartPercentage = percentage;
    }

    public void setNumberOfShapelets(int k) {
        this.numShapelets = k;
    }

    public int getNumberOfShapelets() {
        return this.numShapelets;
    }

    public void turnOffLog() {
        this.recordShapelets = false;
    }

    public void setLogOutputFile(String fileName) {
        this.recordShapelets = true;
        this.ouputFileLocation = fileName;
    }

    public void setShapeletMinAndMax(int min, int max) {
        this.searchFunction.setMinAndMax(min, max);
    }

    public ShapeletQuality.ShapeletQualityChoice getQualityMeasure() {
        return this.quality.getChoice();
    }

    public void setQualityMeasure(ShapeletQuality.ShapeletQualityChoice qualityChoice) {
        this.quality = new ShapeletQuality(qualityChoice);
    }

    protected void initQualityBound(ClassDistribution classDist) {
        if (!this.useCandidatePruning) {
            return;
        }
        this.quality.initQualityBound(classDist, this.candidatePruningStartPercentage);
    }

    public void setCandidatePruning(boolean f) {
        this.useCandidatePruning = f;
        this.candidatePruningStartPercentage = f ? 10 : 100;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws IllegalArgumentException {
        if (this.numShapelets < 1) {
            System.out.println(this.numShapelets);
            throw new IllegalArgumentException("ShapeletFilter not initialised correctly - please specify a value of k that is greater than or equal to 1");
        }
        int length = this.shapelets.size();
        FastVector<Attribute> atts = new FastVector<Attribute>();
        for (int i = 0; i < length; ++i) {
            String name = "Shapelet_" + i;
            atts.addElement(new Attribute(name));
        }
        if (inputFormat.classIndex() >= 0) {
            Attribute target = inputFormat.attribute(inputFormat.classIndex());
            FastVector<String> vals = new FastVector<String>(target.numValues());
            for (int i = 0; i < target.numValues(); ++i) {
                vals.addElement(target.value(i));
            }
            atts.addElement(new Attribute(inputFormat.attribute(inputFormat.classIndex()).name(), vals));
        }
        Instances result = new Instances("Shapelets" + inputFormat.relationName(), atts, inputFormat.numInstances());
        if (inputFormat.classIndex() >= 0) {
            result.setClassIndex(result.numAttributes() - 1);
        }
        return result;
    }

    protected void inputCheck(Instances dataInst) throws IllegalArgumentException {
        if (this.numShapelets < 1) {
            throw new IllegalArgumentException("Number of shapelets initialised incorrectly - please select value of k (Usage: setNumberOfShapelets");
        }
        int maxPossibleLength = dataInst.instance(0).numAttributes();
        if (dataInst.classIndex() >= 0) {
            --maxPossibleLength;
        }
    }

    @Override
    public Instances process(Instances data) throws IllegalArgumentException {
        this.inputData = data;
        this.inputCheck(data);
        if (!this.m_FirstBatchDone) {
            this.trainShapelets(data);
            this.count = this.subseqDistance.getCount();
        }
        return this.buildTansformedDataset(data);
    }

    protected void trainShapelets(Instances data) {
        this.inputData = this.initDataSouce(data);
        this.searchFunction.setComparator(this.shapeletComparator);
        this.searchFunction.init(this.inputData);
        this.subseqDistance.init(this.inputData);
        this.classValue.init(this.inputData);
        this.shapelets = this.findBestKShapeletsCache(this.inputData);
        this.m_FirstBatchDone = true;
        this.outputPrint(this.shapelets.size() + " Shapelets have been generated");
    }

    private Instances initDataSouce(Instances data) {
        int dataSize = data.numInstances();
        this.dataSourceIDs = new int[dataSize];
        Instances dataset = data;
        if (this.roundRobin) {
            dataset = ShapeletTransform.roundRobinData(data, this.dataSourceIDs);
        } else {
            for (int i = 0; i < dataSize; ++i) {
                this.dataSourceIDs[i] = i;
            }
        }
        return dataset;
    }

    public Instances buildTansformedDataset(Instances data) {
        Instances output = this.determineOutputFormat(data);
        this.subseqDistance.init(this.inputData);
        this.classValue.init(this.inputData);
        int size = this.shapelets.size();
        int dataSize = data.numInstances();
        for (int j = 0; j < dataSize; ++j) {
            output.add(new DenseInstance(size + 1));
        }
        for (int i = 0; i < size; ++i) {
            Shapelet s = this.shapelets.get(i);
            this.subseqDistance.setShapelet(s);
            for (int j = 0; j < dataSize; ++j) {
                double dist = this.subseqDistance.calculate(data.instance(j), j);
                output.instance(j).setValue(i, dist);
            }
        }
        for (int j = 0; j < dataSize; ++j) {
            output.instance(j).setValue(size, data.instance(j).classValue());
        }
        return output;
    }

    public ArrayList<Shapelet> findBestKShapeletsCache(Instances data) {
        this.outputPrint("Processing data: ");
        int dataSize = data.numInstances();
        while (this.dataSet < dataSize) {
            this.outputPrint("data : " + this.dataSet);
            this.worstShapelet = this.kShapelets.size() == this.numShapelets ? this.kShapelets.get(this.numShapelets - 1) : null;
            this.subseqDistance.setSeries(this.dataSet);
            this.classValue.setShapeletValue(data.get(this.dataSet));
            ArrayList<Shapelet> seriesShapelets = this.searchFunction.SearchForShapeletsInSeries(data.get(this.dataSet), this::checkCandidate);
            if (seriesShapelets != null) {
                Collections.sort(seriesShapelets, this.shapeletComparator);
                if (this.isRemoveSelfSimilar()) {
                    seriesShapelets = ShapeletTransform.removeSelfSimilar(seriesShapelets);
                }
                this.kShapelets = this.combine(this.numShapelets, this.kShapelets, seriesShapelets);
            }
            this.createSerialFile();
            ++this.dataSet;
        }
        this.numShapelets = this.kShapelets.size();
        this.recordShapelets(this.kShapelets, this.ouputFileLocation);
        this.printShapelets(this.kShapelets);
        return this.kShapelets;
    }

    public void createSerialFile() {
        if (this.serialName == null) {
            return;
        }
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new FileOutputStream(this.serialName));
            out.writeObject(this);
        }
        catch (IOException ex) {
            System.out.println("Failed to write " + ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    System.out.println("Failed to close " + ex);
                }
            }
        }
    }

    public ArrayList<Shapelet> findBestKShapeletsCache(int numShapelets, Instances data, int minShapeletLength, int maxShapeletLength) {
        this.numShapelets = numShapelets;
        this.classValue.init(data);
        this.subseqDistance.init(data);
        this.initDataSouce(data);
        return this.findBestKShapeletsCache(data);
    }

    protected ArrayList<Shapelet> combine(int k, ArrayList<Shapelet> kBestSoFar, ArrayList<Shapelet> timeSeriesShapelets) {
        ArrayList<Shapelet> newBestSoFar = new ArrayList<Shapelet>();
        int bsfPtr = 0;
        int tssPtr = 0;
        for (int i = 0; i < k; ++i) {
            boolean shapelet2Null;
            Shapelet shapelet1 = null;
            Shapelet shapelet2 = null;
            if (bsfPtr < kBestSoFar.size()) {
                shapelet1 = kBestSoFar.get(bsfPtr);
            }
            if (tssPtr < timeSeriesShapelets.size()) {
                shapelet2 = timeSeriesShapelets.get(tssPtr);
            }
            boolean shapelet1Null = shapelet1 == null;
            boolean bl = shapelet2Null = shapelet2 == null;
            if (shapelet1Null && shapelet2Null) break;
            if (shapelet1Null) {
                newBestSoFar.add(shapelet2);
                ++tssPtr;
                continue;
            }
            if (shapelet2Null) {
                newBestSoFar.add(shapelet1);
                ++bsfPtr;
                continue;
            }
            if (this.shapeletComparator.compare(shapelet1, shapelet2) == -1) {
                newBestSoFar.add(shapelet1);
                ++bsfPtr;
                shapelet1 = null;
                continue;
            }
            newBestSoFar.add(shapelet2);
            ++tssPtr;
            shapelet2 = null;
        }
        return newBestSoFar;
    }

    protected static ArrayList<Shapelet> removeSelfSimilar(ArrayList<Shapelet> shapelets) {
        ArrayList<Shapelet> outputShapelets = new ArrayList<Shapelet>();
        int size = shapelets.size();
        boolean[] selfSimilar = new boolean[size];
        for (int i = 0; i < size; ++i) {
            if (selfSimilar[i]) continue;
            outputShapelets.add(shapelets.get(i));
            for (int j = i + 1; j < size; ++j) {
                if (selfSimilar[j] || !ShapeletTransform.selfSimilarity(shapelets.get(i), shapelets.get(j))) continue;
                selfSimilar[j] = true;
            }
        }
        return outputShapelets;
    }

    protected Shapelet checkCandidate(Instance series, int start, int length, int dimension) {
        this.initQualityBound(this.classValue.getClassDistributions());
        if (this.worstShapelet != null) {
            this.quality.setBsfQuality(this.worstShapelet.qualityValue);
        }
        this.subseqDistance.setCandidate(series, start, length, dimension);
        ArrayList<OrderLineObj> orderline = new ArrayList<OrderLineObj>();
        int dataSize = this.inputData.numInstances();
        for (int i = 0; i < dataSize; ++i) {
            if (this.quality.pruneCandidate()) {
                return null;
            }
            double distance = 0.0;
            if (i != this.dataSet) {
                distance = this.subseqDistance.calculate(this.inputData.instance(i), i);
            }
            double classVal = this.classValue.getClassValue(this.inputData.instance(i));
            orderline.add(new OrderLineObj(distance, classVal));
            this.quality.updateOrderLine(orderline.get(orderline.size() - 1));
        }
        Shapelet shapelet = new Shapelet(this.subseqDistance.getCandidate(), this.dataSourceIDs[this.dataSet], start, this.quality.getQualityMeasure());
        shapelet.calculateQuality(orderline, this.classValue.getClassDistributions());
        shapelet.classValue = this.classValue.getShapeletValue();
        shapelet.dimension = dimension;
        return shapelet;
    }

    public static Instances loadData(String fileName) {
        Instances data = null;
        try {
            FileReader r = new FileReader(fileName);
            data = new Instances(r);
            data.setClassIndex(data.numAttributes() - 1);
        }
        catch (IOException e) {
            System.out.println(" Error =" + e + " in method loadData");
        }
        return data;
    }

    private static boolean selfSimilarity(Shapelet shapelet, Shapelet candidate) {
        if (candidate.seriesId == shapelet.seriesId && candidate.dimension == shapelet.dimension) {
            if (candidate.startPos >= shapelet.startPos && candidate.startPos < shapelet.startPos + shapelet.getLength()) {
                return true;
            }
            if (shapelet.startPos >= candidate.startPos && shapelet.startPos < candidate.startPos + candidate.getLength()) {
                return true;
            }
        }
        return false;
    }

    public static ShapeletTransform createFilterFromFile(String fileName) throws Exception {
        return ShapeletTransform.createFilterFromFile(fileName, Integer.MAX_VALUE);
    }

    public double timingForSingleShapelet(Instances data, int minShapeletLength, int maxShapeletLength) {
        data = ShapeletTransform.roundRobinData(data, null);
        long startTime = System.nanoTime();
        this.findBestKShapeletsCache(1, data, minShapeletLength, maxShapeletLength);
        long finishTime = System.nanoTime();
        return (double)(finishTime - startTime) / 1.0E9;
    }

    protected void recordShapelets(ArrayList<Shapelet> kShapelets, String saveLocation) {
        if (!this.recordShapelets) {
            return;
        }
        try {
            File file = new File(saveLocation);
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            FileWriter out = new FileWriter(file);
            for (Shapelet kShapelet : kShapelets) {
                out.append(kShapelet.qualityValue + "," + kShapelet.seriesId + "," + kShapelet.startPos + "\n");
                double[] shapeletContent = kShapelet.getUniveriateShapeletContent();
                for (int j = 0; j < shapeletContent.length; ++j) {
                    out.append(shapeletContent[j] + ",");
                }
                out.append("\n");
            }
            out.close();
        }
        catch (IOException ex) {
            System.out.println("IOException: " + ex);
        }
    }

    protected void printShapelets(ArrayList<Shapelet> kShapelets) {
        if (this.supressOutput) {
            return;
        }
        System.out.println();
        System.out.println("Output Shapelets:");
        System.out.println("-------------------");
        System.out.println("informationGain,seriesId,startPos,classVal,numChannels,dimenion");
        System.out.println("<shapelet>");
        System.out.println("-------------------");
        System.out.println();
        for (Shapelet kShapelet : kShapelets) {
            System.out.println(kShapelet.qualityValue + "," + kShapelet.seriesId + "," + kShapelet.startPos + "," + kShapelet.classValue + "," + kShapelet.getNumDimensions() + "," + kShapelet.dimension);
            for (int i = 0; i < kShapelet.numDimensions; ++i) {
                double[] shapeletContent = kShapelet.getContent().getShapeletContent(i);
                for (int j = 0; j < shapeletContent.length; ++j) {
                    System.out.print(shapeletContent[j] + ",");
                }
                System.out.println();
            }
        }
    }

    public ArrayList<Integer> getShapeletLengths() {
        ArrayList<Integer> shapeletLengths = new ArrayList<Integer>();
        if (this.m_FirstBatchDone) {
            for (Shapelet s : this.shapelets) {
                shapeletLengths.add(s.getLength());
            }
        }
        return shapeletLengths;
    }

    public static ShapeletTransform createFilterFromFile(String fileName, int maxShapelets) throws Exception {
        File input = new File(fileName);
        Scanner scan = new Scanner(input);
        scan.useDelimiter("\n");
        ShapeletTransform sf = new ShapeletTransform();
        ArrayList<Shapelet> shapelets = new ArrayList<Shapelet>();
        for (int shapeletCount = 0; shapeletCount < maxShapelets && scan.hasNext(); ++shapeletCount) {
            String shapeletStatsString = scan.next();
            String shapeletContentString = scan.next();
            Scanner statScan = new Scanner(shapeletStatsString);
            statScan.useDelimiter(",");
            double qualVal = Double.parseDouble(statScan.next().trim());
            int serID = Integer.parseInt(statScan.next().trim());
            int starPos = Integer.parseInt(statScan.next().trim());
            Scanner lineScan = new Scanner(shapeletContentString);
            lineScan.useDelimiter(",");
            ArrayList<Double> content = new ArrayList<Double>();
            while (lineScan.hasNext()) {
                String next = lineScan.next().trim();
                if (next.isEmpty()) continue;
                content.add(Double.parseDouble(next));
            }
            double[] contentArray = new double[content.size()];
            for (int i = 0; i < content.size(); ++i) {
                contentArray[i] = (Double)content.get(i);
            }
            contentArray = sf.subseqDistance.zNormalise(contentArray, false);
            ShapeletCandidate cand = new ShapeletCandidate();
            cand.setShapeletContent(contentArray);
            Shapelet s = new Shapelet(cand, qualVal, serID, starPos);
            shapelets.add(s);
        }
        sf.shapelets = shapelets;
        sf.m_FirstBatchDone = true;
        sf.numShapelets = shapelets.size();
        sf.setShapeletMinAndMax(1, 1);
        return sf;
    }

    public static ArrayList<Shapelet> readShapeletCSV(File f) throws FileNotFoundException {
        ArrayList<Shapelet> shapelets = new ArrayList<Shapelet>();
        Scanner sc = new Scanner(f);
        boolean readHeader = true;
        double quality = 0.0;
        int series = 0;
        int position = 0;
        while (sc.hasNextLine()) {
            String line = sc.nextLine();
            String[] cotentsAsString = line.split(",");
            if (readHeader) {
                quality = Double.parseDouble(cotentsAsString[0]);
                series = Integer.parseInt(cotentsAsString[1]);
                position = Integer.parseInt(cotentsAsString[2]);
            } else {
                double[] content = new double[cotentsAsString.length];
                for (int i = 0; i < content.length; ++i) {
                    content[i] = Double.parseDouble(cotentsAsString[i]);
                }
                shapelets.add(new Shapelet(new ShapeletCandidate(content), quality, series, position));
            }
            readHeader = !readHeader;
        }
        return shapelets;
    }

    public static Instances roundRobinData(Instances data, int[] sourcePos) {
        TreeMap instancesByClass = new TreeMap();
        TreeMap positionsByClass = new TreeMap();
        NormalClassValue ncv = new NormalClassValue();
        ncv.init(data);
        ClassDistribution classDistribution = ncv.getClassDistributions();
        for (int i = 0; i < classDistribution.size(); ++i) {
            int frequency = classDistribution.get(i);
            instancesByClass.put(Double.valueOf(i), new ArrayList(frequency));
            positionsByClass.put(Double.valueOf(i), new ArrayList(frequency));
        }
        int dataSize = data.numInstances();
        for (int i = 0; i < dataSize; ++i) {
            Instance inst = data.instance(i);
            ((ArrayList)instancesByClass.get(ncv.getClassValue(inst))).add(inst);
            ((ArrayList)positionsByClass.get(ncv.getClassValue(inst))).add(i);
        }
        Instances roundRobinData = new Instances(data, dataSize);
        int i = 0;
        while (i < dataSize) {
            for (int j = 0; j < classDistribution.size(); ++j) {
                ArrayList currentList = (ArrayList)instancesByClass.get(j);
                ArrayList currentPositions = (ArrayList)positionsByClass.get(j);
                if (currentList.isEmpty()) continue;
                roundRobinData.add((Instance)currentList.remove(currentList.size() - 1));
                if (sourcePos != null && sourcePos.length == dataSize) {
                    sourcePos[i] = (Integer)currentPositions.remove(currentPositions.size() - 1);
                }
                ++i;
            }
        }
        return roundRobinData;
    }

    public void outputPrint(String val) {
        if (!this.supressOutput) {
            System.out.println(val);
        }
    }

    @Override
    public String toString() {
        String str = "Shapelets: ";
        for (Shapelet s : this.shapelets) {
            str = str + s.toString() + "\n";
        }
        return str;
    }

    @Override
    public String getParameters() {
        String str = "minShapeletLength," + this.searchFunction.getMin() + ",maxShapeletLength," + this.searchFunction.getMax() + ",numShapelets," + this.numShapelets + ",roundrobin," + this.roundRobin + ",searchFunction," + this.searchFunction.getClass().getSimpleName() + ",qualityMeasure," + this.quality.getQualityMeasure().getClass().getSimpleName();
        return str;
    }

    public long opCountForSingleShapelet(Instances data, int minShapeletLength, int maxShapeletLength) throws Exception {
        data = ShapeletTransform.roundRobinData(data, null);
        subseqDistOpCount = 0L;
        this.findBestKShapeletsCache(1, data, minShapeletLength, maxShapeletLength);
        return subseqDistOpCount;
    }

    public static void main(String[] args) {
        try {
            String resampleLocation = "../../Dropbox//TSC Problems";
            String dataset = "ItalyPowerDemand";
            boolean fold = true;
            String filePath = "../../Dropbox//TSC Problems" + File.separator + "ItalyPowerDemand" + File.separator + "ItalyPowerDemand";
            Instances test = ClassifierTools.loadData(filePath + "_TEST");
            Instances train = ClassifierTools.loadData(filePath + "_TRAIN");
            ShapeletTransform transform = new ShapeletTransform();
            transform.setRoundRobin(true);
            transform.setClassValue(new BinaryClassValue());
            transform.setSubSeqDistance(new ImprovedOnlineSubSeqDistance());
            transform.setShapeletMinAndMax(3, train.numAttributes() - 1);
            transform.useCandidatePruning();
            transform.setNumberOfShapelets(train.numInstances() * 10);
            transform.setQualityMeasure(ShapeletQuality.ShapeletQualityChoice.INFORMATION_GAIN);
            transform.supressOutput();
            long startTime = System.nanoTime();
            Instances tranTrain = transform.process(train);
            Instances tranTest = transform.process(test);
            long endTime = System.nanoTime();
            RotationForest rot1 = new RotationForest();
            rot1.buildClassifier(tranTrain);
            double accuracy = ClassifierTools.accuracy(tranTest, rot1);
            System.out.println("Shapelet transform " + accuracy + " time " + (endTime - startTime));
            ShapeletSearchOptions searchOptions = new ShapeletSearchOptions.Builder().setMin(3).setMax(train.numAttributes() - 1).setSearchType(ShapeletSearch.SearchType.FULL).build();
            ShapeletTransformFactoryOptions options = new ShapeletTransformFactoryOptions.Builder().setDistanceType(SubSeqDistance.DistanceType.IMP_ONLINE).setKShapelets(train.numInstances() * 10).useBinaryClassValue().useClassBalancing().useCandidatePruning().useRoundRobin().setSearchOptions(searchOptions).build();
            ShapeletTransform transform1 = new ShapeletTransformFactory(options).getTransform();
            transform1.supressOutput();
            long startTime1 = System.nanoTime();
            Instances tranTrain1 = transform.process(train);
            Instances tranTest1 = transform.process(test);
            long endTime1 = System.nanoTime();
            RotationForest rot2 = new RotationForest();
            rot2.buildClassifier(tranTrain1);
            double accuracy1 = ClassifierTools.accuracy(tranTest1, rot2);
            System.out.println("Fast shapelet transform " + accuracy1 + " time " + (endTime1 - startTime1));
        }
        catch (Exception ex) {
            Logger.getLogger(ShapeletTransform.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean isRemoveSelfSimilar() {
        return this.removeSelfSimilar;
    }

    public void setRemoveSelfSimilar(boolean removeSelfSimilar) {
        this.removeSelfSimilar = removeSelfSimilar;
    }
}

