/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms;

import development.DataSets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import timeseriesweka.filters.shapelet_transforms.Shapelet;
import timeseriesweka.filters.shapelet_transforms.ShapeletTransform;
import utilities.ClassifierTools;
import weka.core.Instances;

public class GraceShapeletTransform
extends ShapeletTransform {
    int currentSeries = 0;
    String seriesShapeletsFilePath;

    public void setSeries(int i) {
        this.currentSeries = i;
    }

    @Override
    public Instances process(Instances data) throws IllegalArgumentException {
        this.inputCheck(data);
        this.classValue.init(data);
        this.subseqDistance.init(data);
        if (!this.m_FirstBatchDone) {
            this.trainShapelets(data);
            this.m_FirstBatchDone = false;
            this.outputPrint("Partially Built the shapelet Set");
            return null;
        }
        return this.buildTansformedDataset(data);
    }

    @Override
    public ArrayList<Shapelet> findBestKShapeletsCache(Instances data) {
        ArrayList<Shapelet> kShapelets = new ArrayList<Shapelet>();
        int proportion = this.numShapelets / data.numClasses();
        this.outputPrint("Processing data: ");
        this.outputPrint("data : " + this.currentSeries);
        this.subseqDistance.setSeries(this.currentSeries);
        this.classValue.setShapeletValue(data.get(this.currentSeries));
        ArrayList<Shapelet> seriesShapelets = this.searchFunction.SearchForShapeletsInSeries(data.get(this.dataSet), this::checkCandidate);
        Collections.sort(seriesShapelets, this.shapeletComparator);
        seriesShapelets = GraceShapeletTransform.removeSelfSimilar(seriesShapelets);
        kShapelets = this.combine(proportion, kShapelets, seriesShapelets);
        this.createSerialFile(kShapelets);
        return kShapelets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSerialFile(ArrayList<Shapelet> shapelets) {
        String fileName = this.getSubShapeletFileName(this.currentSeries);
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new FileOutputStream(fileName));
            out.writeObject(shapelets);
        }
        catch (IOException ex) {
            System.out.println("Failed to write " + ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    System.out.println("Failed to close " + ex);
                }
            }
        }
    }

    private String getSubShapeletFileName(int i) {
        File f = new File(this.serialName);
        String str = f.getName();
        str = str.substring(0, str.lastIndexOf(46));
        return str + "_" + i + ".ser";
    }

    public Instances processFromSubFile(Instances train) {
        File f = new File(this.ouputFileLocation);
        ArrayList<Object> kShapelets = new ArrayList();
        TreeMap<Double, ArrayList<Shapelet>> kShapeletsMap = new TreeMap<Double, ArrayList<Shapelet>>();
        for (int i = 0; i < train.numClasses(); ++i) {
            kShapeletsMap.put(Double.valueOf(i), new ArrayList());
        }
        int proportion = this.numShapelets / kShapeletsMap.keySet().size();
        for (int i = 0; i < train.numInstances(); ++i) {
            kShapelets = kShapeletsMap.get(train.get(i).classValue());
            ArrayList<Shapelet> seriesShapelets = GraceShapeletTransform.readShapeletsFromFile(this.getSubShapeletFileName(i));
            kShapelets = this.combine(proportion, kShapelets, seriesShapelets);
            kShapeletsMap.put(train.get(i).classValue(), kShapelets);
        }
        kShapelets = this.buildKShapeletsFromMap(kShapeletsMap);
        this.numShapelets = kShapelets.size();
        this.shapelets = kShapelets;
        this.m_FirstBatchDone = true;
        return this.buildTansformedDataset(train);
    }

    private ArrayList<Shapelet> buildKShapeletsFromMap(Map<Double, ArrayList<Shapelet>> kShapeletsMap) {
        ArrayList<Shapelet> kShapelets = new ArrayList<Shapelet>();
        int numberOfClassVals = kShapeletsMap.keySet().size();
        int proportion = this.numShapelets / numberOfClassVals;
        for (ArrayList<Shapelet> list : kShapeletsMap.values()) {
            int i = 0;
            Iterator<Shapelet> it = list.iterator();
            while (it.hasNext() && i++ <= proportion) {
                kShapelets.add(it.next());
            }
        }
        return kShapelets;
    }

    public static ArrayList<Shapelet> readShapeletsFromFile(String shapeletLocation) {
        ArrayList shapelets = null;
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(shapeletLocation));
            shapelets = (ArrayList)ois.readObject();
        }
        catch (IOException | ClassNotFoundException ex) {
            System.out.println(ex);
        }
        return shapelets;
    }

    public static void buildGraceBSUB(String fileName, int numInstances, int fold, String queue, int memUsage) {
        try {
            File f1 = new File(fileName + "GRACE.bsub");
            f1.createNewFile();
            try (PrintWriter pw = new PrintWriter(f1);){
                pw.println("#!/bin/csh");
                pw.println("#BSUB -q " + queue);
                pw.println("#BSUB -J " + fileName + fold + "[1-" + numInstances + "]");
                pw.println("#BSUB -cwd \"/gpfs/sys/raj09hxu/GraceTransform/dist\"");
                pw.println("#BSUB -oo output/" + fileName + fold + "_%I.out");
                pw.println("#BSUB -R \"rusage[mem=" + memUsage + "]\"");
                pw.println("#BSUB -M " + memUsage);
                pw.println("./etc/profile");
                pw.println("module add java/jdk1.8.0_51");
                pw.println("java -jar -Xmx" + memUsage + "m TimeSeriesClassification.jar " + fileName + " 1 " + (fold + 1) + " $LSB_JOBINDEX");
            }
        }
        catch (IOException ex) {
            System.out.println("Failed to create file " + ex);
        }
    }

    public static void main(String[] args) {
    }

    public static void test() {
        String ucrLocation = "../../time-series-datasets/TSC Problems";
        String transformLocation = "../../";
        String fileExtension = File.separator + DataSets.ucrSmall[0] + File.separator + DataSets.ucrSmall[0];
        Instances train = ClassifierTools.loadData("../../time-series-datasets/TSC Problems" + fileExtension + "_TRAIN");
        Instances test = ClassifierTools.loadData("../../time-series-datasets/TSC Problems" + fileExtension + "_TEST");
        GraceShapeletTransform st = new GraceShapeletTransform();
        st.setNumberOfShapelets(train.numInstances() * 10);
        st.setLogOutputFile(DataSets.ucrSmall[0] + ".csv");
        String classifierDir = File.separator + st.getClass().getSimpleName() + fileExtension;
        String savePath = "../../" + classifierDir;
    }
}

