/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import timeseriesweka.filters.shapelet_transforms.Shapelet;
import timeseriesweka.filters.shapelet_transforms.ShapeletTransform;
import timeseriesweka.filters.shapelet_transforms.distance_functions.OnlineSubSeqDistance;
import timeseriesweka.filters.shapelet_transforms.quality_measures.ShapeletQuality;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instances;
import weka.filters.SimpleBatchFilter;

public class ClusteredShapeletTransform
extends SimpleBatchFilter {
    ShapeletTransform st;
    protected double[][] distanceMap;
    protected ArrayList<int[]> clusterPairs;
    protected ArrayList<Shapelet> clusteredShapelets;
    protected ArrayList<Shapelet> allShapelets;
    protected int noClust;
    public static int DEFAULT_NUMCLUSTERS = 1;

    public ClusteredShapeletTransform(ShapeletTransform shapes, int n) {
        this.st = shapes;
        this.clusteredShapelets = new ArrayList();
        this.noClust = n;
    }

    public ClusteredShapeletTransform(int k, int minShapeletLength, int maxShapeletLength, ShapeletQuality.ShapeletQualityChoice qualityChoice, int noClust) {
        this.st = new ShapeletTransform(k, minShapeletLength, maxShapeletLength, qualityChoice);
        this.noClust = noClust;
        this.clusteredShapelets = new ArrayList();
    }

    public ClusteredShapeletTransform(int k, int minShapeletLength, int maxShapeletLength, ShapeletQuality.ShapeletQualityChoice qualityChoice) {
        this.st = new ShapeletTransform(k, minShapeletLength, maxShapeletLength, qualityChoice);
        this.st.setSubSeqDistance(new OnlineSubSeqDistance());
        this.noClust = DEFAULT_NUMCLUSTERS;
        this.clusteredShapelets = new ArrayList();
    }

    public ClusteredShapeletTransform(int k, int minShapeletLength, int maxShapeletLength) {
        this.st = new ShapeletTransform(k, minShapeletLength, maxShapeletLength);
        this.st.setSubSeqDistance(new OnlineSubSeqDistance());
        this.noClust = DEFAULT_NUMCLUSTERS;
        this.clusteredShapelets = new ArrayList();
    }

    public ClusteredShapeletTransform(int k, int minShapeletLength, int maxShapeletLength, int noClust) {
        this.st = new ShapeletTransform(k, minShapeletLength, maxShapeletLength);
        this.st.setSubSeqDistance(new OnlineSubSeqDistance());
        this.noClust = noClust;
        this.clusteredShapelets = new ArrayList();
    }

    public ClusteredShapeletTransform(int k) {
        this.st = new ShapeletTransform(k);
        this.st.setSubSeqDistance(new OnlineSubSeqDistance());
        this.noClust = DEFAULT_NUMCLUSTERS;
        this.clusteredShapelets = new ArrayList();
    }

    public ClusteredShapeletTransform(int k, boolean cluster, int noClust) {
        this.st = new ShapeletTransform(k);
        this.st.setSubSeqDistance(new OnlineSubSeqDistance());
        this.noClust = noClust;
        this.clusteredShapelets = new ArrayList();
    }

    public ClusteredShapeletTransform() {
        this.st = new ShapeletTransform();
        this.st.setSubSeqDistance(new OnlineSubSeqDistance());
        this.noClust = DEFAULT_NUMCLUSTERS;
        this.clusteredShapelets = new ArrayList();
    }

    @Override
    public Instances process(Instances data) throws Exception {
        int size = this.st.getNumberOfShapelets();
        if (size < 1) {
            throw new Exception("Number of shapelets initialised incorrectly - please select value of k (Usage: setNumberOfShapelets");
        }
        if (size < this.noClust) {
            throw new Exception("Trying to produce more clusters than there are shapelets!");
        }
        if (!this.st.isFirstBatchDone()) {
            this.st.process(data);
        }
        this.allShapelets = this.st.shapelets;
        this.clusterShapelets();
        this.st.shapelets = this.clusteredShapelets;
        return this.st.buildTansformedDataset(data);
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        int s = this.st.getNumberOfShapelets();
        if (s < 1 || s < this.noClust) {
            throw new Exception("ShapeletFilter not initialised correctly - please specify a value of k that is greater than or equal to 1. You entered s=" + s + " num clusters =" + this.noClust);
        }
        FastVector<Attribute> atts = new FastVector<Attribute>();
        for (int i = 0; i < this.noClust; ++i) {
            String name = "CShapelet_" + i;
            atts.addElement(new Attribute(name));
        }
        Attribute target = inputFormat.attribute(inputFormat.classIndex());
        FastVector<String> vals = new FastVector<String>(target.numValues());
        for (int i = 0; i < target.numValues(); ++i) {
            vals.addElement(target.value(i));
        }
        atts.addElement(new Attribute(inputFormat.attribute(inputFormat.classIndex()).name(), vals));
        Instances result = new Instances("CShapelets" + inputFormat.relationName(), atts, inputFormat.numInstances());
        result.setClassIndex(result.numAttributes() - 1);
        return result;
    }

    public void clusterShapelets() {
        int i;
        double[][] shapeletSet = new double[this.allShapelets.size()][];
        for (i = 0; i < shapeletSet.length; ++i) {
            shapeletSet[i] = this.allShapelets.get(i).getUniveriateShapeletContent();
        }
        this.distanceMap = this.getDistanceMap(shapeletSet);
        this.clusterPairs = new ArrayList();
        this.clusteredShapelets.clear();
        i = 0;
        while (i < this.distanceMap.length) {
            int[] tmp = new int[]{i++};
            this.clusterPairs.add(tmp);
        }
        int[] bestPair = this.findClosestPair(this.distanceMap);
        Object map = new double[2][];
        while (this.clusterPairs.size() > this.noClust) {
            this.adjustClusterPairs(bestPair);
            map = this.adjustDistanceMap();
            bestPair = this.findClosestPair((double[][])map);
        }
        for (int i2 = 0; i2 < this.clusterPairs.size(); ++i2) {
            if (this.clusterPairs.get(i2).length == 1) {
                this.clusteredShapelets.add(this.allShapelets.get(this.clusterPairs.get(i2)[0]));
                continue;
            }
            double best = Double.MIN_VALUE;
            int position = 0;
            for (int j = 0; j < this.clusterPairs.get(i2).length; ++j) {
                if (!(this.allShapelets.get((int)this.clusterPairs.get((int)i2)[j]).qualityValue > best)) continue;
                best = this.allShapelets.get((int)this.clusterPairs.get((int)i2)[j]).qualityValue;
                position = j;
            }
            this.clusteredShapelets.add(this.allShapelets.get(this.clusterPairs.get(i2)[position]));
        }
    }

    private int[] findClosestPair(double[][] map) {
        int[] pair = new int[2];
        double best = Double.MAX_VALUE;
        for (int i = 0; i < map.length; ++i) {
            for (int j = i + 1; j < map[i].length; ++j) {
                if (!(map[i][j] < best)) continue;
                best = map[i][j];
                pair[0] = i;
                pair[1] = j;
            }
        }
        return pair;
    }

    private double[][] getDistanceMap(double[][] shapeletSet) {
        int i;
        double[][] map = new double[shapeletSet.length][];
        for (i = 0; i < shapeletSet.length; ++i) {
            double[] tmp = new double[shapeletSet.length];
            map[i] = tmp;
        }
        for (i = 0; i < shapeletSet.length; ++i) {
            map[i][i] = 0.0;
            for (int j = i + 1; j < shapeletSet.length; ++j) {
                map[i][j] = this.findMinDistance(shapeletSet[i], shapeletSet[j]);
                map[j][i] = map[i][j];
            }
        }
        return map;
    }

    private double findMinDistance(double[] first, double[] second) {
        double distance = 0.0;
        double bestDist = Double.MAX_VALUE;
        if (first.length == second.length) {
            bestDist = this.getDistance(first, second);
        } else if (first.length > second.length) {
            for (int i = 0; i < first.length - second.length + 1; ++i) {
                double[] temp = Arrays.copyOfRange(first, i, i + second.length);
                distance = this.getDistance(temp, second);
                if (!(distance < bestDist)) continue;
                bestDist = distance;
            }
        } else {
            for (int i = 0; i < second.length - first.length + 1; ++i) {
                double[] temp = Arrays.copyOfRange(second, i, i + first.length);
                distance = this.getDistance(temp, first);
                if (!(distance < bestDist)) continue;
                bestDist = distance;
            }
        }
        return bestDist;
    }

    private double getDistance(double[] first, double[] second) {
        double distance = 0.0;
        for (int i = 0; i < first.length; ++i) {
            distance += (first[i] - second[i]) * (first[i] - second[i]);
        }
        return Math.sqrt(distance);
    }

    private double[][] adjustDistanceMap() {
        int i;
        double[][] map = new double[this.clusterPairs.size()][];
        for (i = 0; i < map.length; ++i) {
            double[] tmp = new double[this.clusterPairs.size()];
            map[i] = tmp;
        }
        for (i = 0; i < this.clusterPairs.size(); ++i) {
            map[i][i] = 0.0;
            for (int j = i + 1; j < this.clusterPairs.size(); ++j) {
                map[i][j] = this.averageDistance(this.clusterPairs.get(i), this.clusterPairs.get(j));
                map[j][i] = map[i][j];
            }
        }
        return map;
    }

    private double averageDistance(int[] first, int[] second) {
        double dist = 0.0;
        for (int i = 0; i < first.length; ++i) {
            for (int j = 0; j < second.length; ++j) {
                dist += this.distanceMap[first[i]][second[j]];
            }
        }
        return dist /= (double)(first.length * second.length);
    }

    private void adjustClusterPairs(int[] pair) {
        int[] first = this.clusterPairs.get(pair[0]);
        int[] second = this.clusterPairs.get(pair[1]);
        int[] tmp = new int[first.length + second.length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = i < first.length ? first[i] : second[i - first.length];
        }
        this.clusterPairs.remove(pair[0]);
        this.clusterPairs.add(pair[0], tmp);
        this.clusterPairs.remove(pair[1]);
    }

    public int getNoClust() {
        return this.noClust;
    }

    public void setNoClust(int num) {
        this.noClust = num;
    }

    public void setShapeletTransform(ShapeletTransform s) {
        this.st = s;
    }

    public void outputLog(String outfile) throws Exception {
        PrintWriter cout = new PrintWriter((Writer)new FileWriter(outfile), true);
        for (int i = 0; i < this.clusteredShapelets.size(); ++i) {
            Shapelet s = this.clusteredShapelets.get(i);
            cout.println(s.qualityValue + "," + s.seriesId + "," + s.startPos);
            cout.flush();
            double[] con = s.getUniveriateShapeletContent();
            cout.print(con[0]);
            cout.flush();
            for (int j = 1; j < con.length; ++j) {
                cout.print("," + con[j]);
                cout.flush();
            }
            cout.println();
            cout.flush();
        }
        cout.close();
    }

    @Override
    public String globalInfo() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

