/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import timeseriesweka.filters.shapelet_transforms.Shapelet;
import timeseriesweka.filters.shapelet_transforms.ShapeletTransform;
import weka.core.Instances;

public class BalancedClassShapeletTransform
extends ShapeletTransform
implements Serializable {
    protected Map<Double, ArrayList<Shapelet>> kShapeletsMap;

    @Override
    public ArrayList<Shapelet> findBestKShapeletsCache(Instances data) {
        if (this.kShapeletsMap == null) {
            this.kShapeletsMap = new TreeMap<Double, ArrayList<Shapelet>>();
            for (int i = 0; i < data.numClasses(); ++i) {
                this.kShapeletsMap.put(Double.valueOf(i), new ArrayList());
            }
        }
        int proportion = this.numShapelets / this.kShapeletsMap.keySet().size();
        this.outputPrint("Processing data: ");
        int dataSize = data.numInstances();
        while (this.dataSet < dataSize) {
            this.outputPrint("data : " + this.dataSet);
            this.kShapelets = this.kShapeletsMap.get(data.get(this.dataSet).classValue());
            this.worstShapelet = this.kShapelets.size() == proportion ? (Shapelet)this.kShapelets.get(this.kShapelets.size() - 1) : null;
            this.subseqDistance.setSeries(this.dataSet);
            this.classValue.setShapeletValue(data.get(this.dataSet));
            ArrayList<Shapelet> seriesShapelets = this.searchFunction.SearchForShapeletsInSeries(data.get(this.dataSet), this::checkCandidate);
            if (seriesShapelets != null) {
                Collections.sort(seriesShapelets, this.shapeletComparator);
                if (this.isRemoveSelfSimilar()) {
                    seriesShapelets = BalancedClassShapeletTransform.removeSelfSimilar(seriesShapelets);
                }
                this.kShapelets = this.combine(proportion, this.kShapelets, seriesShapelets);
            }
            this.kShapeletsMap.put(data.get(this.dataSet).classValue(), this.kShapelets);
            ++this.dataSet;
            this.createSerialFile();
        }
        this.kShapelets = this.buildKShapeletsFromMap(this.kShapeletsMap);
        this.numShapelets = this.kShapelets.size();
        this.recordShapelets(this.kShapelets, this.ouputFileLocation);
        this.printShapelets(this.kShapelets);
        return this.kShapelets;
    }

    private ArrayList<Shapelet> buildKShapeletsFromMap(Map<Double, ArrayList<Shapelet>> kShapeletsMap) {
        ArrayList<Shapelet> kShapelets = new ArrayList<Shapelet>();
        int numberOfClassVals = kShapeletsMap.keySet().size();
        int proportion = this.numShapelets / numberOfClassVals;
        for (ArrayList<Shapelet> list : kShapeletsMap.values()) {
            int i = 0;
            Iterator<Shapelet> it = list.iterator();
            while (it.hasNext() && i++ <= proportion) {
                kShapelets.add(it.next());
            }
        }
        return kShapelets;
    }
}

