/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters;

import utilities.ClassifierTools;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;

public class SummaryStats
extends SimpleBatchFilter {
    private int numMoments = 4;
    private static final long serialVersionUID = 1L;

    public void setNumMoments(int m) {
        this.numMoments = 4;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        for (int i = 0; i < inputFormat.numAttributes(); ++i) {
            if (inputFormat.classIndex() == i || inputFormat.attribute(i).isNumeric()) continue;
            throw new Exception("Non numeric attribute not allowed in SummaryStats");
        }
        FastVector<Attribute> atts = new FastVector<Attribute>();
        String source = inputFormat.relationName();
        for (int i = 0; i < this.numMoments; ++i) {
            String name = source + "Moment_" + (i + 1);
            atts.addElement(new Attribute(name));
        }
        atts.addElement(new Attribute(source + "MIN"));
        atts.addElement(new Attribute(source + "MAX"));
        if (inputFormat.classIndex() >= 0) {
            Attribute target = inputFormat.attribute(inputFormat.classIndex());
            FastVector<String> vals = new FastVector<String>(target.numValues());
            for (int i = 0; i < target.numValues(); ++i) {
                vals.addElement(target.value(i));
            }
            atts.addElement(new Attribute(inputFormat.attribute(inputFormat.classIndex()).name(), vals));
        }
        Instances result = new Instances("Moments" + inputFormat.relationName(), atts, inputFormat.numInstances());
        if (inputFormat.classIndex() >= 0) {
            result.setClassIndex(result.numAttributes() - 1);
        }
        return result;
    }

    @Override
    public String globalInfo() {
        return null;
    }

    @Override
    public Instances process(Instances inst) throws Exception {
        Instances output = this.determineOutputFormat(inst);
        int seriesLength = inst.numAttributes();
        if (inst.classIndex() >= 0) {
            --seriesLength;
        }
        for (int i = 0; i < inst.numInstances(); ++i) {
            double standardDeviation;
            double[] d = inst.instance(i).toDoubleArray();
            int c = inst.classIndex();
            if (c >= 0) {
                double[] temp = new double[d.length - 1];
                System.arraycopy(d, 0, temp, 0, c);
                d = temp;
            }
            double[] moments = new double[this.numMoments + 2];
            double max = -1.7976931348623157E308;
            double min = Double.MAX_VALUE;
            double sum = 0.0;
            for (int j = 0; j < d.length; ++j) {
                sum += d[j];
                if (d[j] > max) {
                    max = d[j];
                }
                if (!(d[j] < min)) continue;
                min = d[j];
            }
            moments[0] = sum / (double)d.length;
            double totalVar = 0.0;
            double totalSkew = 0.0;
            double totalKur = 0.0;
            for (int j = 0; j < d.length; ++j) {
                totalVar += (d[j] - moments[0]) * (d[j] - moments[0]);
                totalSkew += (d[j] - moments[0]) * (d[j] - moments[0]) * (d[j] - moments[0]);
                totalKur += (d[j] - moments[0]) * (d[j] - moments[0]) * (d[j] - moments[0]) * (d[j] - moments[0]);
            }
            moments[1] = totalVar / (double)(d.length - 1);
            moments[1] = standardDeviation = Math.sqrt(moments[1]);
            double skew = totalSkew / (standardDeviation * standardDeviation * standardDeviation);
            moments[2] = skew / (double)d.length;
            double kur = totalKur / (standardDeviation * standardDeviation * standardDeviation * standardDeviation);
            moments[3] = kur / (double)d.length;
            DenseInstance newInst = null;
            newInst = inst.classIndex() >= 0 ? new DenseInstance(this.numMoments + 2 + 1) : new DenseInstance(this.numMoments + 2);
            for (int j = 0; j < this.numMoments; ++j) {
                newInst.setValue(j, moments[j]);
            }
            newInst.setValue(this.numMoments, min);
            newInst.setValue(this.numMoments + 1, max);
            if (inst.classIndex() >= 0) {
                newInst.setValue(output.classIndex(), inst.instance(i).classValue());
            }
            output.add(newInst);
        }
        return output;
    }

    @Override
    public String getRevision() {
        return null;
    }

    public static void main(String[] args) {
        try {
            Instances test = ClassifierTools.loadData("C:\\Users\\ajb\\Dropbox\\TSC Problems\\Beef\\Beef_TRAIN");
            SummaryStats m = new SummaryStats();
            m.setInputFormat(test);
            Instances filter = Filter.useFilter(test, m);
            System.out.println(filter);
        }
        catch (Exception e) {
            System.out.println("Exception thrown =" + e);
            e.printStackTrace();
        }
    }
}

