/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters;

import timeseriesweka.filters.PAA;
import utilities.ClassifierTools;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.NormalizeCase;
import weka.filters.SimpleBatchFilter;

public class SAX
extends SimpleBatchFilter {
    private int numIntervals = 8;
    private int alphabetSize = 4;
    private boolean useRealAttributes = false;
    private FastVector alphabet = null;
    private Instances inputFormat;
    private static final long serialVersionUID = 1L;
    private static final String[] alphabetSymbols = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j"};

    public int getNumIntervals() {
        return this.numIntervals;
    }

    public int getAlphabetSize() {
        return this.alphabetSize;
    }

    public FastVector getAlphabet() {
        if (this.alphabet == null) {
            this.generateAlphabet();
        }
        return this.alphabet;
    }

    public static FastVector getAlphabet(int alphabetSize) {
        FastVector<String> alphabet = new FastVector<String>();
        for (int i = 0; i < alphabetSize; ++i) {
            alphabet.addElement(alphabetSymbols[i]);
        }
        return alphabet;
    }

    public void setNumIntervals(int intervals) {
        this.numIntervals = intervals;
    }

    public void setAlphabetSize(int alphasize) {
        this.alphabetSize = alphasize;
    }

    public void useRealValuedAttributes(boolean b) {
        this.useRealAttributes = b;
    }

    public void generateAlphabet() {
        this.alphabet = new FastVector();
        for (int i = 0; i < this.alphabetSize; ++i) {
            this.alphabet.addElement(alphabetSymbols[i]);
        }
    }

    public double[] generateBreakpoints(int alphabetSize) throws Exception {
        double maxVal = Double.MAX_VALUE;
        double[] breakpoints = null;
        switch (alphabetSize) {
            case 2: {
                breakpoints = new double[]{0.0, maxVal};
                break;
            }
            case 3: {
                breakpoints = new double[]{-0.43, 0.43, maxVal};
                break;
            }
            case 4: {
                breakpoints = new double[]{-0.67, 0.0, 0.67, maxVal};
                break;
            }
            case 5: {
                breakpoints = new double[]{-0.84, -0.25, 0.25, 0.84, maxVal};
                break;
            }
            case 6: {
                breakpoints = new double[]{-0.97, -0.43, 0.0, 0.43, 0.97, maxVal};
                break;
            }
            case 7: {
                breakpoints = new double[]{-1.07, -0.57, -0.18, 0.18, 0.57, 1.07, maxVal};
                break;
            }
            case 8: {
                breakpoints = new double[]{-1.15, -0.67, -0.32, 0.0, 0.32, 0.67, 1.15, maxVal};
                break;
            }
            case 9: {
                breakpoints = new double[]{-1.22, -0.76, -0.43, -0.14, 0.14, 0.43, 0.76, 1.22, maxVal};
                break;
            }
            case 10: {
                breakpoints = new double[]{-1.28, -0.84, -0.52, -0.25, 0.0, 0.25, 0.52, 0.84, 1.28, maxVal};
                break;
            }
            default: {
                throw new Exception("No breakpoints stored for alphabet size " + alphabetSize);
            }
        }
        return breakpoints;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        for (int i = 0; i < inputFormat.numAttributes(); ++i) {
            if (inputFormat.classIndex() == i || inputFormat.attribute(i).isNumeric()) continue;
            throw new Exception("Non numeric attribute not allowed for SAX conversion");
        }
        FastVector<Attribute> attributes = new FastVector<Attribute>();
        if (!this.useRealAttributes) {
            this.generateAlphabet();
        }
        for (int i = 0; i < this.numIntervals; ++i) {
            String name = "SAXInterval_" + i;
            Attribute att = !this.useRealAttributes ? new Attribute(name, this.alphabet) : new Attribute(name);
            attributes.addElement(att);
        }
        if (inputFormat.classIndex() >= 0) {
            Attribute target = inputFormat.attribute(inputFormat.classIndex());
            FastVector<String> vals = new FastVector<String>(target.numValues());
            for (int i = 0; i < target.numValues(); ++i) {
                vals.addElement(target.value(i));
            }
            attributes.addElement(new Attribute(inputFormat.attribute(inputFormat.classIndex()).name(), vals));
        }
        Instances result = new Instances("SAX" + inputFormat.relationName(), attributes, inputFormat.numInstances());
        if (inputFormat.classIndex() >= 0) {
            result.setClassIndex(result.numAttributes() - 1);
        }
        return result;
    }

    @Override
    public String globalInfo() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Instances process(Instances input) throws Exception {
        this.inputFormat = new Instances(input, 0);
        Instances inputCopy = new Instances(input);
        Instances output = this.determineOutputFormat(input);
        PAA paa = new PAA();
        paa.setNumIntervals(this.numIntervals);
        inputCopy = paa.process(inputCopy);
        for (int i = 0; i < inputCopy.numInstances(); ++i) {
            double[] data = inputCopy.instance(i).toDoubleArray();
            int c = inputCopy.classIndex();
            if (c >= 0) {
                double[] temp = new double[data.length - 1];
                System.arraycopy(data, 0, temp, 0, c);
                data = temp;
            }
            this.convertSequence(data);
            DenseInstance newInstance = input.classIndex() >= 0 ? new DenseInstance(this.numIntervals + 1) : new DenseInstance(this.numIntervals);
            for (int j = 0; j < this.numIntervals; ++j) {
                newInstance.setValue(j, data[j]);
            }
            if (inputCopy.classIndex() >= 0) {
                newInstance.setValue(output.classIndex(), inputCopy.instance(i).classValue());
            }
            output.add(newInstance);
        }
        return output;
    }

    public void convertSequence(double[] data) throws Exception {
        double[] gaussianBreakpoints = this.generateBreakpoints(this.alphabetSize);
        block0: for (int i = 0; i < this.numIntervals; ++i) {
            for (int j = 0; j < this.alphabetSize; ++j) {
                if (!(data[i] < gaussianBreakpoints[j])) continue;
                data[i] = j;
                continue block0;
            }
        }
    }

    public static double[] convertSequence(double[] data, int alphabetSize, int numIntervals) throws Exception {
        SAX sax = new SAX();
        sax.setNumIntervals(numIntervals);
        sax.setAlphabetSize(alphabetSize);
        sax.useRealValuedAttributes(true);
        double[] d = PAA.convertInstance(data, numIntervals);
        sax.convertSequence(d);
        return d;
    }

    public Instance convertInstance(Instance inst, int alphabetSize, int numIntervals) throws Exception {
        Instances newInsts = new Instances(this.inputFormat, 1);
        newInsts.add(inst);
        newInsts = this.process(newInsts);
        return newInsts.firstInstance();
    }

    @Override
    public String getRevision() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void main(String[] args) {
        System.out.println("SAXtest\n\n");
        try {
            Instances test = ClassifierTools.loadData("C:\\tempbakeoff\\TSC Problems\\Car\\Car_TEST.arff");
            new NormalizeCase().standardNorm(test);
            SAX sax = new SAX();
            sax.setNumIntervals(2);
            sax.setAlphabetSize(3);
            sax.useRealValuedAttributes(false);
            Instances result = sax.process(test);
            System.out.println(test);
            System.out.println("\n\n\nResults:\n\n");
            System.out.println(result);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }
}

