/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters;

import timeseriesweka.filters.FFT;
import timeseriesweka.filters.PowerSpectrum;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class PowerCepstrum
extends PowerSpectrum {
    @Override
    public String globalInfo() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        int length = this.fftFilter.findLength(inputFormat);
        length /= 2;
        FastVector<Attribute> atts = new FastVector<Attribute>();
        for (int i = 0; i < length; ++i) {
            String name = "PowerSpectrum_" + i;
            atts.addElement(new Attribute(name));
        }
        if (inputFormat.classIndex() >= 0) {
            Attribute target = inputFormat.attribute(inputFormat.classIndex());
            FastVector<String> vals = new FastVector<String>(target.numValues());
            for (int i = 0; i < target.numValues(); ++i) {
                vals.addElement(target.value(i));
            }
            atts.addElement(new Attribute(inputFormat.attribute(inputFormat.classIndex()).name(), vals));
        }
        Instances result = new Instances("Cepstrum" + inputFormat.relationName(), atts, inputFormat.numInstances());
        if (inputFormat.classIndex() >= 0) {
            result.setClassIndex(result.numAttributes() - 1);
        }
        return result;
    }

    @Override
    public Instances process(Instances instances) throws Exception {
        Instances output = this.determineOutputFormat(instances);
        output = super.process(instances);
        this.logDataSet(output);
        for (int i = 0; i < output.numInstances(); ++i) {
            int j;
            Instance next = output.instance(i);
            double[] ar = next.toDoubleArray();
            FFT.Complex[] complex = new FFT.Complex[ar.length - 1];
            for (j = 0; j < ar.length - 1; ++j) {
                complex[i] = new FFT.Complex(ar[i], 0.0);
            }
            this.inverseFFT(complex, complex.length);
            for (j = 0; j < complex.length; ++j) {
                next.setValue(j, (double)(complex[i].real * complex[i].real + complex[i].imag * complex[i].imag));
            }
        }
        return output;
    }

    public void logDataSet(Instances out) {
        for (int i = 0; i < out.numInstances(); ++i) {
            Instance ins = out.instance(i);
            for (int j = 0; j < ins.numAttributes(); ++j) {
                if (j == ins.classIndex()) continue;
                ins.setValue(j, Math.log(ins.value(j)));
            }
        }
    }
}

