/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters;

import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instances;
import weka.filters.SimpleBatchFilter;

public class DerivativeFilter
extends SimpleBatchFilter {
    @Override
    public String globalInfo() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        int numAttributes = inputFormat.numAttributes();
        FastVector<Attribute> atts = new FastVector<Attribute>();
        for (int i = 0; i < numAttributes - 1; ++i) {
            String name = "Attribute_" + i;
            atts.addElement(new Attribute(name));
        }
        if (inputFormat.classIndex() >= 0) {
            Attribute target = inputFormat.attribute(inputFormat.classIndex());
            FastVector<String> vals = new FastVector<String>(target.numValues());
            for (int i = 0; i < target.numValues(); ++i) {
                vals.addElement(target.value(i));
            }
            atts.addElement(new Attribute(inputFormat.attribute(inputFormat.classIndex()).name(), vals));
        }
        Instances result = new Instances("derivativeTransform_" + inputFormat.relationName(), atts, inputFormat.numInstances());
        if (inputFormat.classIndex() >= 0) {
            result.setClassIndex(result.numAttributes() - 1);
        }
        return result;
    }

    @Override
    public Instances process(Instances data) throws Exception {
        Instances output = this.determineOutputFormat(data);
        for (int i = 0; i < data.numInstances(); ++i) {
            DenseInstance toAdd = new DenseInstance(data.numAttributes());
            double[] rawData = data.instance(i).toDoubleArray();
            double[] derivative = DerivativeFilter.getDerivative(rawData, true);
            for (int j = 0; j < derivative.length; ++j) {
                toAdd.setValue(j, derivative[j]);
            }
            toAdd.setValue(derivative.length, data.instance(i).classValue());
            output.add(toAdd);
        }
        return output;
    }

    private static double[] getDerivative(double[] input, boolean classValOn) {
        int classPenalty = 0;
        if (classValOn) {
            classPenalty = 1;
        }
        double[] derivative = new double[input.length - classPenalty];
        for (int i = 1; i < input.length - 1 - classPenalty; ++i) {
            derivative[i] = (input[i] - input[i - 1] + (input[i + 1] - input[i - 1]) / 2.0) / 2.0;
        }
        derivative[0] = derivative[1];
        derivative[derivative.length - 1] = derivative[derivative.length - 2];
        return derivative;
    }
}

