/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.elastic_distance_measures;

import timeseriesweka.elastic_distance_measures.DTW_DistanceBasic;
import weka.core.Instances;

public class DTW_DistanceEfficient
extends DTW_DistanceBasic {
    double[] row1;
    double[] row2;

    public DTW_DistanceEfficient() {
        this.m_DontNormalize = true;
    }

    public DTW_DistanceEfficient(Instances data) {
        super(data);
        this.m_DontNormalize = true;
    }

    @Override
    public double distance(double[] a, double[] b, double cutoff) {
        int j;
        boolean tooBig = true;
        if (a.length < b.length) {
            double[] temp = a;
            a = b;
            b = temp;
        }
        int n = a.length;
        int m = b.length;
        int windowSize = this.getWindowSize(m);
        this.row1 = new double[m];
        this.row2 = new double[m];
        this.row1[0] = (a[0] - b[0]) * (a[0] - b[0]);
        if (this.row1[0] < cutoff) {
            tooBig = false;
        }
        for (j = 1; j < n && j <= windowSize; ++j) {
            this.row1[j] = Double.MAX_VALUE;
        }
        for (j = 1; j < windowSize && j < m; ++j) {
            this.row1[j] = this.row1[j - 1] + (a[0] - b[j]) * (a[0] - b[j]);
            if (!(this.row1[j] < cutoff)) continue;
            tooBig = false;
        }
        if (tooBig) {
            return Double.MAX_VALUE;
        }
        for (int i = 1; i < n; ++i) {
            tooBig = true;
            this.row2 = new double[m];
            int start = i - windowSize < 1 ? 0 : i - windowSize + 1;
            if (start == 0) {
                this.row2[0] = this.row1[0] + (a[i] - b[0]) * (a[i] - b[0]);
                start = 1;
            } else {
                this.row2[start - 1] = Double.MAX_VALUE;
            }
            int end = start + windowSize >= m ? m : start + windowSize;
            for (int j2 = start; j2 < end; ++j2) {
                double minDist = this.row2[j2 - 1];
                if (this.row1[j2] < minDist) {
                    minDist = this.row1[j2];
                }
                if (this.row1[j2 - 1] < minDist) {
                    minDist = this.row1[j2 - 1];
                }
                this.row2[j2] = minDist + (a[i] - b[j2]) * (a[i] - b[j2]);
                if (!tooBig || !(this.row2[j2] < cutoff)) continue;
                tooBig = false;
            }
            if (end < m) {
                this.row2[end] = Double.MAX_VALUE;
            }
            this.row1 = this.row2;
            if (!tooBig) continue;
            return Double.MAX_VALUE;
        }
        return this.row1[m - 1];
    }

    @Override
    public String toString() {
        return "DTW EFFICIENT";
    }

    public static void main(String[] args) {
        DTW_DistanceBasic b = new DTW_DistanceBasic();
        DTW_DistanceEfficient c = new DTW_DistanceEfficient();
        double[] a1 = new double[]{1.0, 1.0, 1.0, 6.0};
        double[] a2 = new double[]{1.0, 6.0, 6.0, 6.0};
        b.setR(0.0);
        c.setR(0.0);
        System.out.println("***************** TEST 1: Two small arrays *******************");
        System.out.println("\nZero warp full matrix =" + b.distance(a1, a2, Double.MAX_VALUE));
        System.out.println("Zero warp limited matrix =" + c.distance(a1, a2, Double.MAX_VALUE));
        b.setR(1.0);
        c.setR(1.0);
        System.out.println("\nFull warp full matrix =" + b.distance(a1, a2, Double.MAX_VALUE));
        System.out.println("Full warp limited matrix =" + c.distance(a1, a2, Double.MAX_VALUE));
        b.setR(0.25);
        c.setR(0.25);
        System.out.println("\nQuarter warp full matrix =" + b.distance(a1, a2, Double.MAX_VALUE));
        System.out.println("Quarter warp limited matrix =" + c.distance(a1, a2, Double.MAX_VALUE));
        System.out.println("***************** TEST2: Longer arrays *******************");
        double[] a3 = new double[]{1.0, 10.0, 11.0, 15.0, 1.0, 2.0, 4.0, 56.0, 6.0, 7.0, 8.0};
        double[] a4 = new double[]{10.0, 11.0, 10.0, 1.0, 1.0, 2.0, 4.0, 56.0, 6.0, 7.0, 8.0};
        double d = 0.0;
        for (int i = 0; i < a3.length; ++i) {
            d += (a3[i] - a4[i]) * (a3[i] - a4[i]);
        }
        System.out.println("\nEuclidean distance =" + d);
        b.setR(0.0);
        c.setR(0.0);
        System.out.println("Zero warp full matrix =" + b.distance(a3, a4, Double.MAX_VALUE));
        System.out.println("Zero warp limited matrix =" + c.distance(a3, a4, 100.0));
        b.setR(1.0);
        c.setR(1.0);
        System.out.println("\nFull warp full matrix =" + b.distance(a3, a4, 100.0));
        System.out.println("Full warp limited matrix =" + c.distance(a3, a4, 100.0));
        b.setR(0.25);
        c.setR(0.25);
        System.out.println("\nQuarter warp full matrix =" + b.distance(a3, a4, Double.MAX_VALUE));
        System.out.println("Quarter warp limited matrix =" + c.distance(a3, a4, Double.MAX_VALUE));
        b.setR(0.5);
        c.setR(0.5);
        System.out.println("Half warp full matrix =" + b.distance(a3, a4, Double.MAX_VALUE));
        System.out.println("Half warp limited matrix =" + c.distance(a3, a4, Double.MAX_VALUE));
        System.out.println("***************** TEST3: Variable length arrays *******************");
        System.out.println("NOT IMPLEMENTED FOR VARIABLE LENGTH");
    }
}

