/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.ensembles.weightings;

import timeseriesweka.classifiers.ensembles.EnsembleModule;
import timeseriesweka.classifiers.ensembles.weightings.ModuleWeightingScheme;

public class NLL
extends ModuleWeightingScheme {
    private double power = 1.0;

    public NLL() {
        this.uniformWeighting = true;
        this.needTrainPreds = true;
    }

    public NLL(double power) {
        this.power = power;
        this.uniformWeighting = true;
        this.needTrainPreds = true;
    }

    public double getPower() {
        return this.power;
    }

    public void setPower(double power) {
        this.power = power;
    }

    @Override
    public void defineWeightings(EnsembleModule[] modules, int numClasses) {
        int i;
        double[] nlls = new double[modules.length];
        double sum = 0.0;
        for (i = 0; i < nlls.length; ++i) {
            nlls[i] = Math.pow(modules[i].trainResults.findNLL(), this.power);
            sum += nlls[i];
        }
        for (i = 0; i < nlls.length; ++i) {
            int n = i;
            nlls[n] = nlls[n] / sum;
            nlls[i] = 1.0 - nlls[i];
            modules[i].posteriorWeights = this.makeUniformWeighting(nlls[i], numClasses);
        }
    }

    @Override
    public double[] defineWeighting(EnsembleModule module, int numClasses) {
        throw new UnsupportedOperationException("NLL weighting cannot be defined for a single module, only in relation to the rest, call defineWeighings(...)");
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + (this.power == 1.0 ? "" : "(" + this.power + ")");
    }
}

