/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.ensembles.weightings;

import timeseriesweka.classifiers.ensembles.EnsembleModule;
import timeseriesweka.classifiers.ensembles.weightings.ModuleWeightingScheme;

public class MaxCorrectedTrainAcc
extends ModuleWeightingScheme {
    double maxClassWeighting;

    public MaxCorrectedTrainAcc() {
        this.uniformWeighting = true;
        this.needTrainPreds = true;
    }

    @Override
    public void defineWeightings(EnsembleModule[] modules, int numClasses) {
        int i;
        double[] classDist = new double[numClasses];
        for (i = 0; i < modules[0].trainResults.getTrueClassVals().length; ++i) {
            int n = (int)modules[0].trainResults.getTrueClassVals()[i];
            classDist[n] = classDist[n] + 1.0;
        }
        this.maxClassWeighting = classDist[0];
        for (i = 1; i < classDist.length; ++i) {
            if (!(classDist[i] > this.maxClassWeighting)) continue;
            this.maxClassWeighting = classDist[i];
        }
        for (EnsembleModule m : modules) {
            m.posteriorWeights = this.defineWeighting(m, numClasses);
        }
    }

    @Override
    public double[] defineWeighting(EnsembleModule module, int numClasses) {
        return this.makeUniformWeighting(Math.max(0.01, module.trainResults.acc - this.maxClassWeighting), numClasses);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }
}

