/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.ensembles.weightings;

import timeseriesweka.classifiers.ensembles.EnsembleModule;
import timeseriesweka.classifiers.ensembles.weightings.ModuleWeightingScheme;

public class MCCWeighting
extends ModuleWeightingScheme {
    public MCCWeighting() {
        this.uniformWeighting = true;
    }

    @Override
    public double[] defineWeighting(EnsembleModule module, int numClasses) {
        double weight = (this.computeMCC(module.trainResults.confusionMatrix) + 1.0) / 2.0;
        return this.makeUniformWeighting(weight, numClasses);
    }

    public double computeMCC(double[][] confusionMatrix) {
        double num = 0.0;
        for (int k = 0; k < confusionMatrix.length; ++k) {
            for (int l = 0; l < confusionMatrix.length; ++l) {
                for (int m = 0; m < confusionMatrix.length; ++m) {
                    num += confusionMatrix[k][k] * confusionMatrix[m][l] - confusionMatrix[l][k] * confusionMatrix[k][m];
                }
            }
        }
        if (num == 0.0) {
            return 0.0;
        }
        double den1 = 0.0;
        double den2 = 0.0;
        for (int k = 0; k < confusionMatrix.length; ++k) {
            double den1Part1 = 0.0;
            double den2Part1 = 0.0;
            for (int l = 0; l < confusionMatrix.length; ++l) {
                den1Part1 += confusionMatrix[l][k];
                den2Part1 += confusionMatrix[k][l];
            }
            double den1Part2 = 0.0;
            double den2Part2 = 0.0;
            for (int kp = 0; kp < confusionMatrix.length; ++kp) {
                if (kp == k) continue;
                for (int lp = 0; lp < confusionMatrix.length; ++lp) {
                    den1Part2 += confusionMatrix[lp][kp];
                    den2Part2 += confusionMatrix[kp][lp];
                }
            }
            den1 += den1Part1 * den1Part2;
            den2 += den2Part1 * den2Part2;
        }
        return num / (Math.sqrt(den1) * Math.sqrt(den2));
    }
}

