/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.ensembles.voting;

import timeseriesweka.classifiers.ensembles.EnsembleModule;
import timeseriesweka.classifiers.ensembles.voting.MajorityVote;

public class NP_MAX
extends MajorityVote {
    protected double sigma = 1.0;

    public NP_MAX() {
    }

    public NP_MAX(int numClasses) {
        super(numClasses);
    }

    public NP_MAX(double sigma) {
        this.sigma = sigma;
    }

    public NP_MAX(double sigma, int numClasses) {
        super(numClasses);
        this.sigma = sigma;
    }

    @Override
    public void trainVotingScheme(EnsembleModule[] modules, int numClasses) {
        this.numClasses = numClasses;
        for (int c = 0; c < numClasses; ++c) {
            int m;
            double norm = 0.0;
            double np_max = modules[0].posteriorWeights[c];
            for (int m2 = 1; m2 < modules.length; ++m2) {
                if (!(modules[m2].posteriorWeights[c] > np_max)) continue;
                np_max = modules[m2].posteriorWeights[c];
            }
            double[] newWeights = new double[modules.length];
            for (m = 0; m < modules.length; ++m) {
                newWeights[m] = Math.pow(1.0 / this.sigma * Math.sqrt(Math.PI * 2), (-modules[m].posteriorWeights[c] - np_max) / 2.0 * this.sigma * this.sigma);
                norm += newWeights[m];
            }
            for (m = 0; m < modules.length; ++m) {
                modules[m].posteriorWeights[c] = newWeights[m] / norm;
            }
        }
    }
}

