/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.ensembles.voting;

import timeseriesweka.classifiers.ensembles.EnsembleModule;
import timeseriesweka.classifiers.ensembles.voting.ModuleVotingScheme;
import weka.core.Instance;

public class MajorityVote
extends ModuleVotingScheme {
    public MajorityVote() {
    }

    public MajorityVote(int numClasses) {
        this.numClasses = numClasses;
    }

    @Override
    public void trainVotingScheme(EnsembleModule[] modules, int numClasses) {
        this.numClasses = numClasses;
    }

    @Override
    public double[] distributionForTrainInstance(EnsembleModule[] modules, int trainInstanceIndex) {
        double[] preds = new double[this.numClasses];
        for (int c = 0; c < modules.length; ++c) {
            int pred;
            int n = pred = (int)modules[c].trainResults.getPredClassValue(trainInstanceIndex);
            preds[n] = preds[n] + modules[c].priorWeight * modules[c].posteriorWeights[pred];
        }
        return this.normalise(preds);
    }

    @Override
    public double[] distributionForTestInstance(EnsembleModule[] modules, int testInstanceIndex) {
        double[] preds = new double[this.numClasses];
        for (int c = 0; c < modules.length; ++c) {
            int pred;
            int n = pred = (int)modules[c].testResults.getPredClassValue(testInstanceIndex);
            preds[n] = preds[n] + modules[c].priorWeight * modules[c].posteriorWeights[pred];
        }
        return this.normalise(preds);
    }

    @Override
    public double[] distributionForInstance(EnsembleModule[] modules, Instance testInstance) throws Exception {
        double[] preds = new double[this.numClasses];
        for (int m = 0; m < modules.length; ++m) {
            int pred;
            double[] dist = modules[m].getClassifier().distributionForInstance(testInstance);
            this.storeModuleTestResult(modules[m], dist);
            int n = pred = (int)this.indexOfMax(dist);
            preds[n] = preds[n] + modules[m].priorWeight * modules[m].posteriorWeights[pred];
        }
        return this.normalise(preds);
    }
}

