/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.ensembles.voting;

import timeseriesweka.classifiers.ensembles.EnsembleModule;
import timeseriesweka.classifiers.ensembles.voting.ModuleVotingScheme;
import weka.core.Instance;

public class MajorityConfidence
extends ModuleVotingScheme {
    public MajorityConfidence() {
    }

    public MajorityConfidence(int numClasses) {
        this.numClasses = numClasses;
    }

    @Override
    public void trainVotingScheme(EnsembleModule[] modules, int numClasses) {
        this.numClasses = numClasses;
    }

    @Override
    public double[] distributionForTrainInstance(EnsembleModule[] modules, int trainInstanceIndex) {
        double[] preds = new double[this.numClasses];
        for (int m = 0; m < modules.length; ++m) {
            double[] p = modules[m].trainResults.getDistributionForInstance(trainInstanceIndex);
            for (int c = 0; c < this.numClasses; ++c) {
                int n = c;
                preds[n] = preds[n] + modules[m].priorWeight * modules[m].posteriorWeights[c] * p[c];
            }
        }
        return this.normalise(preds);
    }

    @Override
    public double[] distributionForTestInstance(EnsembleModule[] modules, int testInstanceIndex) {
        double[] preds = new double[this.numClasses];
        for (int m = 0; m < modules.length; ++m) {
            double[] p = modules[m].testResults.getDistributionForInstance(testInstanceIndex);
            for (int c = 0; c < this.numClasses; ++c) {
                int n = c;
                preds[n] = preds[n] + modules[m].priorWeight * modules[m].posteriorWeights[c] * p[c];
            }
        }
        return this.normalise(preds);
    }

    @Override
    public double[] distributionForInstance(EnsembleModule[] modules, Instance testInstance) throws Exception {
        double[] preds = new double[this.numClasses];
        for (int m = 0; m < modules.length; ++m) {
            double[] dist = modules[m].getClassifier().distributionForInstance(testInstance);
            this.storeModuleTestResult(modules[m], dist);
            for (int c = 0; c < this.numClasses; ++c) {
                int n = c;
                preds[n] = preds[n] + modules[m].priorWeight * modules[m].posteriorWeights[c] * dist[c];
            }
        }
        return this.normalise(preds);
    }
}

