/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.ensembles.elastic_ensemble;

import java.io.File;
import java.io.FileWriter;
import java.text.DecimalFormat;
import java.util.Scanner;
import utilities.ClassifierTools;
import utilities.InstanceTools;
import weka.classifiers.AbstractClassifier;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public abstract class Efficient1NN
extends AbstractClassifier {
    protected Instances train;
    protected Instances[] trainGroup;
    protected String classifierIdentifier;
    protected boolean allowLoocv = true;
    protected boolean singleParamCv = false;
    private boolean fileWriting = false;
    private boolean individualCvParamFileWriting = false;
    private String outputDir;
    private String datasetName;
    private int resampleId;
    DecimalFormat df = new DecimalFormat("##.###");

    public abstract double distance(Instance var1, Instance var2, double var3);

    public double distance(Instance[] first, Instance[] second, double cutOffValue) {
        double sum = 0.0;
        double decliningCutoff = cutOffValue;
        for (int d = 0; d < first.length; ++d) {
            double thisDist = this.distance(first[d], second[d], decliningCutoff);
            if ((sum += thisDist) > cutOffValue) {
                return Double.MAX_VALUE;
            }
            decliningCutoff -= thisDist;
        }
        return sum;
    }

    public abstract void setParamsFromParamId(Instances var1, int var2);

    @Override
    public void buildClassifier(Instances train) throws Exception {
        this.train = train;
        this.trainGroup = null;
    }

    public void buildClassifier(Instances[] trainGroup) throws Exception {
        this.train = null;
        this.trainGroup = trainGroup;
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        double bsfDistance = Double.MAX_VALUE;
        int[] classCounts = new int[this.train.numClasses()];
        for (Instance i : this.train) {
            double thisDist = this.distance(instance, i, bsfDistance);
            if (thisDist < bsfDistance) {
                bsfDistance = thisDist;
                classCounts = new int[this.train.numClasses()];
                int n = (int)i.classValue();
                classCounts[n] = classCounts[n] + 1;
                continue;
            }
            if (thisDist != bsfDistance) continue;
            int n = (int)i.classValue();
            classCounts[n] = classCounts[n] + 1;
        }
        double bsfClass = -1.0;
        double bsfCount = -1.0;
        for (int c = 0; c < classCounts.length; ++c) {
            if (!((double)classCounts[c] > bsfCount)) continue;
            bsfCount = classCounts[c];
            bsfClass = c;
        }
        return bsfClass;
    }

    public double classifyInstanceMultivariate(Instance[] instance) throws Exception {
        if (this.trainGroup == null) {
            throw new Exception("Error: this configuration is for multivariate data");
        }
        double bsfDistance = Double.MAX_VALUE;
        int[] classCounts = new int[this.trainGroup[0].numClasses()];
        for (int i = 0; i < this.trainGroup[0].numInstances(); ++i) {
            Instance[] trainInstancesByDimension = new Instance[this.trainGroup.length];
            for (int j = 0; j < trainInstancesByDimension.length; ++j) {
                trainInstancesByDimension[j] = this.trainGroup[j].instance(i);
            }
            double thisDist = this.distance(instance, trainInstancesByDimension, bsfDistance);
            if (thisDist < bsfDistance) {
                bsfDistance = thisDist;
                classCounts = new int[this.trainGroup[0].numClasses()];
                int n = (int)this.trainGroup[0].instance(i).classValue();
                classCounts[n] = classCounts[n] + 1;
                continue;
            }
            if (thisDist != bsfDistance) continue;
            int n = (int)this.trainGroup[0].instance(i).classValue();
            classCounts[n] = classCounts[n] + 1;
        }
        double bsfClass = -1.0;
        double bsfCount = -1.0;
        for (int c = 0; c < classCounts.length; ++c) {
            if (!((double)classCounts[c] > bsfCount)) continue;
            bsfCount = classCounts[c];
            bsfClass = c;
        }
        return bsfClass;
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        double bsfDistance = Double.MAX_VALUE;
        int[] classCounts = new int[this.train.numClasses()];
        int sumOfBest = 0;
        for (Instance i : this.train) {
            double thisDist = this.distance(instance, i, bsfDistance);
            if (thisDist < bsfDistance) {
                bsfDistance = thisDist;
                classCounts = new int[this.train.numClasses()];
                int n = (int)i.classValue();
                classCounts[n] = classCounts[n] + 1;
                sumOfBest = 1;
                continue;
            }
            if (thisDist != bsfDistance) continue;
            int n = (int)i.classValue();
            classCounts[n] = classCounts[n] + 1;
            ++sumOfBest;
        }
        double[] classDistributions = new double[this.train.numClasses()];
        for (int c = 0; c < classCounts.length; ++c) {
            classDistributions[c] = (double)classCounts[c] / (double)sumOfBest;
        }
        return classDistributions;
    }

    public void setClassifierIdentifier(String classifierIdentifier) {
        this.classifierIdentifier = classifierIdentifier;
    }

    public String getClassifierIdentifier() {
        return this.classifierIdentifier;
    }

    public void setFileWritingOn(String outputDir, String datasetName, int resampleId) {
        this.fileWriting = true;
        this.outputDir = outputDir;
        this.datasetName = datasetName;
        this.resampleId = resampleId;
    }

    public void setIndividualCvFileWritingOn(String outputDir, String datasetName, int resampleId) {
        this.individualCvParamFileWriting = true;
        this.outputDir = outputDir;
        this.datasetName = datasetName;
        this.resampleId = resampleId;
    }

    public double[] loocv(Instances train) throws Exception {
        double[] accAndPreds = null;
        String parsedFileName = this.outputDir + this.classifierIdentifier + "/Predictions/" + this.datasetName + "/trainFold" + this.resampleId + ".csv";
        if (this.fileWriting) {
            File existing = new File(parsedFileName);
            if (existing.exists()) {
                Scanner scan = new Scanner(existing);
                scan.useDelimiter("\n");
                scan.next();
                int paramId = Integer.parseInt(scan.next().trim().split(",")[0]);
                if (this.allowLoocv) {
                    this.setParamsFromParamId(train, paramId);
                }
                this.buildClassifier(train);
                accAndPreds = new double[train.numInstances() + 1];
                accAndPreds[0] = Double.parseDouble(scan.next().trim().split(",")[0]);
                int correct = 0;
                for (int i = 0; i < train.numInstances(); ++i) {
                    String[] temp = scan.next().split(",");
                    accAndPreds[i + 1] = Double.parseDouble(temp[1]);
                    if (accAndPreds[i + 1] != Double.parseDouble(temp[0])) continue;
                    ++correct;
                }
                return accAndPreds;
            }
            new File(this.outputDir + this.classifierIdentifier + "/Predictions/" + this.datasetName + "/").mkdirs();
        }
        double bsfAcc = -1.0;
        int bsfParamId = -1;
        double[] bsfaccAndPreds = null;
        for (int paramId = 0; paramId < 100; ++paramId) {
            accAndPreds = this.loocvAccAndPreds(train, paramId);
            if (accAndPreds[0] > bsfAcc) {
                bsfAcc = accAndPreds[0];
                bsfParamId = paramId;
                bsfaccAndPreds = accAndPreds;
            }
            if (this.allowLoocv) continue;
            paramId = 100;
        }
        this.buildClassifier(train);
        if (this.allowLoocv) {
            this.setParamsFromParamId(train, bsfParamId);
        }
        if (this.fileWriting) {
            FileWriter out = new FileWriter(parsedFileName);
            out.append(this.classifierIdentifier + "," + this.datasetName + ",parsedTrain\n");
            out.append(bsfParamId + "\n");
            out.append(bsfAcc + "\n");
            for (int i = 1; i < bsfaccAndPreds.length; ++i) {
                out.append(train.instance(i - 1).classValue() + "," + bsfaccAndPreds[i] + "\n");
            }
            out.close();
        }
        return bsfaccAndPreds;
    }

    public double[] loocv(Instances[] trainGroup) throws Exception {
        double[] accAndPreds = null;
        String parsedFileName = this.outputDir + this.classifierIdentifier + "/Predictions/" + this.datasetName + "/trainFold" + this.resampleId + ".csv";
        Instances concatenated = Efficient1NN.concatenate(trainGroup);
        if (this.fileWriting) {
            File existing = new File(parsedFileName);
            if (existing.exists()) {
                Scanner scan = new Scanner(existing);
                scan.useDelimiter("\n");
                scan.next();
                int paramId = Integer.parseInt(scan.next().trim().split(",")[0]);
                if (this.allowLoocv) {
                    this.setParamsFromParamId(concatenated, paramId);
                }
                this.buildClassifier(trainGroup);
                accAndPreds = new double[trainGroup[0].numInstances() + 1];
                accAndPreds[0] = Double.parseDouble(scan.next().trim().split(",")[0]);
                int correct = 0;
                for (int i = 0; i < trainGroup[0].numInstances(); ++i) {
                    String[] temp = scan.next().split(",");
                    accAndPreds[i + 1] = Double.parseDouble(temp[1]);
                    if (accAndPreds[i + 1] != Double.parseDouble(temp[0])) continue;
                    ++correct;
                }
                return accAndPreds;
            }
            new File(this.outputDir + this.classifierIdentifier + "/Predictions/" + this.datasetName + "/").mkdirs();
        }
        double bsfAcc = -1.0;
        int bsfParamId = -1;
        double[] bsfaccAndPreds = null;
        for (int paramId = 0; paramId < 100; ++paramId) {
            accAndPreds = this.loocvAccAndPreds(trainGroup, concatenated, paramId);
            if (accAndPreds[0] > bsfAcc) {
                bsfAcc = accAndPreds[0];
                bsfParamId = paramId;
                bsfaccAndPreds = accAndPreds;
            }
            System.out.println("\t" + paramId + ": " + this.df.format(accAndPreds[0] * 100.0) + " (" + this.df.format(bsfAcc * 100.0) + ")");
            if (this.allowLoocv) continue;
            paramId = 100;
        }
        this.buildClassifier(trainGroup);
        if (this.allowLoocv) {
            this.setParamsFromParamId(concatenated, bsfParamId);
        }
        if (this.fileWriting) {
            FileWriter out = new FileWriter(parsedFileName);
            out.append(this.classifierIdentifier + "," + this.datasetName + ",parsedTrain\n");
            out.append(bsfParamId + "\n");
            out.append(bsfAcc + "\n");
            for (int i = 1; i < bsfaccAndPreds.length; ++i) {
                out.append(trainGroup[0].instance(i - 1).classValue() + "," + bsfaccAndPreds[i] + "\n");
            }
            out.close();
        }
        return bsfaccAndPreds;
    }

    public double[] loocvAccAndPreds(Instances train, int paramId) throws Exception {
        int i;
        if (this.allowLoocv) {
            this.setParamsFromParamId(train, paramId);
        }
        FileWriter out = null;
        String parsedFileName = this.outputDir + this.classifierIdentifier + "/Predictions/" + this.datasetName + "/trainFold" + this.resampleId + ".csv";
        String singleFileName = this.outputDir + this.classifierIdentifier + "/cv/" + this.datasetName + "/trainFold" + this.resampleId + "/pid" + paramId + ".csv";
        if (this.individualCvParamFileWriting) {
            if (new File(parsedFileName).exists()) {
                throw new Exception("Error: Full parsed training results already exist - " + parsedFileName);
            }
            if (new File(singleFileName).exists()) {
                throw new Exception("Error: CV training results already exist for this pid - " + singleFileName);
            }
        }
        int correct = 0;
        double[] accAndPreds = new double[train.numInstances() + 1];
        for (i = 0; i < train.numInstances(); ++i) {
            Instances trainLoocv = new Instances(train);
            Instance testLoocv = trainLoocv.remove(i);
            double actual = testLoocv.classValue();
            this.buildClassifier(trainLoocv);
            double pred = this.classifyInstance(testLoocv);
            if (pred == actual) {
                ++correct;
            }
            accAndPreds[i + 1] = pred;
        }
        accAndPreds[0] = (double)correct / (double)train.numInstances();
        if (this.individualCvParamFileWriting) {
            new File(this.outputDir + this.classifierIdentifier + "/cv/" + this.datasetName + "/trainFold" + this.resampleId + "/").mkdirs();
            out = new FileWriter(singleFileName);
            out.append(this.classifierIdentifier + "," + this.datasetName + ",cv\n");
            out.append(paramId + "\n");
            out.append(accAndPreds[0] + "\n");
            for (i = 1; i < accAndPreds.length; ++i) {
                out.append(train.instance(i - 1).classValue() + "," + accAndPreds[i] + "\n");
            }
            out.close();
        }
        return accAndPreds;
    }

    public double[] loocvAccAndPreds(Instances[] trainGroup, Instances concatenated, int paramId) throws Exception {
        Object out = null;
        String parsedFileName = this.outputDir + this.classifierIdentifier + "/Predictions/" + this.datasetName + "/trainFold" + this.resampleId + ".csv";
        String singleFileName = this.outputDir + this.classifierIdentifier + "/cv/" + this.datasetName + "/trainFold" + this.resampleId + "/pid" + paramId + ".csv";
        if (this.allowLoocv) {
            this.setParamsFromParamId(concatenated, paramId);
        }
        int correct = 0;
        double[] accAndPreds = new double[trainGroup[0].numInstances() + 1];
        for (int i = 0; i < trainGroup[0].numInstances(); ++i) {
            Instances[] trainLoocv = new Instances[trainGroup.length];
            Instance[] testLoocv = new Instance[trainGroup.length];
            for (int d = 0; d < trainGroup.length; ++d) {
                trainLoocv[d] = new Instances(trainGroup[d]);
                testLoocv[d] = trainLoocv[d].remove(i);
            }
            double actual = testLoocv[0].classValue();
            this.buildClassifier(trainLoocv);
            double pred = this.classifyInstanceMultivariate(testLoocv);
            if (pred == actual) {
                ++correct;
            }
            accAndPreds[i + 1] = pred;
        }
        accAndPreds[0] = (double)correct / (double)trainGroup[0].numInstances();
        return accAndPreds;
    }

    public void writeTrainTestOutput(String tscProblemDir, String datasetName, int resampleId, String outputResultsDir) throws Exception {
        File cvResults = new File(outputResultsDir + this.classifierIdentifier + "/Predictions/" + datasetName + "/trainFold" + resampleId + ".csv");
        if (!cvResults.exists()) {
            throw new Exception("Error loading file " + cvResults.getAbsolutePath());
        }
        Scanner scan = new Scanner(cvResults);
        scan.useDelimiter(System.lineSeparator());
        scan.next();
        int paramId = Integer.parseInt(scan.next().trim());
        this.setParamsFromParamId(this.train, paramId);
        new File(outputResultsDir + this.classifierIdentifier + "/Predictions/" + datasetName + "/").mkdirs();
        StringBuilder headerInfo = new StringBuilder();
        headerInfo.append(this.classifierIdentifier).append(System.lineSeparator());
        headerInfo.append(this.getParamInformationString()).append(System.lineSeparator());
        Instances train = ClassifierTools.loadData(tscProblemDir + datasetName + "/" + datasetName + "_TRAIN");
        Instances test = ClassifierTools.loadData(tscProblemDir + datasetName + "/" + datasetName + "_TEST");
        if (resampleId != 0) {
            Instances[] temp = InstanceTools.resampleTrainAndTestInstances(train, test, resampleId);
            train = temp[0];
            test = temp[1];
        }
        this.buildClassifier(train);
        StringBuilder classificationInfo = new StringBuilder();
        int correct = 0;
        for (int i = 0; i < test.numInstances(); ++i) {
            double actual = test.instance(i).classValue();
            double pred = this.classifyInstance(test.instance(i));
            classificationInfo.append(actual).append(",").append(pred).append(System.lineSeparator());
            if (actual != pred) continue;
            ++correct;
        }
        FileWriter outWriter = new FileWriter(outputResultsDir + this.classifierIdentifier + "/Predictions/" + datasetName + "/testFold" + resampleId + ".csv");
        outWriter.append(headerInfo);
        outWriter.append((double)correct / (double)test.numInstances() + System.lineSeparator());
        outWriter.append(classificationInfo);
        outWriter.close();
    }

    public abstract String getParamInformationString();

    public Instances getTrainingData() {
        return this.train;
    }

    public static Instances concatenate(Instances[] train) {
        Instances temp = new Instances(train[0], 0);
        for (int i = 1; i < train.length; ++i) {
            for (int j = 0; j < train[i].numAttributes() - 1; ++j) {
                temp.insertAttributeAt(train[i].attribute(j), temp.numAttributes() - 1);
            }
        }
        for (int insId = 0; insId < train[0].numInstances(); ++insId) {
            DenseInstance dense = new DenseInstance(temp.numAttributes());
            for (int attId = 0; attId < temp.numAttributes() - 1; ++attId) {
                int dataset = attId / (train[0].numAttributes() - 1);
                int attFromData = attId % (train[0].numAttributes() - 1);
                dense.setValue(attId, train[dataset].instance(insId).value(attFromData));
            }
            dense.setValue(temp.numAttributes() - 1, train[0].instance(insId).classValue());
            temp.add(dense);
        }
        return temp;
    }
}

