/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.boss;

import fileIO.OutFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import utilities.ClassifierResults;
import utilities.ClassifierTools;
import utilities.InstanceTools;
import utilities.SaveParameterInfo;
import utilities.Timer;
import utilities.TrainAccuracyEstimate;
import weka.classifiers.Classifier;
import weka.classifiers.functions.LibSVM;
import weka.clusterers.SimpleKMeans;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SelectedTag;
import weka.core.TechnicalInformation;

public class BoTSWEnsemble
implements Classifier,
SaveParameterInfo,
TrainAccuracyEstimate {
    private List<BoTSWWindow> classifiers;
    private final double correctThreshold = 0.92;
    private int maxEnsembleSize = Integer.MAX_VALUE;
    private final Integer[] n_bRanges = new Integer[]{4, 8, 12, 16, 20};
    private final Integer[] aRanges = new Integer[]{4, 8};
    private final Integer[] kRanges = new Integer[]{32, 64, 128, 256, 512, 1024};
    private final Integer[] csvmRanges = new Integer[]{1, 10, 100};
    private BoTSW.DistFunction dist = BoTSW.DistFunction.EUCLIDEAN_DISTANCE;
    private String trainCVPath;
    private boolean trainCV = false;
    private ClassifierResults res = new ClassifierResults();
    private Instances train;
    private double ensembleCvAcc = -1.0;

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Bailly, Adeline and Malinowski, Simon and Tavenard, Romain and Guyet, Thomas and Chapel, Laetitia");
        result.setValue(TechnicalInformation.Field.TITLE, "Bag-of-Temporal-SIFT-Words for Time Series Classification");
        result.setValue(TechnicalInformation.Field.JOURNAL, "ECML/PKDD Workshop on Advanced Analytics and Learning on Temporal Data");
        result.setValue(TechnicalInformation.Field.YEAR, "2015");
        return result;
    }

    @Override
    public void writeCVTrainToFile(String train) {
        this.trainCVPath = train;
        this.trainCV = true;
    }

    @Override
    public boolean findsTrainAccuracyEstimate() {
        return this.trainCV;
    }

    @Override
    public ClassifierResults getTrainResults() {
        return this.res;
    }

    @Override
    public String getParameters() {
        StringBuilder sb = new StringBuilder();
        BoTSWWindow first = this.classifiers.get(0);
        sb.append(first.getParameters());
        for (int i = 1; i < this.classifiers.size(); ++i) {
            BoTSWWindow botsw = this.classifiers.get(i);
            sb.append(",").append(botsw.getParameters());
        }
        return sb.toString();
    }

    @Override
    public int setNumberOfFolds(Instances data) {
        return data.numInstances();
    }

    public int[][] getParametersValues() {
        int[][] params = new int[this.classifiers.size()][];
        int i = 0;
        for (BoTSWWindow botsw : this.classifiers) {
            params[i++] = botsw.getParametersValues();
        }
        return params;
    }

    public void setMaxEnsembleSize(int max) {
        this.maxEnsembleSize = max;
    }

    public void setDistanceFunction(BoTSW.DistFunction dist) {
        this.dist = dist;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.train = data;
        if (data.classIndex() != data.numAttributes() - 1) {
            throw new Exception("BOSSEnsemble_BuildClassifier: Class attribute not set as last attribute in dataset");
        }
        this.classifiers = new LinkedList<BoTSWWindow>();
        int numSeries = data.numInstances();
        double maxAcc = -1.0;
        double minMaxAcc = -1.0;
        boolean firstBuild = true;
        BoTSW.FeatureDiscoveryData[] fdData = null;
        for (Integer n_b : this.n_bRanges) {
            for (Integer a : this.aRanges) {
                if (n_b * a > data.numAttributes() - 1) continue;
                BoTSW botsw = new BoTSW(n_b, a, this.kRanges[0]);
                botsw.setSearchingForK(true);
                if (firstBuild) {
                    botsw.buildClassifier(data);
                    fdData = botsw.fdData;
                    firstBuild = false;
                } else {
                    botsw.giveFeatureDiscoveryData(fdData);
                    botsw.buildClassifier(data);
                }
                Instances featureData = new Instances(botsw.clusterData);
                boolean firstk = true;
                for (Integer k : this.kRanges) {
                    if (firstk) {
                        firstk = false;
                    } else {
                        botsw = new BoTSW(n_b, a, k);
                        botsw.setSearchingForK(true);
                        botsw.giveFeatureData(featureData);
                        botsw.buildClassifier(data);
                    }
                    botsw.setDistanceFunction(this.dist);
                    int correct = 0;
                    for (int i = 0; i < numSeries; ++i) {
                        double c = botsw.classifyInstance(i);
                        if (c != data.get(i).classValue()) continue;
                        ++correct;
                    }
                    double acc = (double)correct / (double)numSeries;
                    if (!this.makesItIntoEnsemble(acc, maxAcc, minMaxAcc, this.classifiers.size())) continue;
                    BoTSWWindow bw = new BoTSWWindow(botsw, acc, data.relationName());
                    this.classifiers.add(bw);
                    if (acc > maxAcc) {
                        maxAcc = acc;
                        Iterator<BoTSWWindow> it = this.classifiers.iterator();
                        while (it.hasNext()) {
                            BoTSWWindow b = it.next();
                            if (!(b.accuracy < maxAcc * 0.92)) continue;
                            it.remove();
                        }
                    }
                    while (this.classifiers.size() > this.maxEnsembleSize) {
                        int minAccInd = (int)this.findMinEnsembleAcc()[0];
                        this.classifiers.remove(minAccInd);
                    }
                    minMaxAcc = this.findMinEnsembleAcc()[1];
                }
            }
        }
        if (this.trainCV) {
            int folds = this.setNumberOfFolds(data);
            OutFile of = new OutFile(this.trainCVPath);
            of.writeLine(data.relationName() + ",BoTSWEnsemble,train");
            double[][] results = this.findEnsembleTrainAcc(data);
            of.writeLine(this.getParameters());
            of.writeLine(results[0][0] + "");
            this.ensembleCvAcc = results[0][0];
            for (int i = 1; i < results[0].length; ++i) {
                of.writeLine(results[0][i] + "," + results[1][i]);
            }
            System.out.println("CV acc =" + results[0][0]);
        }
    }

    private double[] findMinEnsembleAcc() {
        double minAcc = Double.MIN_VALUE;
        int minAccInd = 0;
        for (int i = 0; i < this.classifiers.size(); ++i) {
            double curacc = this.classifiers.get((int)i).accuracy;
            if (!(curacc < minAcc)) continue;
            minAcc = curacc;
            minAccInd = i;
        }
        return new double[]{minAccInd, minAcc};
    }

    private boolean makesItIntoEnsemble(double acc, double maxAcc, double minMaxAcc, int curEnsembleSize) {
        if (acc >= maxAcc * 0.92) {
            if (curEnsembleSize >= this.maxEnsembleSize) {
                return acc > minMaxAcc;
            }
            return true;
        }
        return false;
    }

    private double[][] findEnsembleTrainAcc(Instances data) throws Exception {
        double[][] results = new double[2][data.numInstances() + 1];
        double correct = 0.0;
        for (int i = 0; i < data.numInstances(); ++i) {
            double c = this.classifyInstance(i, data.numClasses());
            if (c == data.get(i).classValue()) {
                correct += 1.0;
            }
            results[0][i + 1] = data.get(i).classValue();
            results[1][i + 1] = c;
        }
        results[0][0] = correct / (double)data.numInstances();
        return results;
    }

    public double getEnsembleCvAcc() {
        if (this.ensembleCvAcc >= 0.0) {
            return this.ensembleCvAcc;
        }
        try {
            return this.findEnsembleTrainAcc(this.train)[0][0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1.0;
        }
    }

    public double classifyInstance(int test, int numclasses) throws Exception {
        double[] dist = this.distributionForInstance(test, numclasses);
        double maxFreq = dist[0];
        double maxClass = 0.0;
        for (int i = 1; i < dist.length; ++i) {
            if (!(dist[i] > maxFreq)) continue;
            maxFreq = dist[i];
            maxClass = i;
        }
        return maxClass;
    }

    public double[] distributionForInstance(int test, int numclasses) throws Exception {
        double[] classHist = new double[numclasses];
        double sum = 0.0;
        for (BoTSWWindow classifier : this.classifiers) {
            double classification = classifier.classifyInstance(test);
            int n = (int)classification;
            classHist[n] = classHist[n] + 1.0;
            sum += 1.0;
        }
        if (sum != 0.0) {
            int i = 0;
            while (i < classHist.length) {
                int n = i++;
                classHist[n] = classHist[n] / sum;
            }
        }
        return classHist;
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        double[] dist = this.distributionForInstance(instance);
        double maxFreq = dist[0];
        double maxClass = 0.0;
        for (int i = 1; i < dist.length; ++i) {
            if (!(dist[i] > maxFreq)) continue;
            maxFreq = dist[i];
            maxClass = i;
        }
        return maxClass;
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] classHist = new double[instance.numClasses()];
        double sum = 0.0;
        for (BoTSWWindow classifier : this.classifiers) {
            double classification = classifier.classifyInstance(instance);
            int n = (int)classification;
            classHist[n] = classHist[n] + 1.0;
            sum += 1.0;
        }
        if (sum != 0.0) {
            int i = 0;
            while (i < classHist.length) {
                int n = i++;
                classHist[n] = classHist[n] / sum;
            }
        }
        return classHist;
    }

    @Override
    public Capabilities getCapabilities() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void main(String[] args) throws Exception {
        String dataset = "ItalyPowerDemand";
        Instances train = ClassifierTools.loadData("C:\\TSC Problems\\" + dataset + "\\" + dataset + "_TRAIN.arff");
        Instances test = ClassifierTools.loadData("C:\\TSC Problems\\" + dataset + "\\" + dataset + "_TEST.arff");
        BoTSWEnsemble c = new BoTSWEnsemble();
        c.dist = BoTSW.DistFunction.BOSS_DISTANCE;
        c.buildClassifier(train);
        double accuracy = ClassifierTools.accuracy(test, c);
        System.out.println("BoTSWEnsemble accuracy on " + dataset + " fold 0 = " + accuracy);
    }

    public static void detailedFold0Test(String dset) {
        System.out.println("BoTSWEnsemble DetailedTest\n");
        try {
            Instances train = ClassifierTools.loadData("C:\\TSC Problems\\" + dset + "\\" + dset + "_TRAIN.arff");
            Instances test = ClassifierTools.loadData("C:\\TSC Problems\\" + dset + "\\" + dset + "_TEST.arff");
            System.out.println(train.relationName());
            BoTSWEnsemble botsw = new BoTSWEnsemble();
            System.out.println("Training starting");
            long start = System.nanoTime();
            botsw.buildClassifier(train);
            double trainTime = (double)(System.nanoTime() - start) / 1.0E9;
            System.out.println("Training done (" + trainTime + "s)");
            System.out.println("Ensemble Size: " + botsw.classifiers.size());
            System.out.println("Param sets: ");
            int count = 0;
            for (BoTSWWindow window : botsw.classifiers) {
                System.out.println(count++ + ": " + window.getNB() + " " + window.getA() + " " + window.getK() + " " + window.accuracy);
            }
            System.out.println("\nTesting starting");
            start = System.nanoTime();
            double acc = ClassifierTools.accuracy(test, botsw);
            double testTime = (double)(System.nanoTime() - start) / 1.0E9;
            System.out.println("Testing done (" + testTime + "s)");
            System.out.println("\nACC: " + acc);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    public static void resampleTest(String dset, int resamples) throws Exception {
        Instances train = ClassifierTools.loadData("C:\\TSC Problems\\" + dset + "\\" + dset + "_TRAIN.arff");
        Instances test = ClassifierTools.loadData("C:\\TSC Problems\\" + dset + "\\" + dset + "_TEST.arff");
        BoTSWEnsemble c = new BoTSWEnsemble();
        double[] accs = new double[resamples];
        for (int i = 0; i < resamples; ++i) {
            Instances[] data = InstanceTools.resampleTrainAndTestInstances(train, test, i);
            c.buildClassifier(data[0]);
            accs[i] = ClassifierTools.accuracy(data[1], c);
            if (i == 0) {
                System.out.print(accs[i]);
                continue;
            }
            System.out.print("," + accs[i]);
        }
        double mean = 0.0;
        for (int i = 0; i < resamples; ++i) {
            mean += accs[i];
        }
        System.out.println("\n\nBoTSWEnsemble mean acc over " + resamples + " resamples: " + (mean /= (double)resamples));
    }

    public static class BoTSW
    implements Classifier,
    Serializable,
    SaveParameterInfo {
        public SimpleKMeans kmeans = null;
        public LibSVM svm = null;
        public Params params;
        public BoTSW_Bag[] bags;
        public FeatureDiscoveryData[] fdData;
        private boolean useSVM = false;
        private boolean clusteringDataPreBuilt = false;
        private boolean preprocessDataPreBuilt = false;
        private boolean searchingForK = false;
        DistFunction distFunc = DistFunction.EUCLIDEAN_DISTANCE;
        public Instances clusterData;
        public Instances bagData;
        private String trainCVPath;
        private boolean trainCV = false;

        public BoTSW() {
            this.params = new Params(4, 4, 32, 1.0);
        }

        public BoTSW(int n_b, int a, int k) {
            this.params = new Params(n_b, a, k);
        }

        public BoTSW(int n_b, int a, int k, int c_svm) {
            this.params = new Params(n_b, a, k, c_svm);
        }

        @Override
        public String getParameters() {
            StringBuilder sb = new StringBuilder();
            sb.append("n_b=").append(this.params.n_b).append("/a=").append(this.params.a);
            sb.append("/k=").append(this.params.k);
            return sb.toString();
        }

        public void setDistanceFunction(DistFunction d) {
            this.distFunc = d;
        }

        public void setSearchingForK(boolean b) {
            this.searchingForK = b;
        }

        public void setUseSVM(boolean use) {
            this.useSVM = use;
        }

        public int[] getParametersValues() {
            return new int[]{this.params.n_b, this.params.a, this.params.k};
        }

        public void giveFeatureDiscoveryData(FeatureDiscoveryData[] data) {
            this.fdData = data;
            this.preprocessDataPreBuilt = true;
        }

        public void giveFeatureData(Instances features) {
            this.clusterData = features;
            this.clusteringDataPreBuilt = true;
            this.preprocessDataPreBuilt = true;
        }

        @Override
        public void buildClassifier(Instances data) throws Exception {
            data = new Instances(data);
            if (this.params.n_sc == 0) {
                this.params.calcNumScales(data.numAttributes() - 1);
            }
            if (this.params.denseSampleRate == 0) {
                this.params.calcDenseSampleRate(data.numAttributes() - 1);
            }
            if (!this.preprocessDataPreBuilt) {
                this.fdData = new FeatureDiscoveryData[data.numInstances()];
                for (int i = 0; i < data.numInstances(); ++i) {
                    GuassianData gdata = this.findDoGs(BoTSW.toArrayNoClass(data.get(i)), this.params.sigma, this.params.k_sc, this.params.n_sc);
                    ArrayList<KeyPoint> keypoints = this.findDenseKeypoints(gdata);
                    this.fdData[i] = new FeatureDiscoveryData(keypoints, gdata);
                }
            }
            if (!this.clusteringDataPreBuilt) {
                int i;
                double[][][] features = new double[data.numInstances()][][];
                for (int i2 = 0; i2 < data.numInstances(); ++i2) {
                    features[i2] = this.describeKeyPoints(this.fdData[i2].gdata.guassSeries, this.fdData[i2].keypoints);
                }
                FastVector<Attribute> atts = new FastVector<Attribute>();
                assert (features[0][0].length == this.params.n_b * 2);
                for (i = 0; i < features[0][0].length; ++i) {
                    atts.add(new Attribute("" + i));
                }
                this.clusterData = new Instances("ClusterInfo", atts, features.length * features[0].length);
                for (i = 0; i < features.length; ++i) {
                    for (int j = 0; j < features[i].length; ++j) {
                        this.clusterData.add(new DenseInstance(1.0, features[i][j]));
                    }
                }
            }
            int maxIterations = 10;
            int numAttempts = this.searchingForK ? 2 : 10;
            double epsilon = 0.001;
            double bestCompactness = Double.MAX_VALUE;
            for (int i = 0; i < numAttempts; ++i) {
                SimpleKMeans t_kmeans = new SimpleKMeans();
                t_kmeans.setMaxIterations(maxIterations);
                t_kmeans.setInitializeUsingKMeansPlusPlusMethod(true);
                t_kmeans.setSeed(i);
                t_kmeans.setNumClusters(this.params.k);
                t_kmeans.setPreserveInstancesOrder(true);
                t_kmeans.buildClusterer(this.clusterData);
                if (numAttempts > 1) {
                    double compactness = BoTSW.compactnessOfClustering(t_kmeans, this.clusterData);
                    if (!(compactness < bestCompactness)) continue;
                    this.kmeans = t_kmeans;
                    continue;
                }
                this.kmeans = t_kmeans;
            }
            int[] assignments = this.kmeans.getAssignments();
            this.bags = new BoTSW_Bag[data.numInstances()];
            int featsPerSeries = this.clusterData.numInstances() / data.numInstances();
            int feat = 0;
            for (int i = 0; i < data.numInstances(); ++i) {
                double[] hist = new double[this.params.k];
                for (int j = 0; j < featsPerSeries; ++j) {
                    int n = assignments[feat++];
                    hist[n] = hist[n] + 1.0;
                }
                hist = this.normaliseHistogramSSR(hist);
                hist = this.normaliseHistograml2(hist);
                this.bags[i] = new BoTSW_Bag(hist, data.get(i).classValue());
            }
            if (this.useSVM) {
                int i;
                Timer svmTimer = new Timer("\t\t\ttrainingsvm");
                FastVector<Attribute> bagatts = new FastVector<Attribute>();
                for (int i3 = 0; i3 < this.params.k; ++i3) {
                    bagatts.add(new Attribute("" + i3));
                }
                ArrayList<String> classVals = new ArrayList<String>(data.numClasses());
                for (i = 0; i < data.numClasses(); ++i) {
                    classVals.add("" + i);
                }
                bagatts.add(new Attribute("classVal", classVals));
                this.bagData = new Instances("Bags", bagatts, data.numInstances());
                this.bagData.setClassIndex(this.bagData.numAttributes() - 1);
                for (i = 0; i < this.bags.length; ++i) {
                    double[] inst = new double[this.params.k + 1];
                    for (int j = 0; j < this.params.k; ++j) {
                        inst[j] = this.bags[i].hist[j];
                    }
                    inst[inst.length - 1] = this.bags[i].classValue;
                    this.bagData.add(new DenseInstance(1.0, inst));
                }
                this.svm = new LibSVM();
                this.svm.setCost(this.params.c_svm);
                this.svm.setCoef0(0.0);
                this.svm.setEps(0.001);
                this.svm.setGamma(0.5);
                this.svm.setKernelType(new SelectedTag(0, LibSVM.TAGS_KERNELTYPE));
                this.svm.setDegree(3);
                this.svm.setNu(0.5);
                this.svm.setShrinking(true);
                this.svm.setCacheSize(200.0);
                this.svm.setProbabilityEstimates(false);
                this.svm.buildClassifier(this.bagData);
                svmTimer.printlnTimeSoFar();
            }
        }

        public static double compactnessOfClustering(SimpleKMeans kmeans, Instances input) throws Exception {
            Instances centroids = kmeans.getClusterCentroids();
            int[] assignments = kmeans.getAssignments();
            double totalSqDist = 0.0;
            for (int i = 0; i < assignments.length; ++i) {
                Instance sample = input.get(i);
                Instance centroid = centroids.get(assignments[i]);
                for (int j = 0; j < sample.numAttributes(); ++j) {
                    totalSqDist += (sample.value(j) - centroid.value(j)) * (sample.value(j) - centroid.value(j));
                }
            }
            return totalSqDist;
        }

        double[] normaliseHistograml2(double[] hist) {
            double n = 0.0;
            for (int x = 0; x < hist.length; ++x) {
                n += hist[x] * hist[x];
            }
            int i = 0;
            while (i < hist.length) {
                int n2 = i++;
                hist[n2] = hist[n2] / n;
            }
            return hist;
        }

        double[] normaliseHistogramSSR(double[] hist) {
            for (int j = 0; j < hist.length; ++j) {
                hist[j] = Math.sqrt(hist[j]);
            }
            return hist;
        }

        double[][] extractFeatures(double[] series) throws Exception {
            GuassianData gdata = this.findDoGs(series, this.params.sigma, this.params.k_sc, this.params.n_sc);
            ArrayList<KeyPoint> keypoints = this.findDenseKeypoints(gdata);
            return this.describeKeyPoints(gdata.guassSeries, keypoints);
        }

        double[][] describeKeyPoints(double[][] series, ArrayList<KeyPoint> keypoints) throws Exception {
            int mx;
            int j;
            int i;
            int n_b = this.params.n_b;
            int a = this.params.a;
            int halfn_b = n_b / 2;
            double[] gfilter = this.gaussian((double)halfn_b * (double)a, n_b * a);
            double[][] globalGradients = new double[series.length][];
            for (i = 0; i < series.length; ++i) {
                globalGradients[i] = new double[series[i].length];
                globalGradients[i][0] = series[i][1] - series[i][0];
                for (j = 1; j < series[i].length - 1; ++j) {
                    globalGradients[i][j] = (series[i][j + 1] - series[i][j - 1]) * 0.5;
                }
                globalGradients[i][j] = series[i][j] - series[i][j - 1];
            }
            double[][] localGradients = new double[keypoints.size()][];
            for (i = 0; i < localGradients.length; ++i) {
                localGradients[i] = new double[a * n_b + 1];
            }
            for (i = 0; i < localGradients.length; ++i) {
                int sc = keypoints.get((int)i).scale;
                int tm = keypoints.get((int)i).time - a * halfn_b;
                mx = keypoints.get((int)i).time + a * halfn_b;
                if (tm > 0 && mx < series[0].length) {
                    for (j = 0; j <= a * n_b; ++j) {
                        localGradients[i][j] = gfilter[j] * globalGradients[sc][tm + j];
                    }
                } else {
                    for (j = 0; j <= a * n_b; ++j) {
                        if (tm + j >= series[0].length || tm + j <= 0) continue;
                        localGradients[i][j] = gfilter[j] * globalGradients[sc][tm + j];
                    }
                }
                double[] temp = new double[localGradients[i].length - 1];
                int mid = localGradients[i].length / 2;
                for (j = 0; j < mid; ++j) {
                    temp[j] = localGradients[i][j];
                }
                for (j = mid + 1; j < localGradients[i].length; ++j) {
                    temp[j - 1] = localGradients[i][j];
                }
                localGradients[i] = temp;
            }
            double[][] features = new double[keypoints.size()][];
            for (i = 0; i < features.length; ++i) {
                features[i] = new double[2 * n_b];
            }
            for (i = 0; i < features.length; ++i) {
                for (j = 0; j < n_b; ++j) {
                    for (mx = 0; mx < a; ++mx) {
                        if (localGradients[i][j * a + mx] < 0.0) {
                            double[] dArray = features[i];
                            int n = 2 * j;
                            dArray[n] = dArray[n] - localGradients[i][j * a + mx];
                            continue;
                        }
                        double[] dArray = features[i];
                        int n = 2 * j + 1;
                        dArray[n] = dArray[n] + localGradients[i][j * a + mx];
                    }
                }
            }
            return features;
        }

        public ArrayList<KeyPoint> findDenseKeypoints(GuassianData gdata) {
            int scales = gdata.DoGs.length - 1;
            int times = gdata.DoGs[0].length;
            int pointsPerScale = times / this.params.denseSampleRate;
            ArrayList<KeyPoint> keypoints = new ArrayList<KeyPoint>(scales * pointsPerScale);
            for (int scale = 1; scale < scales; ++scale) {
                for (int time = 0; time < times; time += this.params.denseSampleRate) {
                    keypoints.add(new KeyPoint(time, scale));
                }
            }
            return keypoints;
        }

        public double[] applyGuassian(double[] ts, double sigma) {
            double[] r = new double[ts.length];
            double[] vg = this.gaussian(sigma);
            int dec = (int)((double)(vg.length + 1) * 0.5);
            for (int i = 0; i < ts.length; ++i) {
                int k = i - dec;
                int m = 1;
                for (int j = 0; j < vg.length; ++j) {
                    if (Math.abs(++k) < ts.length) {
                        int n = i;
                        r[n] = r[n] + vg[j] * ts[Math.abs(k)];
                        continue;
                    }
                    int n = i;
                    r[n] = r[n] + vg[j] * ts[ts.length - ++m];
                }
            }
            return r;
        }

        public double[] gaussian(double sigma) {
            int qs = (int)(4.0 * sigma);
            double[] vg = new double[1 + 2 * qs];
            int y = -1;
            for (int x = -qs; x <= qs; ++x) {
                vg[++y] = Math.exp(-1.0 * (double)x * (double)x / (2.0 * sigma * sigma)) / (Math.sqrt(Math.PI * 2) * sigma);
            }
            return vg;
        }

        public double[] gaussian(double sigma, int length) {
            int i;
            double[] vg = length % 2 == 1 ? new double[length] : new double[length + 1];
            int l = vg.length / 2;
            for (int x = 1; x <= l; ++x) {
                vg[l - x] = Math.exp(-1.0 * (double)x * (double)x / (2.0 * sigma * sigma)) / (Math.sqrt(Math.PI * 2) * sigma);
                vg[l + x] = Math.exp(-1.0 * (double)x * (double)x / (2.0 * sigma * sigma)) / (Math.sqrt(Math.PI * 2) * sigma);
            }
            vg[l] = 1.0 / (Math.sqrt(Math.PI * 2) * sigma);
            double max = vg[0];
            for (i = 1; i < vg.length; ++i) {
                if (!(vg[i] > max)) continue;
                max = vg[i];
            }
            i = 0;
            while (i < vg.length) {
                int n = i++;
                vg[n] = vg[n] / max;
            }
            return vg;
        }

        public GuassianData findDoGs(double[] ts, double sigma, double k_sc, int n_sc) {
            int i;
            int size = ts.length;
            GuassianData res = new GuassianData();
            res.guassSeries = new double[n_sc + 3][];
            res.DoGs = new double[n_sc + 2][];
            for (i = 0; i < res.DoGs.length; ++i) {
                res.DoGs[i] = new double[size];
            }
            res.guassSeries[0] = this.applyGuassian(ts, sigma / k_sc);
            res.guassSeries[1] = this.applyGuassian(ts, sigma);
            for (i = 0; i < size; ++i) {
                res.DoGs[0][i] = res.guassSeries[1][i] - res.guassSeries[0][i];
            }
            for (int j = 1; j < res.DoGs.length; ++j) {
                res.guassSeries[j + 1] = this.applyGuassian(ts, Math.pow(k_sc, j) * sigma);
                for (i = 0; i < size; ++i) {
                    res.DoGs[j][i] = res.guassSeries[j + 1][i] - res.guassSeries[j][i];
                }
            }
            return res;
        }

        protected static double[] toArrayNoClass(Instance inst) {
            int length = inst.numAttributes();
            if (inst.classIndex() >= 0) {
                --length;
            }
            double[] data = new double[length];
            int j = 0;
            for (int i = 0; i < inst.numAttributes(); ++i) {
                if (inst.classIndex() == i) continue;
                data[j++] = inst.value(i);
            }
            return data;
        }

        public void clean() {
            if (this.clusterData != null) {
                this.clusterData.clear();
            }
            if (this.bagData != null) {
                this.bagData.clear();
            }
        }

        @Override
        public double classifyInstance(Instance instnc) throws Exception {
            if (this.useSVM) {
                return this.classifyInstanceSVM(instnc);
            }
            BoTSW_Bag testBag = this.buildTestBag(instnc);
            double bestDist = Double.MAX_VALUE;
            double nn = -1.0;
            for (int i = 0; i < this.bags.length; ++i) {
                double dist = this.distance(testBag, this.bags[i], bestDist);
                if (!(dist < bestDist)) continue;
                bestDist = dist;
                nn = this.bags[i].classValue;
            }
            return nn;
        }

        public double classifyInstance(int test) throws Exception {
            if (this.useSVM) {
                throw new Exception("sped-up loo cv not possible with svm");
            }
            BoTSW_Bag testBag = this.bags[test];
            double bestDist = Double.MAX_VALUE;
            double nn = -1.0;
            for (int i = 0; i < this.bags.length; ++i) {
                double dist;
                if (i == test || !((dist = this.distance(testBag, this.bags[i], bestDist)) < bestDist)) continue;
                bestDist = dist;
                nn = this.bags[i].classValue;
            }
            return nn;
        }

        protected double distance(BoTSW_Bag instA, BoTSW_Bag instB, double bestDist) throws Exception {
            switch (this.distFunc) {
                case EUCLIDEAN_DISTANCE: {
                    return this.euclidean(instA, instB, bestDist);
                }
                case HISTOGRAM_INTERSECTION: {
                    return this.histIntersection(instA, instB);
                }
                case BOSS_DISTANCE: {
                    return this.bossDistance(instA, instB, bestDist);
                }
            }
            throw new Exception("No distance function set");
        }

        protected double euclidean(BoTSW_Bag instA, BoTSW_Bag instB, double bestDist) {
            double dist = 0.0;
            for (int i = 0; i < instA.hist.length; ++i) {
                double valA = instA.hist[i];
                double valB = instB.hist[i];
                if (!((dist += (valA - valB) * (valA - valB)) > bestDist)) continue;
                return Double.MAX_VALUE;
            }
            return dist;
        }

        protected double bossDistance(BoTSW_Bag instA, BoTSW_Bag instB, double bestDist) {
            double dist = 0.0;
            for (int i = 0; i < instA.hist.length; ++i) {
                double valB;
                double valA = instA.hist[i];
                if (instA.hist[i] == 0.0 || !((dist += (valA - (valB = instB.hist[i])) * (valA - valB)) > bestDist)) continue;
                return Double.MAX_VALUE;
            }
            return dist;
        }

        protected double histIntersection(BoTSW_Bag instA, BoTSW_Bag instB) {
            double sim = 0.0;
            for (int i = 0; i < instA.hist.length; ++i) {
                double valA = instA.hist[i];
                double valB = instB.hist[i];
                sim += Math.min(valA, valB);
            }
            return -sim;
        }

        public double classifyInstanceSVM(Instance instnc) throws Exception {
            double[] dist = this.distributionForInstanceSVM(instnc);
            int maxi = 0;
            double max = dist[maxi];
            for (int i = 1; i < dist.length; ++i) {
                if (!(dist[i] > max)) continue;
                max = dist[i];
                maxi = i;
            }
            return maxi;
        }

        public BoTSW_Bag buildTestBag(Instance instnc) throws Exception {
            double[][] features = this.extractFeatures(BoTSW.toArrayNoClass(instnc));
            Instances testFeatures = new Instances(this.clusterData, features.length);
            double[] hist = new double[this.params.k];
            for (int i = 0; i < features.length; ++i) {
                int cluster;
                testFeatures.add(new DenseInstance(1.0, features[i]));
                int n = cluster = this.kmeans.clusterInstance(testFeatures.get(i));
                hist[n] = hist[n] + 1.0;
            }
            hist = this.normaliseHistogramSSR(hist);
            hist = this.normaliseHistograml2(hist);
            return new BoTSW_Bag(hist, instnc.classValue());
        }

        @Override
        public double[] distributionForInstance(Instance instnc) throws Exception {
            if (this.useSVM) {
                return this.distributionForInstanceSVM(instnc);
            }
            throw new UnsupportedOperationException("Not supported yet for non-svm classification.");
        }

        public double[] distributionForInstanceSVM(Instance instnc) throws Exception {
            BoTSW_Bag testBag = this.buildTestBag(instnc);
            Instances testBagData = new Instances(this.bagData, 1);
            double[] inst = new double[this.params.k + 1];
            for (int j = 0; j < this.params.k; ++j) {
                inst[j] = testBag.hist[j];
            }
            inst[inst.length - 1] = testBag.classValue;
            testBagData.add(new DenseInstance(1.0, inst));
            return this.svm.distributionForInstance(testBagData.get(0));
        }

        @Override
        public Capabilities getCapabilities() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public static class BoTSW_Bag {
            double[] hist;
            double classValue;

            public BoTSW_Bag(double[] hist, double classValue) {
                this.hist = hist;
                this.classValue = classValue;
            }
        }

        public static class KeyPoint {
            public int time;
            public int scale;

            public KeyPoint(int time, int scale) {
                this.time = time;
                this.scale = scale;
            }
        }

        public static class GuassianData {
            public double[][] guassSeries;
            public double[][] DoGs;
        }

        public static class FeatureDiscoveryData {
            public ArrayList<KeyPoint> keypoints;
            public GuassianData gdata;

            public FeatureDiscoveryData(ArrayList<KeyPoint> keypoints, GuassianData gdata) {
                this.keypoints = keypoints;
                this.gdata = gdata;
            }
        }

        public static class Params {
            public int n_b;
            public int a;
            public int k;
            public double c_svm;
            public int denseSampleRate = 0;
            public int n_sc;
            public final double k_sc = 1.257013374521;
            public final double sigma = 1.6;

            public Params(int n_b, int a, int k) {
                this.n_b = n_b;
                this.a = a;
                this.k = k;
                this.c_svm = 1.0;
                this.n_sc = 0;
            }

            public Params(int n_b, int a, int k, double c_svm) {
                this.n_b = n_b;
                this.a = a;
                this.k = k;
                this.c_svm = c_svm;
                this.n_sc = 0;
            }

            public Params(int n_b, int a, int k, double c_svm, int n_sc) {
                this.n_b = n_b;
                this.a = a;
                this.k = k;
                this.c_svm = c_svm;
                this.n_sc = n_sc;
            }

            public int calcNumScales(int seriesLength) {
                int max_sc = (int)(Math.log(0.125 * (double)seriesLength / 1.6) / Math.log(1.257013374521));
                if (this.n_sc == 0 || this.n_sc > max_sc) {
                    this.n_sc = max_sc;
                }
                return this.n_sc;
            }

            public int calcDenseSampleRate(int seriesLength) {
                this.denseSampleRate = seriesLength / 100;
                if (this.denseSampleRate < 1) {
                    this.denseSampleRate = 1;
                }
                return this.denseSampleRate;
            }

            public void setDenseSampleRate(int rate) {
                this.denseSampleRate = rate;
            }

            public String toString() {
                return this.n_b + "_" + this.a + "_" + this.k;
            }
        }

        public static enum DistFunction {
            EUCLIDEAN_DISTANCE,
            HISTOGRAM_INTERSECTION,
            BOSS_DISTANCE;

        }
    }

    public static class BoTSWWindow
    implements Comparable<BoTSWWindow> {
        private BoTSW classifier;
        public double accuracy;
        private static final long serialVersionUID = 2L;

        public BoTSWWindow(BoTSW classifer, double accuracy, String dataset) {
            this.classifier = classifer;
            this.accuracy = accuracy;
        }

        public double classifyInstance(Instance inst) throws Exception {
            return this.classifier.classifyInstance(inst);
        }

        public double classifyInstance(int test) throws Exception {
            return this.classifier.classifyInstance(test);
        }

        public void clearClassifier() {
            this.classifier = null;
        }

        public String getParameters() {
            return this.classifier.getParameters();
        }

        public int[] getParametersValues() {
            return this.classifier.getParametersValues();
        }

        public int getNB() {
            return this.classifier.params.n_b;
        }

        public int getA() {
            return this.classifier.params.a;
        }

        public int getK() {
            return this.classifier.params.k;
        }

        @Override
        public int compareTo(BoTSWWindow other) {
            if (this.accuracy > other.accuracy) {
                return 1;
            }
            if (this.accuracy == other.accuracy) {
                return 0;
            }
            return -1;
        }
    }
}

