/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers;

import development.DataSets;
import fileIO.OutFile;
import java.text.DecimalFormat;
import java.util.Random;
import timeseriesweka.classifiers.AbstractClassifierWithTrainingData;
import timeseriesweka.classifiers.ParameterSplittable;
import timeseriesweka.classifiers.TSF;
import utilities.ClassifierTools;
import utilities.InstanceTools;
import vector_classifiers.TunedRandomForest;
import weka.classifiers.Classifier;
import weka.classifiers.trees.RandomForest;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.TechnicalInformation;

public class TSBF
extends AbstractClassifierWithTrainingData
implements ParameterSplittable {
    static double[] reportedResults = new double[]{0.245, 0.287, 0.009, 0.336, 0.262, 0.004, 0.278, 0.259, 0.263, 0.126, 0.183, 0.234, 0.051, 0.09, 0.209, 0.08, 0.011, 0.488, 0.603, 0.096, 0.257, 0.262, 0.037, 0.269, 0.135, 0.138, 0.13, 0.09, 0.329, 0.175, 0.196, 0.022, 0.075, 0.034, 0.008, 0.02, 0.046, 0.001, 0.164, 0.249, 0.217, 0.004, 0.302, 0.149};
    static String[] problems = new String[]{"Adiac", "Beef", "CBF", "ChlorineConcentration", "CinCECGtorso", "Coffee", "CricketX", "CricketY", "CricketZ", "DiatomSizeReduction", "ECGFiveDays", "FaceAll", "FaceFour", "FacesUCR", "FiftyWords", "Fish", "GunPoint", "Haptics", "InlineSkate", "ItalyPowerDemand", "Lightning2", "Lightning7", "Mallat", "MedicalImages", "MoteStrain", "NonInvasiveFatalECGThorax1", "NonInvasiveFatalECGThorax2", "OliveOil", "OSULeaf", "SonyAIBORobotSurface1", "SonyAIBORobotSurface2", "StarLightCurves", "SwedishLeaf", "Symbols", "SyntheticControl", "Trace", "TwoLeadECG", "TwoPatterns", "UWaveGestureLibraryX", "UWaveGestureLibraryY", "UWaveGestureLibraryZ", "Wafer", "WordSynonyms", "Yoga"};
    int minIntervalLength = 5;
    int numBins = 10;
    int numReps = 10;
    double oobError;
    static double[] zLevels = new double[]{0.1, 0.25, 0.5, 0.75};
    double z = zLevels[0];
    int folds = 10;
    int seriesLength;
    int numIntervals;
    int numSubSeries;
    int minSubLength;
    int numOfTreeStep = 50;
    boolean paramSearch = true;
    double trainAcc;
    boolean stepWise = true;
    int[][] subSeries;
    int[][][] intervals;
    RandomForest subseriesRandomForest;
    RandomForest finalRandForest;
    Instances first;
    Random rand = new Random();
    static double TOLERANCE = 0.05;

    public static void recreatePublishedResults() throws Exception {
        OutFile of = new OutFile(DataSets.resultsPath + "RecreateTSBF.csv");
        System.out.println("problem,published,recreated");
        double meanDiff = 0.0;
        int publishedBetter = 0;
        for (int i = 0; i < problems.length; ++i) {
            Instances train = ClassifierTools.loadData(DataSets.problemPath + problems[i] + "/" + problems[i] + "_TRAIN");
            Instances test = ClassifierTools.loadData(DataSets.problemPath + problems[i] + "/" + problems[i] + "_TEST");
            TSBF tsbf = new TSBF();
            tsbf.searchParameters(true);
            double a = ClassifierTools.singleTrainTestSplitAccuracy(tsbf, train, test);
            System.out.println(problems[i] + "," + reportedResults[i] + "," + (1.0 - a));
            of.writeLine(problems[i] + "," + reportedResults[i] + "," + (1.0 - a));
            meanDiff += reportedResults[i] - (1.0 - a);
            if (!(reportedResults[i] < 1.0 - a)) continue;
            ++publishedBetter;
        }
        System.out.println("Mean diff =" + meanDiff / (double)problems.length + " Published better =" + publishedBetter);
        of.writeLine(",,,,Mean diff =" + meanDiff / (double)problems.length + " Published better =" + publishedBetter);
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "M. Baydogan, G. Runger and E. Tuv");
        result.setValue(TechnicalInformation.Field.YEAR, "2013");
        result.setValue(TechnicalInformation.Field.TITLE, "A Bag-Of-Features Framework to Classify Time Series");
        result.setValue(TechnicalInformation.Field.JOURNAL, "IEEE Trans. PAMI");
        result.setValue(TechnicalInformation.Field.VOLUME, "35");
        result.setValue(TechnicalInformation.Field.NUMBER, "11");
        result.setValue(TechnicalInformation.Field.PAGES, "2796-2802");
        return result;
    }

    public void seedRandom(int s) {
        this.rand = new Random(s);
    }

    public void searchParameters(boolean b) {
        this.paramSearch = b;
    }

    public void setZLevel(double zLevel) {
        this.z = zLevel;
    }

    @Override
    public void setParametersFromIndex(int x) {
        this.z = zLevels[x - 1];
    }

    @Override
    public String getParas() {
        return this.z + "";
    }

    @Override
    public double getAcc() {
        return this.trainAcc;
    }

    @Override
    public void setParamSearch(boolean b) {
        this.paramSearch = b;
    }

    Instances formatIntervalInstances(Instances data) {
        int numFeatures = 5 + 3 * this.numIntervals;
        FastVector<Attribute> atts = new FastVector<Attribute>();
        for (int j = 0; j < numFeatures; ++j) {
            String name = "F" + j;
            atts.addElement(new Attribute(name));
        }
        Attribute target = data.attribute(data.classIndex());
        FastVector<String> vals = new FastVector<String>(target.numValues());
        for (int j = 0; j < target.numValues(); ++j) {
            vals.addElement(target.value(j));
        }
        atts.addElement(new Attribute(data.attribute(data.classIndex()).name(), vals));
        Instances result = new Instances("SubsequenceIntervals", atts, data.numInstances());
        result.setClassIndex(result.numAttributes() - 1);
        for (int i = 0; i < data.numInstances(); ++i) {
            double cval = data.instance(i).classValue();
            for (int j = 0; j < this.numSubSeries; ++j) {
                DenseInstance in = new DenseInstance(result.numAttributes());
                in.setValue(result.numAttributes() - 1, cval);
                result.add(in);
            }
        }
        return result;
    }

    Instances formatProbabilityInstances(double[][] probs, Instances data) {
        int numClasses = data.numClasses();
        int numFeatures = (numClasses - 1) * this.numSubSeries;
        FastVector<Attribute> atts = new FastVector<Attribute>();
        for (int j = 0; j < numFeatures; ++j) {
            String name = "ProbFeature" + j;
            atts.addElement(new Attribute(name));
        }
        Attribute target = data.attribute(data.classIndex());
        FastVector<String> vals = new FastVector<String>(target.numValues());
        for (int j = 0; j < target.numValues(); ++j) {
            vals.addElement(target.value(j));
        }
        atts.addElement(new Attribute(data.attribute(data.classIndex()).name(), vals));
        Instances result = new Instances("SubsequenceIntervals", atts, data.numInstances());
        result.setClassIndex(result.numAttributes() - 1);
        for (int i = 0; i < data.numInstances(); ++i) {
            double cval = data.instance(i).classValue();
            DenseInstance in = new DenseInstance(result.numAttributes());
            in.setValue(result.numAttributes() - 1, cval);
            int pos = 0;
            for (int j = 0; j < this.numSubSeries; ++j) {
                for (int k = 0; k < numClasses - 1; ++k) {
                    in.setValue(pos++, probs[j + this.numSubSeries * i][k]);
                }
            }
            result.add(in);
        }
        return result;
    }

    Instances formatFrequencyBinInstances(int[][][] counts, double[][] classProbs, Instances data) {
        int numClasses = data.numClasses();
        int numFeatures = this.numBins * (numClasses - 1) + numClasses;
        FastVector<Attribute> atts = new FastVector<Attribute>();
        for (int j = 0; j < numFeatures; ++j) {
            String name = "FreqBinFeature" + j;
            atts.addElement(new Attribute(name));
        }
        Attribute target = data.attribute(data.classIndex());
        FastVector<String> vals = new FastVector<String>(target.numValues());
        for (int j = 0; j < target.numValues(); ++j) {
            vals.addElement(target.value(j));
        }
        atts.addElement(new Attribute(data.attribute(data.classIndex()).name(), vals));
        Instances result = new Instances("HistogramCounts", atts, data.numInstances());
        result.setClassIndex(result.numAttributes() - 1);
        for (int i = 0; i < data.numInstances(); ++i) {
            int j;
            double cval = data.instance(i).classValue();
            DenseInstance in = new DenseInstance(result.numAttributes());
            in.setValue(result.numAttributes() - 1, cval);
            int pos = 0;
            for (j = 0; j < numClasses - 1; ++j) {
                for (int k = 0; k < this.numBins; ++k) {
                    in.setValue(pos++, (double)counts[i][j][k]);
                }
            }
            for (j = 0; j < numClasses; ++j) {
                in.setValue(pos++, classProbs[i][j]);
            }
            result.add(in);
        }
        return result;
    }

    Classifier findIncrementalClassifier(Instances data) throws Exception {
        int iteration = 1;
        int nofTreeStep = 50;
        double curOOBerror = 0.0;
        double prevOOBerror = 1.0;
        TunedRandomForest rf = new TunedRandomForest();
        rf.setNumTrees(nofTreeStep);
        rf.buildClassifier(data);
        curOOBerror = rf.measureOutOfBagError();
        while (iteration < 20 && curOOBerror < (1.0 - TOLERANCE) * prevOOBerror) {
            rf.addTrees(nofTreeStep, data);
            double a = rf.measureOutOfBagError();
            prevOOBerror = curOOBerror;
            curOOBerror = a;
        }
        return rf;
    }

    private void cloneToThis(TSBF other) {
        this.numBins = other.numBins;
        this.oobError = other.oobError;
        this.z = other.z;
        this.folds = other.folds;
        this.seriesLength = other.seriesLength;
        this.numIntervals = other.numIntervals;
        this.numSubSeries = other.numSubSeries;
        this.minSubLength = other.minSubLength;
        this.numOfTreeStep = other.numOfTreeStep;
        this.paramSearch = other.paramSearch;
        this.trainAcc = other.trainAcc;
        this.stepWise = other.stepWise;
        this.subSeries = other.subSeries;
        this.intervals = other.intervals;
        this.subseriesRandomForest = other.subseriesRandomForest;
        this.finalRandForest = other.finalRandForest;
        this.first = other.first;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.trainResults.buildTime = System.currentTimeMillis();
        if (this.numReps > 1) {
            double bestOOB = 1.0;
            TSBF bestRun = this;
            int r = 0;
            for (int i = 0; i < this.numReps; ++i) {
                TSBF reps = new TSBF();
                reps.numReps = 1;
                reps.paramSearch = true;
                reps.buildClassifier(data);
                System.out.println("REP " + i + " ACC = " + reps.trainAcc);
                if (bestOOB > 1.0 - reps.trainAcc) {
                    bestOOB = 1.0 - reps.trainAcc;
                    bestRun = reps;
                    r = i;
                }
                reps = null;
                System.gc();
            }
            this.cloneToThis(bestRun);
            System.out.println("BEST TRAIN ACC=" + this.trainAcc + " REP =" + r);
        } else {
            this.first = new Instances(data, 0);
            double bestZ = 0.0;
            double maxAcc = 0.0;
            RandomForest bestFinalModel = null;
            RandomForest bestSubseriesModel = null;
            int[][] bestSubSeries = null;
            int[][][] bestIntervals = null;
            this.seriesLength = data.numAttributes() - 1;
            double[] paras = this.paramSearch ? zLevels : new double[]{this.z};
            for (double zLevel : paras) {
                double[][] probs;
                this.numIntervals = (int)(zLevel * (double)this.seriesLength / (double)this.minIntervalLength);
                if (this.numIntervals == 0) {
                    this.numIntervals = 1;
                }
                this.minSubLength = this.minIntervalLength * this.numIntervals;
                this.numSubSeries = this.seriesLength / this.minIntervalLength - this.numIntervals;
                if (this.minSubLength < this.minIntervalLength) continue;
                this.selectSubsequencesAndIntervals();
                Instances features = this.formatIntervalInstances(data);
                this.buildFirstClassificationProblem(data, features);
                if (this.stepWise) {
                    this.subseriesRandomForest = new TunedRandomForest();
                    this.subseriesRandomForest.buildClassifier(features);
                    double currentOOBError = this.subseriesRandomForest.measureOutOfBagError();
                    double prevOOBError = 1.0;
                    int iter = 1;
                    while (iter < 20 && currentOOBError < (1.0 - TOLERANCE) * prevOOBError) {
                        prevOOBError = currentOOBError;
                        ((TunedRandomForest)this.subseriesRandomForest).addTrees(this.numOfTreeStep, features);
                        currentOOBError = this.subseriesRandomForest.measureOutOfBagError();
                    }
                    probs = ((TunedRandomForest)this.subseriesRandomForest).getOBProbabilities();
                } else {
                    this.subseriesRandomForest = new RandomForest();
                    this.subseriesRandomForest.setNumTrees(500);
                    probs = ClassifierTools.crossValidate(this.subseriesRandomForest, features, this.folds);
                    this.subseriesRandomForest.buildClassifier(features);
                }
                int[][][] counts = new int[data.numInstances()][data.numClasses() - 1][this.numBins];
                double[][] classProbs = new double[data.numInstances()][data.numClasses()];
                this.countsFormat(counts, classProbs, probs, data.numClasses(), data.numInstances());
                Instances second = this.formatFrequencyBinInstances(counts, classProbs, data);
                double acc = 0.0;
                if (this.stepWise) {
                    this.finalRandForest = new TunedRandomForest();
                    this.finalRandForest.buildClassifier(second);
                    double currentOOBError = this.finalRandForest.measureOutOfBagError();
                    double prevOOBError = 1.0;
                    int iter = 1;
                    while (iter < 20 && currentOOBError < (1.0 - TOLERANCE) * prevOOBError) {
                        prevOOBError = currentOOBError;
                        ((TunedRandomForest)this.finalRandForest).addTrees(this.numOfTreeStep, second);
                        currentOOBError = this.finalRandForest.measureOutOfBagError();
                    }
                    acc = 1.0 - currentOOBError;
                } else {
                    this.finalRandForest = new RandomForest();
                    this.finalRandForest.setNumTrees(500);
                    Random r = new Random();
                    acc = ClassifierTools.stratifiedCrossValidation(data, this.finalRandForest, 10, r.nextInt());
                }
                if (!(acc > maxAcc)) continue;
                if (!this.stepWise) {
                    this.finalRandForest.buildClassifier(second);
                }
                bestSubseriesModel = this.subseriesRandomForest;
                bestFinalModel = this.finalRandForest;
                maxAcc = acc;
                bestZ = zLevel;
                bestIntervals = this.intervals;
                bestSubSeries = this.subSeries;
            }
            this.numIntervals = (int)(bestZ * (double)this.seriesLength / (double)this.minIntervalLength);
            if (this.numIntervals == 0) {
                this.numIntervals = 1;
            }
            this.minSubLength = this.minIntervalLength * this.numIntervals;
            this.numSubSeries = this.seriesLength / this.minIntervalLength - this.numIntervals;
            this.intervals = bestIntervals;
            this.subSeries = bestSubSeries;
            this.subseriesRandomForest = bestSubseriesModel;
            this.finalRandForest = bestFinalModel;
            this.trainAcc = maxAcc;
        }
    }

    public void countsFormat(int[][][] counts, double[][] classProbs, double[][] probs, int numClasses, int numInstances) {
        int j;
        int i;
        for (i = 0; i < numInstances; ++i) {
            for (j = 0; j < this.numSubSeries; ++j) {
                for (int k = 0; k < numClasses - 1; ++k) {
                    int bin = probs[i * this.numSubSeries + j][k] == 1.0 ? this.numBins - 1 : (int)((double)this.numBins * probs[i * this.numSubSeries + j][k]);
                    int[] nArray = counts[i][k];
                    int n = bin;
                    nArray[n] = nArray[n] + 1;
                }
            }
        }
        for (i = 0; i < numInstances; ++i) {
            for (j = 0; j < this.numSubSeries; ++j) {
                int predicted = 0;
                for (int k = 1; k < numClasses; ++k) {
                    if (!(probs[i * this.numSubSeries + j][predicted] < probs[i * this.numSubSeries + j][k])) continue;
                    predicted = k;
                }
                double[] dArray = classProbs[i];
                int n = predicted;
                dArray[n] = dArray[n] + 1.0;
            }
            int k = 0;
            while (k < numClasses) {
                double[] dArray = classProbs[i];
                int n = k++;
                dArray[n] = dArray[n] / (double)this.numSubSeries;
            }
        }
        this.trainResults.buildTime = System.currentTimeMillis() - this.trainResults.buildTime;
    }

    @Override
    public double[] distributionForInstance(Instance ins) throws Exception {
        this.first.add(ins);
        Instances features = this.formatIntervalInstances(this.first);
        this.buildFirstClassificationProblem(this.first, features);
        double[][] probs = new double[features.numInstances()][];
        for (int i = 0; i < probs.length; ++i) {
            probs[i] = this.subseriesRandomForest.distributionForInstance(features.instance(i));
        }
        int[][][] counts = new int[1][ins.numClasses() - 1][this.numBins];
        double[][] classProbs = new double[1][ins.numClasses()];
        this.countsFormat(counts, classProbs, probs, ins.numClasses(), 1);
        Instances second = this.formatFrequencyBinInstances(counts, classProbs, this.first);
        this.first.remove(0);
        return this.finalRandForest.distributionForInstance(second.get(0));
    }

    private void selectSubsequencesAndIntervals() {
        this.subSeries = new int[this.numSubSeries][2];
        this.intervals = new int[this.numSubSeries][this.numIntervals][2];
        for (int i = 0; i < this.numSubSeries; ++i) {
            this.subSeries[i][0] = this.rand.nextInt(this.seriesLength - this.minSubLength);
            this.subSeries[i][1] = this.rand.nextInt(this.seriesLength - this.subSeries[i][0] - this.minSubLength) + this.subSeries[i][0] + this.minSubLength;
            int subSeriesLength = this.subSeries[i][1] - this.subSeries[i][0] + 1;
            int maxIntLength = subSeriesLength / this.numIntervals;
            if (maxIntLength < this.minIntervalLength) {
                System.out.println("MAX INT LENGTH < minIntervalLength subseries length =" + subSeriesLength + " num intervals =" + this.numIntervals + " max int length=" + maxIntLength);
                System.exit(0);
            }
            int currentIntLength = this.minIntervalLength;
            if (maxIntLength > this.minIntervalLength) {
                currentIntLength = this.rand.nextInt(maxIntLength - this.minIntervalLength + 1) + this.minIntervalLength;
            }
            for (int j = 0; j < this.numIntervals; ++j) {
                this.intervals[i][j][0] = this.subSeries[i][0] + j * currentIntLength;
                this.intervals[i][j][1] = this.subSeries[i][0] + (j + 1) * currentIntLength - 1;
                if (this.intervals[i][j][1] <= this.subSeries[i][1]) continue;
                System.out.println("\t INTERVAL " + j + "[" + this.intervals[i][j][0] + "," + this.intervals[i][j][1] + "] EXCEEDS SUBSERIES " + this.subSeries[i][0] + "," + this.subSeries[i][1] + "]");
                System.out.println("\t\t Max interval length =" + maxIntLength + " min interval length =" + this.minIntervalLength);
            }
        }
    }

    private void buildFirstClassificationProblem(Instances data, Instances features) {
        int instPos = 0;
        for (int k = 0; k < data.numInstances(); ++k) {
            double[] series = data.instance(k).toDoubleArray();
            for (int i = 0; i < this.numSubSeries; ++i) {
                int pos = 0;
                Instance newIns = features.get(instPos++);
                TSF.FeatureSet f = new TSF.FeatureSet();
                f.setFeatures(series, this.subSeries[i][0], this.subSeries[i][1]);
                newIns.setValue(pos++, f.mean);
                newIns.setValue(pos++, f.stDev);
                newIns.setValue(pos++, f.slope);
                newIns.setValue(pos++, (double)this.subSeries[i][0]);
                newIns.setValue(pos++, (double)this.subSeries[i][1]);
                for (int j = 0; j < this.numIntervals; ++j) {
                    f.setFeatures(series, this.intervals[i][j][0], this.intervals[i][j][1]);
                    newIns.setValue(pos++, f.mean);
                    newIns.setValue(pos++, f.stDev);
                    newIns.setValue(pos++, f.slope);
                }
            }
        }
        if (InstanceTools.hasMissing(features)) {
            System.out.println(" MISSING A VALUE");
            for (int i = 0; i < features.numInstances(); ++i) {
                if (!features.instance(i).hasMissingValue()) continue;
                System.out.println("Instance =" + features.instance(i) + " from original instance  " + i / this.numSubSeries + " ::" + data.instance(i / this.numSubSeries));
                System.out.println("\tSubsequence = [" + this.subSeries[i % this.numSubSeries][0] + "," + this.subSeries[i % this.numSubSeries][1] + "]");
                for (int j = 0; j < this.numIntervals; ++j) {
                    System.out.println("\t\t interval " + j + " [" + this.intervals[i % this.numSubSeries][j][0] + "," + this.intervals[i % this.numSubSeries][j][1] + "]");
                }
            }
            System.exit(0);
        }
    }

    public static void testBinMaker() {
        int j;
        int i;
        int k;
        double[][] probs = new double[][]{{0.05, 0.83, 0.12}, {0.25, 0.73, 0.02}, {0.25, 0.13, 0.62}, {0.1, 0.1, 0.8}, {1.0, 0.0, 0.0}, {0.5, 0.2, 0.3}};
        int numClasses = 3;
        int numBins = 10;
        int numInstances = 2;
        int numSubSeries = 3;
        int[][][] counts = new int[numInstances][numClasses - 1][numBins];
        for (int i2 = 0; i2 < numInstances; ++i2) {
            for (int j2 = 0; j2 < numSubSeries; ++j2) {
                for (k = 0; k < numClasses - 1; ++k) {
                    int bin = probs[i2 * numSubSeries + j2][k] == 1.0 ? numBins - 1 : (int)((double)numBins * probs[i2 * numSubSeries + j2][k]);
                    int[] nArray = counts[i2][k];
                    int n = bin;
                    nArray[n] = nArray[n] + 1;
                }
            }
        }
        double[][] classProbs = new double[numInstances][numClasses];
        for (i = 0; i < numInstances; ++i) {
            for (j = 0; j < numSubSeries; ++j) {
                int predicted = 0;
                for (int k2 = 1; k2 < numClasses; ++k2) {
                    if (!(probs[i * numSubSeries + j][predicted] < probs[i * numSubSeries + j][k2])) continue;
                    predicted = k2;
                }
                System.out.println(" instance " + i + " subseries " + j + " predicted =" + predicted);
                double[] dArray = classProbs[i];
                int n = predicted;
                dArray[n] = dArray[n] + 1.0;
            }
            k = 0;
            while (k < numClasses) {
                double[] dArray = classProbs[i];
                int n = k++;
                dArray[n] = dArray[n] / (double)numSubSeries;
            }
        }
        for (i = 0; i < numInstances; ++i) {
            System.out.println("COUNTS INSTANCE " + i);
            for (k = 0; k < numClasses - 1; ++k) {
                System.out.print(" CLASS = " + k + " :::: ");
                for (int j3 = 0; j3 < numBins; ++j3) {
                    System.out.print(counts[i][k][j3] + ",");
                }
            }
            System.out.print(" CLASS PROBS ::");
            for (j = 0; j < numClasses; ++j) {
                System.out.print(classProbs[i][j] + ",");
            }
            System.out.print("\n");
        }
    }

    public static void main(String[] args) throws Exception {
        String s = "Beef";
        System.out.println(" PROBLEM =" + s);
        Instances train = ClassifierTools.loadData("C:\\Users\\ajb\\Dropbox\\TSC Problems\\" + s + "\\" + s + "_TRAIN");
        Instances test = ClassifierTools.loadData("C:\\Users\\ajb\\Dropbox\\TSC Problems\\" + s + "\\" + s + "_TEST");
        TSBF tsbf = new TSBF();
        double a = ClassifierTools.singleTrainTestSplitAccuracy(tsbf, train, test);
        System.out.println(" TEST Acc =" + a);
        System.exit(0);
        DecimalFormat df = new DecimalFormat("##.###");
        try {
            for (int i = 1; i < 2; ++i) {
                s = "TwoLeadECG";
                System.out.println(" PROBLEM =" + s);
                train = ClassifierTools.loadData("C:\\Users\\ajb\\Dropbox\\TSC Problems\\" + s + "\\" + s + "_TRAIN");
                test = ClassifierTools.loadData("C:\\Users\\ajb\\Dropbox\\TSC Problems\\" + s + "\\" + s + "_TEST");
                tsbf = new TSBF();
                a = ClassifierTools.singleTrainTestSplitAccuracy(tsbf, train, test);
                System.out.println(" error =" + df.format(1.0 - a));
            }
        }
        catch (Exception e) {
            System.out.println("Exception " + e);
            e.printStackTrace();
            System.exit(0);
        }
    }
}

