/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers;

import java.util.Random;
import timeseriesweka.classifiers.AbstractClassifierWithTrainingData;
import timeseriesweka.classifiers.SubSampleTrain;
import timeseriesweka.filters.ACF;
import timeseriesweka.filters.PowerSpectrum;
import utilities.ClassifierTools;
import utilities.SaveParameterInfo;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.trees.RandomTree;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.TechnicalInformation;

public class RISE
extends AbstractClassifierWithTrainingData
implements SaveParameterInfo,
SubSampleTrain {
    long buildTime;
    Classifier[] baseClassifiers;
    Classifier baseClassifierTemplate = new RandomTree();
    int numBaseClassifiers = 500;
    int[] startPoints;
    int[] endPoints;
    public static int MIN_INTERVAL = 16;
    public static int MIN_BITS = 3;
    Random rand;
    PowerSpectrum ps = new PowerSpectrum();
    private boolean subSample = false;
    private double sampleProp = 1.0;
    private int sampleSeed = 0;
    Filter f = Filter.PS_ACF;
    Instances[] testHolders;

    @Override
    public void subSampleTrain(double prop, int s) {
        this.subSample = true;
        this.sampleProp = prop;
        this.sampleSeed = s;
    }

    public void setBaseClassifier(Classifier c) {
        this.baseClassifierTemplate = c;
    }

    public void setTransformType(Filter fil) {
        this.f = fil;
    }

    public void setTransformType(String s) {
        String str;
        switch (str = s.toUpperCase()) {
            case "FFT": 
            case "DFT": 
            case "FOURIER": {
                this.f = Filter.FFT;
                break;
            }
            case "ACF": 
            case "AFC": 
            case "AUTOCORRELATION": {
                this.f = Filter.ACF;
                break;
            }
            case "PS": 
            case "POWERSPECTRUM": {
                this.f = Filter.PS;
                break;
            }
            case "PS_ACF": 
            case "ACF_PS": 
            case "BOTH": {
                this.f = Filter.PS_ACF;
            }
        }
    }

    public void setNosBaseClassifiers(int n) {
        this.numBaseClassifiers = n;
    }

    public int getNosBaseClassifierds() {
        return this.numBaseClassifiers;
    }

    public RISE() {
        this.rand = new Random();
    }

    public RISE(int seed) {
        this.rand = new Random();
        this.rand.setSeed(seed);
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "A. Bagnall");
        result.setValue(TechnicalInformation.Field.YEAR, "2016");
        result.setValue(TechnicalInformation.Field.TITLE, "Not published");
        result.setValue(TechnicalInformation.Field.JOURNAL, "NA");
        result.setValue(TechnicalInformation.Field.VOLUME, "NA");
        result.setValue(TechnicalInformation.Field.PAGES, "NA");
        return result;
    }

    @Override
    public String getParameters() {
        return super.getParameters() + ",numTrees," + this.numBaseClassifiers + "," + "MinInterval" + MIN_INTERVAL;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.trainResults.buildTime = System.currentTimeMillis();
        if (this.subSample) {
            data = this.subSample(data, this.sampleProp, this.sampleSeed);
            System.out.println(" TRAIN SET SIZE NOW " + data.numInstances());
        }
        int m = data.numAttributes() - 1;
        this.startPoints = new int[this.numBaseClassifiers];
        this.endPoints = new int[this.numBaseClassifiers];
        this.baseClassifiers = new Classifier[this.numBaseClassifiers];
        this.testHolders = new Instances[this.numBaseClassifiers];
        for (int i = 0; i < this.numBaseClassifiers; ++i) {
            if (i == 0) {
                this.startPoints[i] = 0;
                this.endPoints[i] = m - 1;
            } else {
                this.startPoints[i] = this.rand.nextInt(m - MIN_INTERVAL);
                if (this.startPoints[i] == m - 1 - MIN_INTERVAL) {
                    this.endPoints[i] = m - 1;
                } else {
                    this.endPoints[i] = this.rand.nextInt(m - this.startPoints[i]);
                    if (this.endPoints[i] < MIN_INTERVAL) {
                        this.endPoints[i] = MIN_INTERVAL;
                    }
                    int n = i;
                    this.endPoints[n] = this.endPoints[n] + this.startPoints[i];
                }
            }
            int numFeatures = this.endPoints[i] - this.startPoints[i] + 1;
            FastVector<Attribute> atts = new FastVector<Attribute>();
            for (int j = 0; j < numFeatures; ++j) {
                String name = "F" + j;
                atts.addElement(new Attribute(name));
            }
            Attribute target = data.attribute(data.classIndex());
            FastVector<String> vals = new FastVector<String>(target.numValues());
            for (int j = 0; j < target.numValues(); ++j) {
                vals.addElement(target.value(j));
            }
            atts.addElement(new Attribute(data.attribute(data.classIndex()).name(), vals));
            Instances result = new Instances("Tree", atts, data.numInstances());
            result.setClassIndex(result.numAttributes() - 1);
            for (int j = 0; j < data.numInstances(); ++j) {
                DenseInstance in = new DenseInstance(result.numAttributes());
                double[] v = data.instance(j).toDoubleArray();
                for (int k = 0; k < numFeatures; ++k) {
                    in.setValue(k, v[this.startPoints[i] + k]);
                }
                in.setValue(result.numAttributes() - 1, data.instance(j).classValue());
                result.add(in);
            }
            this.testHolders[i] = new Instances(result, 0);
            DenseInstance in = new DenseInstance(result.numAttributes());
            this.testHolders[i].add(in);
            Instances newTrain = result;
            switch (this.f) {
                case ACF: {
                    newTrain = ACF.formChangeCombo(result);
                    break;
                }
                case PS: {
                    newTrain = this.ps.process(result);
                    break;
                }
                case PS_ACF: {
                    newTrain = this.combinedPSACF(result);
                }
            }
            if (this.baseClassifierTemplate instanceof RandomTree) {
                this.baseClassifiers[i] = new RandomTree();
                ((RandomTree)this.baseClassifiers[i]).setKValue(numFeatures);
            } else {
                this.baseClassifiers[i] = AbstractClassifier.makeCopy(this.baseClassifierTemplate);
            }
            this.baseClassifiers[i].buildClassifier(newTrain);
        }
        this.trainResults.buildTime = System.currentTimeMillis() - this.trainResults.buildTime;
    }

    @Override
    public double[] distributionForInstance(Instance ins) throws Exception {
        int i;
        double[] votes = new double[ins.numClasses()];
        double[] series = ins.toDoubleArray();
        for (i = 0; i < this.baseClassifiers.length; ++i) {
            int c;
            int numFeatures = this.endPoints[i] - this.startPoints[i] + 1;
            for (int j = 0; j < numFeatures; ++j) {
                this.testHolders[i].instance(0).setValue(j, ins.value(j + this.startPoints[i]));
            }
            Instances temp = null;
            switch (this.f) {
                case ACF: {
                    temp = ACF.formChangeCombo(this.testHolders[i]);
                    break;
                }
                case PS: {
                    temp = this.ps.process(this.testHolders[i]);
                    break;
                }
                case PS_ACF: {
                    temp = this.combinedPSACF(this.testHolders[i]);
                }
            }
            int n = c = (int)this.baseClassifiers[i].classifyInstance(temp.instance(0));
            votes[n] = votes[n] + 1.0;
        }
        i = 0;
        while (i < votes.length) {
            int n = i++;
            votes[n] = votes[n] / (double)this.baseClassifiers.length;
        }
        return votes;
    }

    @Override
    public double classifyInstance(Instance ins) throws Exception {
        int[] votes = new int[ins.numClasses()];
        double[] series = ins.toDoubleArray();
        for (int i = 0; i < this.baseClassifiers.length; ++i) {
            int c;
            int numFeatures = this.endPoints[i] - this.startPoints[i] + 1;
            for (int j = 0; j < numFeatures; ++j) {
                this.testHolders[i].instance(0).setValue(j, ins.value(j + this.startPoints[i]));
            }
            Instances temp = null;
            switch (this.f) {
                case ACF: {
                    temp = ACF.formChangeCombo(this.testHolders[i]);
                    break;
                }
                case PS: {
                    temp = this.ps.process(this.testHolders[i]);
                    break;
                }
                case PS_ACF: {
                    temp = this.combinedPSACF(this.testHolders[i]);
                }
            }
            int n = c = (int)this.baseClassifiers[i].classifyInstance(temp.instance(0));
            votes[n] = votes[n] + 1;
        }
        int maxVote = 0;
        for (int i = 1; i < votes.length; ++i) {
            if (votes[i] <= votes[maxVote]) continue;
            maxVote = i;
        }
        return maxVote;
    }

    private Instances combinedPSACF(Instances data) throws Exception {
        Instances combo = ACF.formChangeCombo(data);
        Instances temp2 = this.ps.process(data);
        combo.setClassIndex(-1);
        combo.deleteAttributeAt(combo.numAttributes() - 1);
        combo = Instances.mergeInstances(combo, temp2);
        combo.setClassIndex(combo.numAttributes() - 1);
        return combo;
    }

    public static void intervalGenerationTest() {
        int m = 500;
        int numTrees = 500;
        int[] startPoints = new int[numTrees];
        int[] endPoints = new int[numTrees];
        Random rand = new Random();
        for (int i = 0; i < numTrees; ++i) {
            if (i == 0) {
                startPoints[i] = 0;
                endPoints[i] = m - 1;
            } else {
                startPoints[i] = rand.nextInt(m - MIN_INTERVAL);
                if (startPoints[i] == m - 1 - MIN_INTERVAL) {
                    endPoints[i] = m - 1;
                } else {
                    endPoints[i] = rand.nextInt(m - startPoints[i]);
                    if (endPoints[i] < MIN_INTERVAL) {
                        endPoints[i] = MIN_INTERVAL;
                    }
                    int n = i;
                    endPoints[n] = endPoints[n] + startPoints[i];
                }
            }
            System.out.println("START = " + startPoints[i] + " END =" + endPoints[i] + " LENGTH =" + (endPoints[i] - startPoints[i]));
        }
    }

    public static int[] setIntervalLengths(int max) {
        int[] lengths;
        int test = (int)(Math.log(Integer.highestOneBit(max)) / Math.log(2.0));
        int l = 2;
        if (test > MIN_BITS) {
            int i;
            lengths = new int[test - MIN_BITS + 1];
            for (i = 1; i < MIN_BITS; ++i) {
                l *= 2;
            }
            lengths[0] = l;
            for (i = 1; i < lengths.length; ++i) {
                lengths[i] = lengths[i - 1] * 2;
            }
        } else {
            lengths = new int[1];
            for (int i = 1; i < test; ++i) {
                l *= 2;
            }
            lengths[0] = l;
        }
        return lengths;
    }

    public static void main(String[] arg) throws Exception {
        Instances train = ClassifierTools.loadData("C:\\Users\\ajb\\Dropbox\\TSC Problems\\ItalyPowerDemand\\ItalyPowerDemand_TRAIN");
        Instances test = ClassifierTools.loadData("C:\\Users\\ajb\\Dropbox\\TSC Problems\\ItalyPowerDemand\\ItalyPowerDemand_TEST");
        RISE rif = new RISE();
        rif.buildClassifier(train);
        System.out.println("build ok:");
        double a = ClassifierTools.accuracy(test, rif);
        System.out.println(" Accuracy =" + a);
    }

    public static enum Filter {
        PS,
        ACF,
        FFT,
        PS_ACF;

    }
}

