/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import timeseriesweka.classifiers.AbstractClassifierWithTrainingData;
import utilities.ClassifierTools;
import utilities.GenericTools;
import utilities.InstanceTools;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.TechnicalInformation;

public class FastShapelets
extends AbstractClassifierWithTrainingData {
    static final int EXTRA_TREE_DEPTH = 2;
    static final float MIN_PERCENT_OBJ_SPLIT = 0.1f;
    static final float MAX_PURITY_SPLIT = 0.9f;
    static final int SH_MIN_LEN = 5;
    int MIN_OBJ_SPLIT;
    int numClass;
    int numObj;
    int subseqLength;
    int[] classFreq;
    int[] orgClassFreq;
    ArrayList<ArrayList<Double>> orgData;
    ArrayList<ArrayList<Double>> data;
    ArrayList<Integer> Org_Label;
    ArrayList<Integer> Label;
    ArrayList<Integer> classifyList;
    ArrayList<Shapelet> finalSh;
    ArrayList<Pair<Integer, Double>> scoreList;
    HashMap<Integer, USAX_elm_type> uSAXMap;
    private int seed;
    Random rand;
    ArrayList<ArrayList<Integer>> nodeObjList;
    double classEntropy;
    NN_ED nn = new NN_ED();

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.CONFERENCE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "T. Rakthanmanon and E. Keogh");
        result.setValue(TechnicalInformation.Field.TITLE, "Fast-Shapelets: A Fast Algorithm for Discovering Robust Time Series Shapelets");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Proc. 13th SDM");
        result.setValue(TechnicalInformation.Field.YEAR, "2013");
        return result;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.trainResults.buildTime = System.currentTimeMillis();
        this.train(data, 10, 10);
        this.trainResults.buildTime = System.currentTimeMillis() - this.trainResults.buildTime;
    }

    @Override
    public String getParameters() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getParameters());
        return sb.toString();
    }

    public void train(Instances data, int R, int top_k) {
        int max_len = data.numAttributes() - 1;
        int min_len = 10;
        int step = 1;
        this.rand = new Random(this.seed);
        this.numClass = data.numClasses();
        this.numObj = data.numInstances();
        int sax_max_len = 15;
        double percent_mask = 0.25;
        this.readTrainData(data);
        this.nodeObjList = new ArrayList();
        this.finalSh = new ArrayList();
        this.uSAXMap = new HashMap();
        this.scoreList = new ArrayList();
        this.classifyList = new ArrayList();
        for (int node_id = 1; node_id == 1 || node_id < this.nodeObjList.size(); ++node_id) {
            Shapelet bsf_sh = new Shapelet();
            if (node_id <= 1) {
                this.setCurData(node_id);
            } else {
                if (this.classifyList.get(node_id) != -1) continue;
                this.setCurData(node_id);
            }
            this.subseqLength = min_len;
            while (this.subseqLength <= max_len) {
                if (this.subseqLength >= 5) {
                    int sax_len = sax_max_len;
                    int w = (int)Math.ceil(1.0 * (double)this.subseqLength / (double)sax_len);
                    sax_len = (int)Math.ceil(1.0 * (double)this.subseqLength / (double)w);
                    this.createSAXList(this.subseqLength, sax_len, w);
                    this.randomProjection(R, percent_mask, sax_len);
                    this.scoreAllSAX(R);
                    Shapelet sh = this.findBestSAX(top_k);
                    if (bsf_sh.lessThan(sh)) {
                        bsf_sh = sh;
                    }
                    this.uSAXMap.clear();
                    this.scoreList.clear();
                }
                this.subseqLength += step;
            }
            if (bsf_sh.len <= 0) continue;
            double[] query = new double[bsf_sh.len];
            for (int i = 0; i < bsf_sh.len; ++i) {
                query[i] = this.data.get(bsf_sh.obj).get(bsf_sh.pos + i);
            }
            bsf_sh.setTS(query);
            this.finalSh.add(bsf_sh);
            this.setNextNodeObj(node_id, bsf_sh);
        }
    }

    Shapelet findBestSAX(int top_k) {
        ArrayList<Pair<Integer, Double>> Dist = new ArrayList<Pair<Integer, Double>>();
        for (int i = 0; i < this.numObj; ++i) {
            Dist.add(null);
        }
        Shapelet sh = new Shapelet();
        Shapelet bsf_sh = new Shapelet();
        if (top_k > 0) {
            Collections.sort(this.scoreList, new ScoreComparator());
        }
        top_k = Math.abs(top_k);
        for (int k = 0; k < Math.min(top_k, this.scoreList.size()); ++k) {
            int word = (Integer)this.scoreList.get((int)k).first;
            USAX_elm_type usax = this.uSAXMap.get(word);
            for (int kk = 0; kk < Math.min(usax.sax_id.size(), 1); ++kk) {
                int i;
                int[] c_in = new int[this.numClass];
                int[] c_out = new int[this.numClass];
                double[] query = new double[this.subseqLength];
                int q_obj = (Integer)usax.sax_id.get((int)kk).first;
                int q_pos = (Integer)usax.sax_id.get((int)kk).second;
                for (i = 0; i < this.numClass; ++i) {
                    c_in[i] = 0;
                    c_out[i] = this.classFreq[i];
                }
                for (i = 0; i < this.subseqLength; ++i) {
                    query[i] = this.data.get(q_obj).get(q_pos + i);
                }
                int m = query.length;
                double[] Q = new double[m];
                int[] order = new int[m];
                for (int obj = 0; obj < this.numObj; ++obj) {
                    double dist = this.nn.nearestNeighborSearch(query, this.data.get(obj), obj, Q, order);
                    Dist.set(obj, new Pair<Integer, Double>(obj, dist));
                }
                Collections.sort(Dist, new DistComparator());
                int total_c_in = 0;
                for (int i2 = 0; i2 < Dist.size() - 1; ++i2) {
                    int label;
                    Pair pair_i = (Pair)Dist.get(i2);
                    Pair pair_ii = (Pair)Dist.get(i2 + 1);
                    double dist_th = ((Double)pair_i.second + (Double)pair_ii.second) / 2.0;
                    double gap = ((Double)pair_ii.second - dist_th) / Math.sqrt(this.subseqLength);
                    int n = label = this.Label.get((Integer)pair_i.first).intValue();
                    c_in[n] = c_in[n] + 1;
                    int n2 = label;
                    c_out[n2] = c_out[n2] - 1;
                    int num_diff = Math.abs(this.numObj - 2 * ++total_c_in);
                    double gain = this.calcInfoGain2(c_in, c_out, total_c_in, this.numObj - total_c_in);
                    sh.setValueFew(gain, gap, dist_th);
                    if (!bsf_sh.lessThan(sh)) continue;
                    bsf_sh.setValueAll(gain, gap, dist_th, q_obj, q_pos, this.subseqLength, num_diff, c_in, c_out);
                }
            }
        }
        return bsf_sh;
    }

    double calcInfoGain2(int[] c_in, int[] c_out, int total_c_in, int total_c_out) {
        return this.classEntropy - ((double)total_c_in / (double)this.numObj * this.entropyArray(c_in, total_c_in) + (double)total_c_out / (double)this.numObj * this.entropyArray(c_out, total_c_out));
    }

    void scoreAllSAX(int R) {
        for (Map.Entry<Integer, USAX_elm_type> entry : this.uSAXMap.entrySet()) {
            int word = entry.getKey();
            USAX_elm_type usax = entry.getValue();
            double score = this.calcScore(usax, R);
            this.scoreList.add(new Pair<Integer, Double>(word, score));
        }
    }

    double calcScore(USAX_elm_type usax, int R) {
        double score = -1.0;
        double[] c_in = new double[this.numClass];
        double[] c_out = new double[this.numClass];
        for (Map.Entry<Integer, Integer> entry : usax.obj_count.entrySet()) {
            int cid = this.Label.get(entry.getKey());
            int count = entry.getValue();
            int n = cid;
            c_in[n] = c_in[n] + (double)count;
            int n2 = cid;
            c_out[n2] = c_out[n2] + (double)(R - count);
        }
        score = this.calcScoreFromObjCount(c_in, c_out);
        return score;
    }

    double calcScoreFromObjCount(double[] c_in, double[] c_out) {
        double sum = 0.0;
        double max_val = Double.NEGATIVE_INFINITY;
        double min_val = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.numClass; ++i) {
            double diff = c_in[i] - c_out[i];
            if (diff > max_val) {
                max_val = diff;
            }
            if (diff < min_val) {
                min_val = diff;
            }
            sum += Math.abs(diff);
        }
        return sum - Math.abs(max_val) - Math.abs(min_val) + Math.abs(max_val - min_val);
    }

    void randomProjection(int R, double percent_mask, int sax_len) {
        HashMap Hash_Mark = new HashMap();
        int num_mask = (int)Math.ceil(percent_mask * (double)sax_len);
        for (int r = 0; r < R; ++r) {
            int new_word;
            HashSet obj_set;
            int word;
            int mask_word = this.createMaskWord(num_mask, sax_len);
            for (Map.Entry<Integer, USAX_elm_type> entry : this.uSAXMap.entrySet()) {
                word = entry.getKey();
                obj_set = entry.getValue().obj_set;
                new_word = word | mask_word;
                HashSet ptr = (HashSet)Hash_Mark.get(new_word);
                if (ptr == null) {
                    Hash_Mark.put(new_word, new HashSet(obj_set));
                    continue;
                }
                ptr.addAll(obj_set);
            }
            for (Map.Entry<Integer, USAX_elm_type> entry : this.uSAXMap.entrySet()) {
                word = entry.getKey();
                new_word = word | mask_word;
                obj_set = (HashSet)Hash_Mark.get(new_word);
                for (Integer o_it : obj_set) {
                    Integer count = entry.getValue().obj_count.get(o_it);
                    count = count == null ? 1 : count + 1;
                    entry.getValue().obj_count.put(o_it, count);
                }
            }
            Hash_Mark.clear();
        }
    }

    int createMaskWord(int num_mask, int word_len) {
        int a = 0;
        for (int i = 0; i < num_mask; ++i) {
            int b = 1 << this.rand.nextInt() % word_len;
            a |= b;
        }
        return a;
    }

    void setCurData(int node_id) {
        if (node_id == 1) {
            this.data = new ArrayList();
            for (ArrayList<Double> a : this.orgData) {
                this.data.add(GenericTools.cloneArrayList(a));
            }
            this.Label = GenericTools.cloneArrayList(this.Org_Label);
            this.classFreq = new int[this.orgClassFreq.length];
            System.arraycopy(this.orgClassFreq, 0, this.classFreq, 0, this.orgClassFreq.length);
        } else {
            ArrayList<Integer> it = this.nodeObjList.get(node_id);
            this.numObj = it.size();
            this.data.clear();
            this.Label.clear();
            for (int i = 0; i < this.numClass; ++i) {
                this.classFreq[i] = 0;
            }
            for (Integer in : it) {
                int cur_class = this.Org_Label.get(in);
                this.data.add(this.orgData.get(in));
                this.Label.add(cur_class);
                int n = cur_class;
                this.classFreq[n] = this.classFreq[n] + 1;
            }
        }
        this.classEntropy = this.entropyArray(this.classFreq, this.numObj);
    }

    double entropyArray(int[] A, int total) {
        double en = 0.0;
        for (int i = 0; i < this.numClass; ++i) {
            double a = (double)A[i] / (double)total;
            if (!(a > 0.0)) continue;
            en -= a * Math.log(a);
        }
        return en;
    }

    void readTrainData(Instances data) {
        this.orgData = InstanceTools.fromWekaInstancesList(data);
        this.orgClassFreq = new int[this.numClass];
        this.Org_Label = new ArrayList();
        for (Instance i : data) {
            this.Org_Label.add((int)i.classValue());
            int n = (int)i.classValue();
            this.orgClassFreq[n] = this.orgClassFreq[n] + 1;
        }
    }

    int createSAXWord(double[] sum_segment, int[] elm_segment, double mean, double std, int sax_len) {
        int word = 0;
        int val = 0;
        double d = 0.0;
        for (int i = 0; i < sax_len; ++i) {
            d = (sum_segment[i] / (double)elm_segment[i] - mean) / std;
            val = d < 0.0 ? (d < -0.67 ? 0 : 1) : (d < 0.67 ? 2 : 3);
            word = word << 2 | val;
        }
        return word;
    }

    void createSAXList(int subseq_len, int sax_len, int w) {
        int k;
        double[] sum_segment = new double[sax_len];
        int[] elm_segment = new int[sax_len];
        for (k = 0; k < sax_len; ++k) {
            elm_segment[k] = w;
        }
        elm_segment[sax_len - 1] = subseq_len - (sax_len - 1) * w;
        for (int series = 0; series < this.data.size(); ++series) {
            double d;
            int j;
            double ex2 = 0.0;
            double ex = 0.0;
            int prev_word = -1;
            for (k = 0; k < sax_len; ++k) {
                sum_segment[k] = 0.0;
            }
            for (j = 0; j < this.data.get(series).size() && j < subseq_len; ++j) {
                int slot;
                d = this.data.get(series).get(j);
                ex += d;
                ex2 += d * d;
                int n = slot = (int)Math.floor(j / w);
                sum_segment[n] = sum_segment[n] + d;
            }
            while (j <= this.data.get(series).size()) {
                int j_st = j - subseq_len;
                double mean = ex / (double)subseq_len;
                double std = Math.sqrt(ex2 / (double)subseq_len - mean * mean);
                int word = this.createSAXWord(sum_segment, elm_segment, mean, std, sax_len);
                if (word != prev_word) {
                    prev_word = word;
                    USAX_elm_type ptr = this.uSAXMap.get(word);
                    if (ptr == null) {
                        ptr = new USAX_elm_type();
                    }
                    ptr.obj_set.add(series);
                    ptr.sax_id.add(new Pair<Integer, Integer>(series, j_st));
                    this.uSAXMap.put(word, ptr);
                }
                if (j < this.data.get(series).size()) {
                    double temp = this.data.get(series).get(j_st);
                    ex -= temp;
                    ex2 -= temp * temp;
                    for (k = 0; k < sax_len - 1; ++k) {
                        int n = k;
                        sum_segment[n] = sum_segment[n] - this.data.get(series).get(j_st + k * w);
                        int n2 = k;
                        sum_segment[n2] = sum_segment[n2] + this.data.get(series).get(j_st + (k + 1) * w);
                    }
                    int n = k;
                    sum_segment[n] = sum_segment[n] - this.data.get(series).get(j_st + k * w);
                    int n3 = k;
                    sum_segment[n3] = sum_segment[n3] + this.data.get(series).get(j_st + Math.min((k + 1) * w, subseq_len));
                    d = this.data.get(series).get(j);
                    ex += d;
                    ex2 += d * d;
                }
                ++j;
            }
        }
    }

    void setNextNodeObj(int node_id, Shapelet sh) {
        int max_tree_dept;
        int i;
        int q_obj = sh.obj;
        int q_pos = sh.pos;
        int q_len = sh.len;
        double dist_th = sh.dist_th;
        double[] query = new double[q_len];
        int left_node_id = node_id * 2;
        int right_node_id = node_id * 2 + 1;
        while (this.nodeObjList.size() <= right_node_id) {
            this.nodeObjList.add(new ArrayList());
            this.classifyList.add(-2);
            this.finalSh.add(new Shapelet());
            if (this.nodeObjList.size() != 2) continue;
            for (i = 0; i < this.numObj; ++i) {
                this.nodeObjList.get(1).add(i);
            }
        }
        this.finalSh.set(node_id, sh);
        for (i = 0; i < q_len; ++i) {
            query[i] = this.data.get(q_obj).get(q_pos + i);
        }
        int m = query.length;
        double[] Q = new double[m];
        int[] order = new int[m];
        for (int obj = 0; obj < this.numObj; ++obj) {
            double dist = this.nn.nearestNeighborSearch(query, this.data.get(obj), obj, Q, order);
            int real_obj = this.nodeObjList.get(node_id).get(obj);
            int node = dist <= dist_th ? left_node_id : right_node_id;
            this.nodeObjList.get(node).add(real_obj);
        }
        int max_c_in = -1;
        int sum_c_in = 0;
        int max_c_out = -1;
        int sum_c_out = 0;
        int max_ind_c_in = -1;
        int max_ind_c_out = -1;
        for (int i2 = 0; i2 < sh.c_in.length; ++i2) {
            int c_in_i = sh.c_in[i2];
            int c_out_i = sh.c_out[i2];
            sum_c_in += c_in_i;
            if (max_c_in < c_in_i) {
                max_c_in = c_in_i;
                max_ind_c_in = i2;
            }
            sum_c_out += c_out_i;
            if (max_c_out >= c_out_i) continue;
            max_c_out = c_out_i;
            max_ind_c_out = i2;
        }
        boolean left_is_leaf = false;
        boolean right_is_leaf = false;
        this.MIN_OBJ_SPLIT = (int)Math.ceil((double)(0.1f * (float)this.numObj) / (double)this.numClass);
        if (sum_c_in <= this.MIN_OBJ_SPLIT || (double)max_c_in / (double)sum_c_in >= (double)0.9f) {
            left_is_leaf = true;
        }
        if (sum_c_out <= this.MIN_OBJ_SPLIT || (double)max_c_out / (double)sum_c_out >= (double)0.9f) {
            right_is_leaf = true;
        }
        if ((double)node_id >= Math.pow(2.0, max_tree_dept = (int)(2.0 + Math.ceil(Math.log(this.numClass) / Math.log(2.0))))) {
            left_is_leaf = true;
            right_is_leaf = true;
        }
        this.classifyList.set(node_id, -1);
        int val = left_is_leaf ? max_ind_c_in : -1;
        this.classifyList.set(left_node_id, val);
        val = right_is_leaf ? max_ind_c_out : -1;
        this.classifyList.set(right_node_id, val);
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        double[] dArray = instance.toDoubleArray();
        ArrayList<Double> data = new ArrayList<Double>();
        for (int i = 0; i < dArray.length - 1; ++i) {
            data.add(dArray[i]);
        }
        int tree_size = this.nodeObjList.size();
        int node_id = 1;
        while (this.classifyList.get(node_id) < 0 || node_id > tree_size) {
            double dist_th;
            Shapelet node = this.finalSh.get(node_id);
            int m = node.len;
            double[] Q = new double[m];
            int[] order = new int[m];
            double d = this.nn.nearestNeighborSearch(node.ts, data, 0, Q, order);
            if (d <= (dist_th = node.dist_th)) {
                node_id = 2 * node_id;
                continue;
            }
            node_id = 2 * node_id + 1;
        }
        return this.classifyList.get(node_id).intValue();
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        double c = this.classifyInstance(instance);
        double[] r = new double[instance.numClasses()];
        r[(int)c] = 1.0;
        return r;
    }

    @Override
    public Capabilities getCapabilities() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void main(String[] args) throws Exception {
        String dotdotSlash = ".." + File.separator;
        String datasetName = "ItalyPowerDemand";
        String datasetLocation = dotdotSlash + dotdotSlash + "resampled data sets" + File.separator + datasetName + File.separator + datasetName;
        for (int i = 0; i < 100; ++i) {
            Instances train = ClassifierTools.loadData(datasetLocation + i + "_TRAIN");
            Instances test = ClassifierTools.loadData(datasetLocation + i + "_TEST");
            FastShapelets fs = new FastShapelets();
            try {
                fs.buildClassifier(train);
                double accuracy = ClassifierTools.accuracy(test, fs);
                System.out.println("fold " + i + " acc: " + accuracy);
                continue;
            }
            catch (Exception ex) {
                System.out.println("Exception " + ex);
            }
        }
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    private class NN_ED {
        double nearestNeighborSearch(double[] query, ArrayList<Double> data, int obj_id, double[] Q, int[] order) {
            double std;
            double mean;
            double d;
            int loc = 0;
            int m = query.length;
            int M = data.size();
            double bsf = Double.MAX_VALUE;
            int i = 0;
            int j = 0;
            double ex2 = 0.0;
            double ex = 0.0;
            if (obj_id == 0) {
                for (i = 0; i < m; ++i) {
                    d = query[i];
                    ex += d;
                    ex2 += d * d;
                    Q[i] = d;
                }
                mean = ex / (double)m;
                std = ex2 / (double)m;
                std = Math.sqrt(std - mean * mean);
                for (i = 0; i < m; ++i) {
                    Q[i] = (Q[i] - mean) / std;
                }
                Object[] Q_tmp = new Index[m];
                for (i = 0; i < m; ++i) {
                    Q_tmp[i] = new Index();
                    ((Index)Q_tmp[i]).value = Q[i];
                    ((Index)Q_tmp[i]).index = i;
                }
                Arrays.sort(Q_tmp);
                for (i = 0; i < m; ++i) {
                    Q[i] = ((Index)Q_tmp[i]).value;
                    order[i] = ((Index)Q_tmp[i]).index;
                }
            }
            j = 0;
            ex2 = 0.0;
            ex = 0.0;
            double[] T = new double[2 * m];
            double dist = 0.0;
            for (i = 0; i < M; ++i) {
                d = data.get(i);
                ex += d;
                ex2 += d * d;
                T[i % m] = d;
                T[i % m + m] = d;
                if (i < m - 1) continue;
                mean = ex / (double)m;
                std = ex2 / (double)m;
                j = (i + 1) % m;
                dist = this.distance(Q, order, T, j, m, mean, std = Math.sqrt(std - mean * mean), bsf);
                if (dist < bsf) {
                    bsf = dist;
                    loc = i - m + 1;
                }
                ex -= T[j];
                ex2 -= T[j] * T[j];
            }
            return bsf;
        }

        double distance(double[] Q, int[] order, double[] T, int j, int m, double mean, double std, double best_so_far) {
            double x;
            double sum = 0.0;
            double bsf2 = best_so_far * best_so_far;
            for (int i = 0; i < m && sum < bsf2; sum += (x - Q[i]) * (x - Q[i]), ++i) {
                x = (T[order[i] + j] - mean) / std;
            }
            return Math.sqrt(sum);
        }

        double distance(double[] Q, int[] order, double[] T, int j, int m, double mean, double std) {
            return this.distance(Q, order, T, j, m, mean, std, Double.MAX_VALUE);
        }

        private class Index
        implements Comparable<Index> {
            double value;
            int index;

            @Override
            public int compareTo(Index t) {
                return Math.abs((int)this.value) - Math.abs((int)t.value);
            }
        }
    }

    private class Pair<A, B> {
        public A first;
        public B second;

        Pair() {
        }

        Pair(A l, B r) {
            this.first = l;
            this.second = r;
        }
    }

    private class USAX_elm_type {
        HashSet<Integer> obj_set = new HashSet();
        ArrayList<Pair<Integer, Integer>> sax_id = new ArrayList();
        HashMap<Integer, Integer> obj_count = new HashMap();
    }

    private class Shapelet {
        public double gain = Double.NEGATIVE_INFINITY;
        public double gap = Double.NEGATIVE_INFINITY;
        public double dist_th = Double.POSITIVE_INFINITY;
        public int obj = -1;
        public int pos = -1;
        public int len = -1;
        public int num_diff = -1;
        int[] c_in;
        int[] c_out;
        double[] ts;

        void setValueFew(double gain, double gap, double dist_th) {
            this.gain = gain;
            this.gap = gap;
            this.dist_th = dist_th;
        }

        void setValueAll(double gain, double gap, double dist_th, int obj, int pos, int len, int num_diff, int[] in, int[] out) {
            this.gain = gain;
            this.gap = gap;
            this.dist_th = dist_th;
            this.obj = obj;
            this.pos = pos;
            this.len = len;
            this.num_diff = num_diff;
            this.c_in = new int[in.length];
            this.c_out = new int[out.length];
            System.arraycopy(in, 0, this.c_in, 0, in.length);
            System.arraycopy(out, 0, this.c_out, 0, out.length);
        }

        void setTS(double[] ts) {
            this.ts = ts;
        }

        private boolean lessThan(Shapelet other) {
            if (this.gain > other.gain) {
                return false;
            }
            return this.gain < other.gain || this.gain == other.gain && this.num_diff > other.num_diff || this.gain == other.gain && this.num_diff == other.num_diff && this.gap < other.gap;
        }
    }

    private class DistComparator
    implements Comparator<Pair<Integer, Double>> {
        private DistComparator() {
        }

        @Override
        public int compare(Pair<Integer, Double> t, Pair<Integer, Double> t1) {
            return Double.compare((Double)t.second, (Double)t1.second);
        }
    }

    private class ScoreComparator
    implements Comparator<Pair<Integer, Double>> {
        private ScoreComparator() {
        }

        @Override
        public int compare(Pair<Integer, Double> t, Pair<Integer, Double> t1) {
            return Double.compare((Double)t1.second, (Double)t.second);
        }
    }
}

