/*
 * Decompiled with CFR 0.152.
 */
package statistics.tests;

import fileIO.InFile;
import java.util.Arrays;
import statistics.tests.DataPoint;

public abstract class Tests {
    protected static int N;
    protected static int k;
    protected static int[] n;
    protected static DataPoint[][] dataByLevel;
    protected static DataPoint[] rankedData;
    protected static boolean loaded;
    protected static boolean debug;

    public static void loadData(String fileName) {
        int j;
        int i;
        InFile f = new InFile(fileName);
        k = f.readInt();
        n = new int[k];
        N = 0;
        dataByLevel = new DataPoint[k][];
        for (int i2 = 0; i2 < k; ++i2) {
            Tests.n[i2] = f.readInt();
            N += n[i2];
            Tests.dataByLevel[i2] = new DataPoint[n[i2]];
        }
        int c = 0;
        rankedData = new DataPoint[N];
        for (i = 0; i < k; ++i) {
            for (j = 0; j < n[i]; ++j) {
                double d = f.readDouble();
                Tests.dataByLevel[i][j] = new DataPoint(d, i, j);
                Tests.rankedData[c] = dataByLevel[i][j];
                ++c;
            }
        }
        Arrays.sort(rankedData);
        for (i = 0; i < N; ++i) {
            Tests.rankedData[i].rank = i + 1;
        }
        Tests.adjustRanksForDuplicates(rankedData);
        loaded = true;
        if (debug) {
            for (i = 0; i < k; ++i) {
                for (j = 0; j < n[i]; ++j) {
                    System.out.print(Tests.dataByLevel[i][j].d + "\t");
                }
                System.out.print("\n");
            }
        }
    }

    public static void loadData(double[][] data) {
        int i;
        k = data.length;
        n = new int[k];
        N = 0;
        dataByLevel = new DataPoint[k][];
        for (int i2 = 0; i2 < k; ++i2) {
            Tests.n[i2] = data[i2].length;
            N += n[i2];
            Tests.dataByLevel[i2] = new DataPoint[n[i2]];
        }
        int c = 0;
        rankedData = new DataPoint[N];
        for (i = 0; i < k; ++i) {
            for (int j = 0; j < n[i]; ++j) {
                Tests.dataByLevel[i][j] = new DataPoint(data[i][j], i, j);
                Tests.rankedData[c] = dataByLevel[i][j];
                ++c;
            }
        }
        Arrays.sort(rankedData);
        for (i = 0; i < N; ++i) {
            Tests.rankedData[i].rank = i + 1;
        }
        Tests.adjustRanksForDuplicates(rankedData);
        loaded = true;
    }

    public static void loadData(double[] data) {
        k = 1;
        n = new int[k];
        N = data.length;
        Tests.n[0] = data.length;
        dataByLevel = new DataPoint[k][];
        boolean c = false;
        rankedData = new DataPoint[N];
        for (int j = 0; j < N; ++j) {
            Tests.dataByLevel[0][j] = new DataPoint(data[j], 0, j);
            Tests.rankedData[j] = dataByLevel[0][j];
        }
        Arrays.sort(rankedData);
        for (int i = 0; i < N; ++i) {
            Tests.rankedData[i].rank = i + 1;
        }
        Tests.adjustRanksForDuplicates(rankedData);
        loaded = true;
    }

    protected static void adjustRanksForDuplicates(DataPoint[] ranks) {
        double e;
        double s;
        DataPoint first = ranks[0];
        int count = 0;
        boolean pos = false;
        for (int i = 1; i < ranks.length; ++i) {
            if (ranks[i].d != first.d) {
                if (count > 0) {
                    s = first.rank;
                    e = i;
                    for (int j = 0; j <= count; ++j) {
                        ranks[(int)(s - 1.0) + j].rank = (e + s) / 2.0;
                    }
                    count = 0;
                }
                first = ranks[i];
                continue;
            }
            ++count;
        }
        if (count > 0) {
            s = first.rank;
            e = ranks.length;
            for (int j = 0; j <= count; ++j) {
                ranks[(int)(s - 1.0) + j].rank = (e + s) / 2.0;
            }
            count = 0;
        }
    }

    public static void rank(DataPoint[] data) {
        Arrays.sort(data);
        for (int i = 0; i < data.length; ++i) {
            data[i].rank = i + 1;
        }
        Tests.adjustRanksForDuplicates(data);
    }

    static {
        loaded = false;
        debug = false;
    }
}

