/*
 * Decompiled with CFR 0.152.
 */
package statistics.tests;

import fileIO.InFile;
import java.util.Arrays;
import statistics.tests.DataPoint;

public class KruskalWallis {
    static InFile f;
    static int N;
    static int k;
    static int[] n;
    static String fileName;
    static DataPoint[][] dataByLevel;
    static DataPoint[] rankedData;
    static boolean debug;

    public static void main(String[] args) {
        int i;
        KruskalWallis.loadData();
        System.out.println("FILE =" + fileName + "\n Treatment levels =" + k + "\t Total data = " + N + " per level =" + n[0]);
        Arrays.sort(rankedData);
        for (int i2 = 0; i2 < N; ++i2) {
            KruskalWallis.rankedData[i2].rank = i2 + 1;
            if (!debug) continue;
            System.out.print(KruskalWallis.rankedData[i2].d + "\t");
        }
        KruskalWallis.adjustRanksForDuplicates();
        double[] rankSums = new double[k];
        for (i = 0; i < k; ++i) {
            rankSums[i] = 0.0;
            for (int j = 0; j < n[i]; ++j) {
                int n = i;
                rankSums[n] = rankSums[n] + KruskalWallis.dataByLevel[i][j].rank;
            }
        }
        double H = 0.0;
        for (i = 0; i < k; ++i) {
            H += rankSums[i] * rankSums[i] / (double)n[i];
        }
        H = H * 12.0 / (double)(N * (N + 1));
        System.out.println("\n\n H stat = " + (H -= (double)(3 * (N + 1))));
        i = 0;
        int nextPos = 0;
        int t = 0;
        int tSum = 0;
        int t3Sum = 0;
        while (i < N) {
            if (KruskalWallis.rankedData[i].rank != (double)(i + 1)) {
                t = (int)(2.0 * KruskalWallis.rankedData[i].rank) - i;
                nextPos = t - 1;
                t = t - i - 1;
                tSum += t;
                t3Sum += t * t * t;
                i = nextPos;
                continue;
            }
            ++i;
        }
        System.out.println("\n\n t sum = " + tSum + "\t t^3 sum = " + t3Sum);
        double C = 1.0 - ((double)t3Sum - (double)tSum) / (double)(N * (N * N - 1));
        double H_prime = H / C;
        System.out.println("\n\n C = " + C + "\t H* = " + H_prime);
    }

    public static void loadData() {
        int j;
        int i;
        f = new InFile(fileName);
        k = f.readInt();
        n = new int[k];
        N = 0;
        dataByLevel = new DataPoint[k][];
        for (int i2 = 0; i2 < k; ++i2) {
            KruskalWallis.n[i2] = f.readInt();
            N += n[i2];
            KruskalWallis.dataByLevel[i2] = new DataPoint[n[i2]];
        }
        int c = 0;
        rankedData = new DataPoint[N];
        for (i = 0; i < k; ++i) {
            for (j = 0; j < n[i]; ++j) {
                double d = f.readDouble();
                KruskalWallis.dataByLevel[i][j] = new DataPoint(d, i, j);
                KruskalWallis.rankedData[c] = dataByLevel[i][j];
                ++c;
            }
        }
        if (debug) {
            for (i = 0; i < k; ++i) {
                for (j = 0; j < n[i]; ++j) {
                    System.out.print(KruskalWallis.dataByLevel[i][j].d + "\t");
                }
                System.out.print("\n");
            }
        }
    }

    public static void adjustRanksForDuplicates() {
        double e;
        double s;
        DataPoint first = rankedData[0];
        int count = 0;
        boolean pos = false;
        for (int i = 1; i < N; ++i) {
            if (KruskalWallis.rankedData[i].d != first.d) {
                if (count > 0) {
                    s = first.rank;
                    e = i;
                    for (int j = 0; j <= count; ++j) {
                        KruskalWallis.rankedData[(int)(s - 1.0) + j].rank = (e + s) / 2.0;
                    }
                    count = 0;
                }
                first = rankedData[i];
                continue;
            }
            ++count;
        }
        if (count > 0) {
            s = first.rank;
            e = N;
            for (int j = 0; j <= count; ++j) {
                KruskalWallis.rankedData[(int)(s - 1.0) + j].rank = (e + s) / 2.0;
            }
            count = 0;
        }
    }

    static {
        fileName = "LearningRate100Rules.csv";
        debug = false;
    }
}

