/*
 * Decompiled with CFR 0.152.
 */
package statistics.simulators;

import fileIO.OutFile;
import statistics.distributions.NormalDistribution;
import statistics.simulators.Model;

public class SinusoidalModel
extends Model {
    boolean warpSeries = false;
    static double maxAmp = 3.0;
    double[] offset;
    boolean fixedOffset = true;
    double[] frequency;
    double[] amplitude;
    int maxN = 100;
    double interval = Math.PI / (double)this.maxN;
    static double defaultMin = 0.0;
    static double defaultMax = 1.0;

    void setWarp(boolean w) {
        this.warpSeries = w;
    }

    public void setFixedOffset(boolean b) {
        this.fixedOffset = b;
    }

    public SinusoidalModel(double[] p) {
        int i;
        if (p.length % 3 != 0) {
            System.out.println(" Error in Sinusoidal Model, the parameter list must be divisible by three (offset, frequency and amplitude");
            throw new IllegalArgumentException(" Error in Sinusoidal Model, the parameter list must be divisible by three (offset, frequency and amplitude");
        }
        this.offset = new double[p.length / 3];
        this.frequency = new double[p.length / 3];
        this.amplitude = new double[p.length / 3];
        int count = 0;
        for (i = 0; i < this.offset.length; ++i) {
            this.offset[i] = p[count++];
        }
        for (i = 0; i < this.frequency.length; ++i) {
            this.frequency[i] = p[count++];
        }
        for (i = 0; i < this.amplitude.length; ++i) {
            this.amplitude[i] = p[count++];
        }
    }

    public void setInterval(int n) {
        this.maxN = n;
        this.interval = Math.PI / (double)this.maxN;
    }

    @Override
    public void setParameters(double[] p) {
        int i;
        if (p.length % 3 != 0) {
            System.out.println(" Error in Sinusoidal Model, the parameter list must be divisible by three (offset, frequency and amplitude");
        }
        this.offset = new double[p.length / 3];
        this.frequency = new double[p.length / 3];
        this.amplitude = new double[p.length / 3];
        int count = 0;
        for (i = 0; i < this.offset.length; ++i) {
            this.offset[i] = p[count++];
        }
        for (i = 0; i < this.frequency.length; ++i) {
            this.frequency[i] = p[count++];
        }
        for (i = 0; i < this.amplitude.length; ++i) {
            this.amplitude[i] = p[count++];
        }
    }

    public SinusoidalModel(double[] offset, double[] frequency, double[] amplitude) {
        this.offset = new double[offset.length];
        System.arraycopy(offset, 0, this.offset, 0, offset.length);
        this.frequency = new double[frequency.length];
        System.arraycopy(frequency, 0, this.frequency, 0, frequency.length);
        this.amplitude = new double[amplitude.length];
        System.arraycopy(amplitude, 0, this.amplitude, 0, amplitude.length);
        this.t = 0.0;
        this.error = new NormalDistribution(0.0, this.variance);
    }

    public SinusoidalModel(double[] offset, double[] frequency, double[] amplitude, double s) {
        this.offset = new double[offset.length];
        System.arraycopy(offset, 0, this.offset, 0, offset.length);
        this.frequency = new double[frequency.length];
        System.arraycopy(frequency, 0, this.frequency, 0, frequency.length);
        this.amplitude = new double[amplitude.length];
        System.arraycopy(amplitude, 0, this.amplitude, 0, amplitude.length);
        this.t = 0.0;
        this.setVariance(s);
    }

    public void setSigma(double s) {
        this.setVariance(s);
    }

    @Override
    public double generate(double x) {
        double res = 0.0;
        for (int i = 0; i < this.offset.length; ++i) {
            res += maxAmp * this.amplitude[i] * Math.sin(Math.PI * this.offset[i] + (2.0 + 100.0 * this.frequency[i]) * x);
        }
        return res += this.error.simulate();
    }

    public double generateError() {
        return this.error.simulate();
    }

    @Override
    public double generate() {
        double res = 0.0;
        for (int i = 0; i < this.offset.length; ++i) {
            res += maxAmp * this.amplitude[i] * Math.sin(Math.PI * this.offset[i] + (2.0 + 100.0 * this.frequency[i]) * this.t);
        }
        this.t += this.interval;
        return res += this.error.simulate();
    }

    @Override
    public double[] generateSeries(int l) {
        double[] data = new double[l];
        this.reset();
        this.setInterval(l);
        for (int k = 0; k < l; ++k) {
            data[k] = this.generate();
        }
        if (!this.warpSeries) {
            return data;
        }
        double offsetPercent = 10.0;
        int offset = (int)((double)data.length * offsetPercent / 100.0);
        double[] newD = new double[data.length];
        System.arraycopy(data, 0, newD, 0, data.length);
        int warpPoint = (int)((double)offset + Math.random() * (double)(data.length - offset * 2));
        newD[warpPoint + offset] = data[warpPoint];
        newD[warpPoint - offset] = data[warpPoint - offset];
        for (int i = 1; i <= offset; ++i) {
            newD[warpPoint - offset + 2 * i - 1] = data[warpPoint - offset + i];
            newD[warpPoint - offset + 2 * i] = (data[warpPoint - offset + i] + data[warpPoint - offset + i + 1]) / 2.0;
        }
        return newD;
    }

    public static double[][] generateSinusoidalData(SinusoidalModel[] models, int length, int nosPerModel) {
        double[][] data = new double[models.length * nosPerModel][];
        for (int i = 0; i < models.length; ++i) {
            for (int j = 0; j < nosPerModel; ++j) {
                data[j + i * nosPerModel] = models[i].generateSeries(length);
            }
        }
        return data;
    }

    @Override
    public void reset() {
        super.reset();
        if (!this.fixedOffset) {
            double min = this.offset[0];
            double max = this.offset[0];
            for (int i = 1; i < this.offset.length; ++i) {
                if (min > this.offset[i]) {
                    min = this.offset[i];
                }
                if (!(max < this.offset[i])) continue;
                max = this.offset[i];
            }
            double shift = -min + (1.0 - max + min) * Math.random();
            int i = 1;
            while (i < this.offset.length) {
                int n = i++;
                this.offset[n] = this.offset[n] + shift;
            }
        }
    }

    public static SinusoidalModel generateRandomModel(int r, double min, double max) {
        double[] freq = new double[r];
        double[] off = new double[r];
        double[] amp = new double[r];
        for (int i = 0; i < r; ++i) {
        }
        SinusoidalModel a = new SinusoidalModel(off, freq, amp);
        return a;
    }

    public static SinusoidalModel generateRandomModelAmp(SinusoidalModel m, double maxDeviation) {
        int r = m.frequency.length;
        double[] freq = new double[r];
        double[] off = new double[r];
        double[] amp = new double[r];
        for (int i = 0; i < r; ++i) {
            double max;
            freq[i] = m.frequency[i];
            off[i] = m.offset[i];
            double min = m.amplitude[i] - maxDeviation;
            if (min < 0.0) {
                min = 0.0;
            }
            if (!((max = m.amplitude[i] + maxDeviation) > 1.0)) continue;
            max = 1.0;
        }
        SinusoidalModel a = new SinusoidalModel(off, freq, amp);
        return a;
    }

    public static SinusoidalModel generateRandomModelOff(SinusoidalModel m, double maxDeviation) {
        int r = m.frequency.length;
        double[] freq = new double[r];
        double[] off = new double[r];
        double[] amp = new double[r];
        for (int i = 0; i < r; ++i) {
            double max;
            freq[i] = m.frequency[i];
            amp[i] = m.amplitude[i];
            double min = m.offset[i] - maxDeviation;
            if (min < 0.0) {
                min = 0.0;
            }
            if (!((max = m.offset[i] + maxDeviation) > 1.0)) continue;
            max = 1.0;
        }
        SinusoidalModel a = new SinusoidalModel(off, freq, amp);
        return a;
    }

    public static SinusoidalModel generateRandomModelFreq(SinusoidalModel m, double maxDeviation) {
        int r = m.frequency.length;
        double[] freq = new double[r];
        double[] off = new double[r];
        double[] amp = new double[r];
        for (int i = 0; i < r; ++i) {
            double max;
            amp[i] = m.amplitude[i];
            off[i] = m.offset[i];
            double min = m.frequency[i] - maxDeviation;
            if (min < 0.0) {
                min = 0.0;
            }
            if (!((max = m.frequency[i] + maxDeviation) > 1.0)) continue;
            max = 1.0;
        }
        SinusoidalModel a = new SinusoidalModel(off, freq, amp);
        return a;
    }

    public static SinusoidalModel generateRandomModel(SinusoidalModel m, double maxDeviation) {
        int r = m.frequency.length;
        double[] freq = new double[r];
        double[] off = new double[r];
        double[] amp = new double[r];
        for (int i = 0; i < r; ++i) {
            double max;
            double min = m.frequency[i] - maxDeviation;
            if (min < 0.0) {
                min = 0.0;
            }
            if ((max = m.frequency[i] + maxDeviation) > 1.0) {
                max = 1.0;
            }
            if ((min = m.offset[i] - maxDeviation) < 0.0) {
                min = 0.0;
            }
            if ((max = m.offset[i] + maxDeviation) > 1.0) {
                max = 1.0;
            }
            if ((min = m.amplitude[i] - maxDeviation) < 0.0) {
                min = 0.0;
            }
            max = m.amplitude[i] + maxDeviation;
        }
        SinusoidalModel a = new SinusoidalModel(off, freq, amp);
        return a;
    }

    public static SinusoidalModel generateRandomModel(int r, double minO, double maxO, double minF, double maxF, double minA, double maxA) {
        double[] freq = new double[r];
        double[] off = new double[r];
        double[] amp = new double[r];
        for (int i = 0; i < r; ++i) {
        }
        SinusoidalModel a = new SinusoidalModel(off, freq, amp);
        return a;
    }

    public static SinusoidalModel generateRandomModel(int r) {
        return SinusoidalModel.generateRandomModel(r, defaultMin, defaultMax);
    }

    public static SinusoidalModel perturbSinusoidalModel(SinusoidalModel base, int maxPercentDev) {
        int r = base.frequency.length;
        double[] freq = new double[r];
        double[] off = new double[r];
        double[] amp = new double[r];
        for (int i = 0; i < r; ++i) {
        }
        SinusoidalModel a = new SinusoidalModel(off, freq, amp);
        return a;
    }

    public void randomiseOffset() {
    }

    double[] getOffset() {
        return this.offset;
    }

    double[] getFrequency() {
        return this.frequency;
    }

    double[] getAmplitude() {
        return this.amplitude;
    }

    void setAmplitude(double[] a) {
        this.amplitude = a;
    }

    void setOffset(double[] o) {
        this.offset = o;
    }

    public String toString() {
        int i;
        String str = "";
        for (i = 0; i < this.offset.length; ++i) {
            str = str + this.offset[i] + ",";
        }
        str = str + "\n";
        for (i = 0; i < this.frequency.length; ++i) {
            str = str + this.frequency[i] + ",";
        }
        str = str + "\n";
        for (i = 0; i < this.amplitude.length; ++i) {
            str = str + this.amplitude[i] + ",";
        }
        str = str + "\n";
        return str;
    }

    public static void sampleData() {
        int j;
        int i;
        OutFile of = new OutFile("randomFFTData_3Waves.csv");
        int k = 2;
        int n = 256;
        int l = 5;
        SinusoidalModel[] models = new SinusoidalModel[k];
        double[][] data = new double[k * l][n];
        for (i = 0; i < k; ++i) {
            models[i] = SinusoidalModel.generateRandomModel(3);
            for (j = 0; j < l; ++j) {
                data[i * l + j] = models[i].generateSeries(n);
            }
        }
        for (i = 0; i < n; ++i) {
            for (j = 0; j < k * l; ++j) {
                of.writeString(data[j][i] + ",");
            }
            of.writeString("\n");
        }
        for (i = 0; i < k; ++i) {
            of.writeLine(models[i].toString());
        }
    }

    public static void main(String[] args) {
        System.out.println(" To do: test harness for Sinusoidal models");
    }
}

