/*
 * Decompiled with CFR 0.152.
 */
package statistics.simulators;

import fileIO.OutFile;
import statistics.simulators.DataSimulator;
import statistics.simulators.Model;
import statistics.simulators.ShapeletModel;
import weka.core.Instances;

public class SimulateShapeletData
extends DataSimulator {
    public static Instances generateShapeletData(int seriesLength, int[] casesPerClass) {
        if (casesPerClass.length != 2) {
            System.err.println("ONLY WORKS WITH TWO CLASS PROBS AT THE MOMENT");
            int[] tmp = new int[]{0, 0};
            casesPerClass = tmp;
        }
        Model[] shapeMod = new ShapeletModel[casesPerClass.length];
        SimulateShapeletData.populateShapeletArray((ShapeletModel[])shapeMod, seriesLength);
        DataSimulator sim = new DataSimulator(shapeMod);
        sim.setSeriesLength(seriesLength);
        sim.setCasesPerClass(casesPerClass);
        Instances d = sim.generateDataSet();
        return d;
    }

    private static void populateShapeletArray(ShapeletModel[] s, int seriesLength) {
        double[] p1 = new double[]{seriesLength, 1.0};
        double[] p2 = new double[]{seriesLength, 1.0};
        s[0] = new ShapeletModel(p1);
        ShapeletModel.ShapeType st = s[0].getShapeType();
        s[1] = new ShapeletModel(p2);
        while (st == s[1].getShapeType()) {
            s[1] = new ShapeletModel(p2);
        }
    }

    public static void checkGlobalSeedForIntervals() {
        Model.setDefaultSigma(0.0);
        Model.setGlobalRandomSeed(0);
        Instances d = SimulateShapeletData.generateShapeletData(100, new int[]{2, 2});
        OutFile of = new OutFile("C:\\Temp\\randZeroNoiseSeed0.csv");
        of.writeLine(d.toString());
        Model.setDefaultSigma(0.1);
        Model.setGlobalRandomSeed(1);
        System.out.println(" NOISE 0");
        d = SimulateShapeletData.generateShapeletData(100, new int[]{2, 2});
        of = new OutFile("C:\\Temp\\randUnitNoiseSeed1.csv");
        of.writeLine(d.toString());
        Model.setDefaultSigma(0.0);
        Model.setGlobalRandomSeed(0);
        System.out.println(" NO NOISE 1");
        d = SimulateShapeletData.generateShapeletData(100, new int[]{2, 2});
        of = new OutFile("C:\\Temp\\randZeroNoiseSeed0REP.csv");
        of.writeLine(d.toString());
        Model.setDefaultSigma(0.1);
        Model.setGlobalRandomSeed(1);
        System.out.println(" NOISE 1");
        d = SimulateShapeletData.generateShapeletData(100, new int[]{2, 2});
        of = new OutFile("C:\\Temp\\randUnitNoiseSeed1REP.csv");
        of.writeLine(d.toString());
    }

    public static void main(String[] args) {
        SimulateShapeletData.checkGlobalSeedForIntervals();
        System.exit(0);
        int[] casesPerClass = new int[]{5, 5};
        int seriesLength = 100;
        Model.setDefaultSigma(0.0);
        Model.setGlobalRandomSeed(0);
        System.out.println("Model seed =" + Model.getRandomSeed());
        Instances data = SimulateShapeletData.generateShapeletData(seriesLength, casesPerClass);
        System.out.println("DATA " + data);
        System.out.println("Model seed AFTER =" + Model.getRandomSeed());
        OutFile out = new OutFile("C:\\temp\\ShapeletData.csv");
        out.writeString(data.toString());
    }
}

