/*
 * Decompiled with CFR 0.152.
 */
package statistics.simulators;

import statistics.simulators.DataSimulator;
import statistics.simulators.DictionaryModel;
import statistics.simulators.ElasticModel;
import statistics.simulators.Model;
import weka.core.Instances;

public class SimulateElasticData {
    static DataSimulator sim;
    static double warpPercent;

    public static Instances generateElasticData(int seriesLength, int[] casesPerClass) {
        Model[] elastic = new ElasticModel[casesPerClass.length];
        SimulateElasticData.populateElasticModels((ElasticModel[])elastic, seriesLength);
        sim = new DataSimulator(elastic);
        sim.setSeriesLength(seriesLength);
        sim.setCasesPerClass(casesPerClass);
        Instances d = sim.generateDataSet();
        return d;
    }

    private static void populateElasticModels(ElasticModel[] m, int seriesLength) {
        if (m.length != 2) {
            System.out.println("ONLY IMPLEMENTED FOR TWO CLASSES");
        }
        ElasticModel m1 = new ElasticModel();
        m1.setSeriesLength(seriesLength);
        ElasticModel m2 = new ElasticModel();
        m2.setSeriesLength(seriesLength);
        DictionaryModel.ShapeType[] vals = new DictionaryModel.ShapeType[]{DictionaryModel.ShapeType.TRIANGLE, DictionaryModel.ShapeType.STEP, DictionaryModel.ShapeType.HEADSHOULDERS};
        DictionaryModel.ShapeType shape = vals[Model.rand.nextInt(vals.length)];
        m1.setShape(shape);
        shape = vals[Model.rand.nextInt(vals.length)];
        while (shape == m1.getShape()) {
            shape = vals[Model.rand.nextInt(vals.length)];
        }
        m2.setShape(shape);
        m[0] = m1;
        m[1] = m2;
    }

    static {
        warpPercent = 0.1;
    }
}

