/*
 * Decompiled with CFR 0.152.
 */
package statistics.simulators;

import fileIO.OutFile;
import statistics.simulators.DataSimulator;
import statistics.simulators.DictionaryModel;
import statistics.simulators.Model;
import utilities.InstanceTools;
import weka.core.Instances;

public class SimulateDictionaryData {
    static int[] shapeletsPerClass = new int[]{5, 20};
    static int shapeLength = 11;
    static DataSimulator sim;

    public static void setShapeletsPerClass(int[] c) {
        shapeletsPerClass = new int[c.length];
        for (int i = 0; i < c.length; ++i) {
            SimulateDictionaryData.shapeletsPerClass[i] = c[i];
        }
    }

    public static void setShapeletLength(int s) {
        shapeLength = s;
    }

    public static Instances generateDictionaryData(int seriesLength, int[] casesPerClass) {
        if (casesPerClass.length != 2) {
            System.err.println("Incorrect parameters, dataset will not be correct.");
            int[] tmp = new int[]{0, 0};
            casesPerClass = tmp;
        }
        Model[] shapeMod = new DictionaryModel[casesPerClass.length];
        SimulateDictionaryData.populateRepeatedShapeletArray((DictionaryModel[])shapeMod, seriesLength);
        sim = new DataSimulator(shapeMod);
        sim.setSeriesLength(seriesLength);
        sim.setCasesPerClass(casesPerClass);
        Instances d = sim.generateDataSet();
        return d;
    }

    private static void populateRepeatedShapeletArray(DictionaryModel[] s, int seriesLength) {
        int i;
        if (s.length != shapeletsPerClass.length) {
            throw new RuntimeException("Error, mismatch in number of classes: " + s.length + " VS " + shapeletsPerClass.length);
        }
        for (int i2 = 0; i2 < s.length; ++i2) {
            double[] p1 = new double[]{seriesLength, shapeletsPerClass[0 + i2], shapeletsPerClass[(1 + i2) % 2], shapeLength};
            s[i2] = new DictionaryModel(p1);
        }
        DictionaryModel.ShapeType st = s[0].getShape1();
        for (i = 1; i < s.length; ++i) {
            s[i].setShape1Type(st);
        }
        st = s[0].getShape2();
        for (i = 1; i < s.length; ++i) {
            s[i].setShape2Type(st);
        }
    }

    public static void generateExampleData() {
        int seriesLength = 1000;
        Model.setDefaultSigma(0.1);
        Instances noNoise = SimulateDictionaryData.generateDictionaryData(seriesLength, new int[]{20, 20});
        Model.setDefaultSigma(1.0);
        Instances noise = SimulateDictionaryData.generateDictionaryData(seriesLength, new int[]{20, 20});
        OutFile of = new OutFile("C:\\temp\\DictionaryNoNoise.csv");
        of.writeString(noNoise.toString());
        OutFile of2 = new OutFile("C:\\temp\\DictionaryNoise.csv");
        of2.writeString(noise.toString());
    }

    public static void checkGlobalSeedForIntervals() {
        Model.setDefaultSigma(0.0);
        Model.setGlobalRandomSeed(0);
        Instances d = SimulateDictionaryData.generateDictionaryData(100, new int[]{2, 2});
        OutFile of = new OutFile("C:\\Temp\\randZeroNoiseSeed0.csv");
        of.writeLine(d.toString());
        Model.setDefaultSigma(0.1);
        Model.setGlobalRandomSeed(1);
        d = SimulateDictionaryData.generateDictionaryData(100, new int[]{2, 2});
        of = new OutFile("C:\\Temp\\randUnitNoiseSeed1.csv");
        of.writeLine(d.toString());
        Model.setDefaultSigma(0.0);
        Model.setGlobalRandomSeed(0);
        d = SimulateDictionaryData.generateDictionaryData(100, new int[]{2, 2});
        of = new OutFile("C:\\Temp\\randZeroNoiseSeed0REP.csv");
        of.writeLine(d.toString());
        Model.setDefaultSigma(0.1);
        Model.setGlobalRandomSeed(1);
        d = SimulateDictionaryData.generateDictionaryData(100, new int[]{2, 2});
        of = new OutFile("C:\\Temp\\randUnitNoiseSeed1REP.csv");
        of.writeLine(d.toString());
    }

    public static void main(String[] args) {
        SimulateDictionaryData.checkGlobalSeedForIntervals();
        System.exit(0);
        Model.setDefaultSigma(0.0);
        Model.setGlobalRandomSeed(0);
        Instances d = SimulateDictionaryData.generateDictionaryData(59, new int[]{2, 2});
        Instances[] split = InstanceTools.resampleInstances(d, 0L, 0.5);
        System.out.println(" DATA " + d);
        OutFile of = new OutFile("C:\\Temp\\dictionarySimulationTest.csv");
        of.writeString(split[0].toString());
        of = new OutFile("C:\\Temp\\dictionarySimulationTrain.csv");
        of.writeString(split[1].toString());
    }
}

