/*
 * Decompiled with CFR 0.152.
 */
package statistics.simulators;

import fileIO.OutFile;
import java.io.IOException;
import java.util.ArrayList;
import statistics.simulators.Model;

public class ShapeletModel
extends Model {
    protected ArrayList<Shape> shapes;
    private static int DEFAULTNUMSHAPELETS = 1;
    private static int DEFAULTSERIESLENGTH = 500;
    private static int DEFAULTSHAPELETLENGTH = 29;
    private static int DEFAULTBASE = -1;
    private static int DEFAULTAMP = 4;
    protected int numShapelets;
    protected int seriesLength;
    protected int shapeletLength;

    public ShapeletModel() {
        this(new double[]{DEFAULTSERIESLENGTH, DEFAULTNUMSHAPELETS, DEFAULTSHAPELETLENGTH});
    }

    public final void setDefaults() {
        this.seriesLength = DEFAULTSERIESLENGTH;
        this.numShapelets = DEFAULTNUMSHAPELETS;
        this.shapeletLength = DEFAULTSHAPELETLENGTH;
    }

    public ShapeletModel(double[] param) {
        this.setDefaults();
        if (param != null) {
            switch (param.length) {
                default: {
                    this.shapeletLength = (int)param[2];
                }
                case 2: {
                    this.numShapelets = (int)param[1];
                }
                case 1: 
            }
            this.seriesLength = (int)param[0];
        }
        this.shapes = new ArrayList();
        for (int i = 0; i < this.numShapelets; ++i) {
            Shape sh = new Shape(this.shapeletLength);
            sh.randomiseShape();
            this.shapes.add(sh);
        }
    }

    public ShapeletModel(int s) {
        this(new double[]{s});
    }

    public ShapeletModel(int seriesLength, Shape shape) {
        this.setDefaults();
        this.shapes = new ArrayList();
        for (int i = 0; i < this.numShapelets; ++i) {
            Shape sh = new Shape(this.shapeletLength);
            sh.randomiseShape();
            this.shapes.add(sh);
        }
    }

    public ShapeletModel(ArrayList<Shape> s) {
        this.shapes = new ArrayList<Shape>(s);
    }

    @Override
    public double[] generateSeries(int n) {
        this.t = 0.0;
        for (Shape s : this.shapes) {
            s.randomiseLocation();
        }
        double[] d = new double[n];
        for (int i = 0; i < n; ++i) {
            d[i] = this.generate();
        }
        return d;
    }

    @Override
    public double generate(double x) {
        double value = this.error.simulate();
        for (Shape s : this.shapes) {
            value += s.generate((int)x);
        }
        return value;
    }

    @Override
    public double generate() {
        double value = this.generate(this.t);
        this.t += 1.0;
        return value;
    }

    @Override
    public void setParameters(double[] p) {
    }

    @Override
    public void reset() {
        this.t = 0.0;
    }

    public ShapeType getShapeType() {
        return this.shapes.get(0).type;
    }

    public void setShapeType(ShapeType st) {
        for (Shape s : this.shapes) {
            s.setType(st);
        }
    }

    public String toString() {
        String str = "nos shapes = " + this.shapes.size() + "\n";
        for (Shape s : this.shapes) {
            str = str + s.toString() + "\n";
        }
        return str;
    }

    @Override
    public String getModelType() {
        return "ShapeletSimulator";
    }

    @Override
    public String getAttributeName() {
        return "Shape";
    }

    @Override
    public String getHeader() {
        String header = super.getHeader();
        header = header + "% Shapelet Length =" + this.shapeletLength;
        header = header + "% Series Length =" + this.seriesLength;
        header = header + "% Number of Shapelets =" + this.numShapelets;
        for (int i = 0; i < this.shapes.size(); ++i) {
            header = header + "%\t Shape " + i + " " + (Object)((Object)this.shapes.get(i).type) + "\n";
        }
        return header;
    }

    public void setShapeletLength(int l) {
        this.shapeletLength = l;
        for (Shape s : this.shapes) {
            s.setLength(l);
        }
    }

    public static void main(String[] args) throws IOException {
        Model.setDefaultSigma(0.0);
        Model.setGlobalRandomSeed(0);
        for (int shapeletLength = 8; shapeletLength <= 30; ++shapeletLength) {
            for (ShapeType st : ShapeType.values()) {
                ShapeletModel model = new ShapeletModel();
                model.setShapeType(st);
                model.setShapeletLength(shapeletLength);
                OutFile out = new OutFile("C:\\temp\\" + st.toString() + shapeletLength + ".csv");
                model.seriesLength = shapeletLength;
                out.writeString(st.name() + "\n");
                double[] series = model.generateSeries(model.seriesLength);
                for (int i = 0; i < model.seriesLength; ++i) {
                    out.writeLine(series[i] + ",");
                }
                out.writeString("\n");
            }
        }
    }

    public class Shape {
        private ShapeType type;
        private int length;
        private double base;
        private double amp;
        private int location;

        private Shape() {
            this(ShapeType.HEADSHOULDERS, DEFAULTSHAPELETLENGTH, DEFAULTBASE, DEFAULTAMP);
        }

        private Shape(int length) {
            this(ShapeType.HEADSHOULDERS, length, DEFAULTBASE, DEFAULTAMP);
        }

        private Shape(ShapeType t, int l, double b, double a) {
            this.type = t;
            this.length = l;
            this.base = b;
            this.amp = a;
        }

        private double generate(int t) {
            if (t < this.location || t > this.location + this.length - 1) {
                return 0.0;
            }
            int offset = t - this.location;
            double value = 0.0;
            int lower = 0;
            int mid = 0;
            int upper = 0;
            switch (this.type) {
                case TRIANGLE: {
                    mid = this.length / 2;
                    if (offset <= mid) {
                        if (offset == 0) {
                            value = this.base;
                            break;
                        }
                        value = (double)offset / (double)mid * this.amp + this.base;
                        break;
                    }
                    if (offset >= this.length) {
                        value = this.base;
                        break;
                    }
                    if (this.length % 2 == 1) {
                        value = (double)(this.length - offset - 1) / (double)mid * this.amp + this.base;
                        break;
                    }
                    value = (double)(this.length - offset) / (double)mid * this.amp + this.base;
                    break;
                }
                case HEADSHOULDERS: {
                    lower = this.length / 3;
                    upper = 2 * lower;
                    if (this.length % 3 == 2) {
                        upper += 2;
                    }
                    if (!((value = offset < lower ? this.amp / 2.0 * Math.sin(Math.PI * 2 / (double)((this.length / 3 - 1) * 2) * (double)offset) + this.base : (offset >= upper ? this.amp / 2.0 * Math.sin(Math.PI * 2 / (double)((this.length / 3 - 1) * 2) * (double)(offset - upper)) + this.base : this.amp * Math.sin(Math.PI * 2 / (double)((upper - lower - 1) * 2) * (double)(offset - this.length / 3)) + this.base)) < this.base)) break;
                    value = this.base;
                    break;
                }
                case SINE: {
                    value = this.amp * Math.sin(Math.PI * 2 / (double)(this.length - 1) * (double)offset) / 2.0;
                    break;
                }
                case STEP: {
                    if (offset < this.length / 2) {
                        value = this.base;
                        break;
                    }
                    value = this.base + this.amp;
                    break;
                }
                case SPIKE: {
                    lower = this.length / 4;
                    upper = 3 * lower;
                    if (offset <= lower) {
                        if (offset == 0) {
                            value = 0.0;
                            break;
                        }
                        value = -this.amp / 2.0 * ((double)offset / (double)lower);
                        break;
                    }
                    value = offset > lower && offset < upper ? -this.amp / 2.0 + this.amp * ((double)(offset - lower) / (double)(upper - lower - 1)) : this.amp / 2.0 - this.amp / 2.0 * ((double)(offset - upper + 1) / (double)(this.length - upper));
                }
            }
            return value;
        }

        private void setLocation(int newLoc) {
            this.location = newLoc;
        }

        private void setType(ShapeType newType) {
            this.type = newType;
            this.base = newType == ShapeType.HEADSHOULDERS ? -this.amp / 4.0 : -this.amp / 2.0;
        }

        private void setLength(int newLength) {
            this.length = newLength;
        }

        private boolean randomiseLocation() {
            int start = 0;
            if (ShapeletModel.this.seriesLength > ShapeletModel.this.shapeletLength) {
                start = Model.rand.nextInt(ShapeletModel.this.seriesLength - ShapeletModel.this.shapeletLength);
            }
            this.setLocation(start);
            return true;
        }

        public String toString() {
            return "" + (Object)((Object)this.type) + " start = " + this.location + " length =" + this.length;
        }

        private boolean randomiseShape() {
            ShapeType[] types = ShapeType.values();
            int ranType = Model.rand.nextInt(types.length);
            this.setType(types[ranType]);
            return true;
        }
    }

    public static enum ShapeType {
        TRIANGLE,
        HEADSHOULDERS,
        SINE,
        STEP,
        SPIKE;

    }
}

