/*
 * Decompiled with CFR 0.152.
 */
package statistics.simulators;

import fileIO.OutFile;
import java.util.ArrayList;
import java.util.Collections;
import statistics.simulators.DictionaryModel;
import statistics.simulators.Model;

public class MatrixProfileModelVersion2
extends Model {
    private int nosLocations = 2;
    private int shapeLength = 29;
    public static double MINBASE = -2.0;
    public static double MINAMP = 2.0;
    public static double MAXBASE = 2.0;
    public static double MAXAMP = 4.0;
    DictionaryModel.Shape shape;
    private static int GLOBALSERIESLENGTH = 500;
    private int seriesLength;
    private int base = -1;
    private int amplitude = 2;
    private int shapeCount = 0;
    private boolean invert = false;
    boolean discord = false;
    double[] shapeVals;
    ArrayList<Integer> locations;
    private static double[] spike1;
    private static double[] spike2;

    private static void makeSpikes() {
        int i;
        double min;
        spike1 = new double[29];
        spike2 = new double[29];
        double max = 3.0;
        MatrixProfileModelVersion2.spike1[0] = min = -2.0;
        MatrixProfileModelVersion2.spike1[28] = min;
        MatrixProfileModelVersion2.spike1[15] = max;
        for (i = 1; i <= 14; ++i) {
            MatrixProfileModelVersion2.spike1[i] = spike1[i - 1] + (max - min) / 5.0;
        }
        for (i = 0; i < 29; ++i) {
            MatrixProfileModelVersion2.spike2[i] = spike1[i] / 5.0;
        }
    }

    public static int getGlobalLength() {
        return GLOBALSERIESLENGTH;
    }

    public MatrixProfileModelVersion2() {
        this.seriesLength = GLOBALSERIESLENGTH;
        this.locations = new ArrayList();
        this.setNonOverlappingIntervals();
        this.shapeVals = new double[this.shapeLength];
        this.generateRandomShapeVals();
    }

    public MatrixProfileModelVersion2(boolean d) {
        this.discord = d;
        if (this.discord) {
            this.nosLocations = 1;
        }
        this.seriesLength = GLOBALSERIESLENGTH;
        this.locations = new ArrayList();
        this.setNonOverlappingIntervals();
        this.shapeVals = new double[this.shapeLength];
        this.generateRandomShapeVals();
    }

    private void generateRandomShapeVals() {
        for (int i = 0; i < this.shapeLength; ++i) {
            this.shapeVals[i] = MINBASE + (MAXBASE - MINBASE) * Model.rand.nextDouble();
        }
    }

    public void setSeriesLength(int n) {
        this.seriesLength = n;
    }

    public static void setGlobalSeriesLength(int n) {
        GLOBALSERIESLENGTH = n;
    }

    public void setNonOverlappingIntervals() {
        int i;
        ArrayList<Integer> startPoints = new ArrayList<Integer>();
        for (i = this.shapeLength + 1; i < this.seriesLength - this.shapeLength; ++i) {
            startPoints.add(i);
        }
        for (i = 0; i < this.nosLocations; ++i) {
            int pos = rand.nextInt(startPoints.size());
            int l = (Integer)startPoints.get(pos);
            this.locations.add(l);
            pos = pos < this.shapeLength / 2 ? 0 : (pos -= this.shapeLength / 2);
            for (int j = 0; startPoints.size() > pos && j < 2 * this.shapeLength; ++j) {
                startPoints.remove(pos);
            }
        }
        Collections.sort(this.locations);
    }

    @Override
    public void setParameters(double[] p) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setLocations(ArrayList<Integer> l, int length) {
        this.locations = new ArrayList<Integer>(l);
        this.shapeLength = length;
    }

    public ArrayList<Integer> getIntervals() {
        return this.locations;
    }

    public int getShapeLength() {
        return this.shapeLength;
    }

    public void generateBaseShape() {
        double b = MINBASE + (MAXBASE - MINBASE) * Model.rand.nextDouble();
        double a = MINAMP + (MAXAMP - MINAMP) * Model.rand.nextDouble();
        DictionaryModel.ShapeType[] all = DictionaryModel.ShapeType.values();
        DictionaryModel.ShapeType st = all[this.shapeCount++ % all.length];
        this.shape = new DictionaryModel.Shape(st, this.shapeLength, b, a);
    }

    @Override
    public double[] generateSeries(int n) {
        double[] d;
        this.t = 0.0;
        this.generateRandomShapeVals();
        if (this.invert) {
            d = new double[n];
            for (int i = 0; i < n; ++i) {
                d[i] = -this.generate();
            }
            this.invert = false;
        } else {
            this.generateBaseShape();
            d = new double[n];
            for (int i = 0; i < n; ++i) {
                d[i] = this.generate();
            }
            this.invert = true;
        }
        return d;
    }

    private double generateConfig1() {
        int point;
        int insertionPoint;
        double value = 0.0;
        for (insertionPoint = 0; insertionPoint < this.locations.size() && (double)(this.locations.get(insertionPoint) + this.shapeLength) < this.t; ++insertionPoint) {
        }
        if (insertionPoint >= this.locations.size()) {
            insertionPoint = this.locations.size() - 1;
        }
        value = (double)(point = this.locations.get(insertionPoint).intValue()) <= this.t && (double)(point + this.shapeLength) > this.t ? this.shapeVals[(int)(this.t - (double)point)] : this.error.simulate();
        this.t += 1.0;
        return value;
    }

    private double generateConfig2() {
        int insertionPoint;
        double value = this.error.simulate();
        for (insertionPoint = 0; insertionPoint < this.locations.size() && (double)(this.locations.get(insertionPoint) + this.shapeLength) < this.t; ++insertionPoint) {
        }
        if (insertionPoint >= this.locations.size()) {
            insertionPoint = this.locations.size() - 1;
        }
        int point = this.locations.get(insertionPoint);
        if (insertionPoint > 0 && (double)point == this.t) {
            double b = MINBASE + (MAXBASE - MINBASE) * Model.rand.nextDouble();
            double a = MINAMP + (MAXAMP - MINAMP) * Model.rand.nextDouble();
            this.shape.setAmp(a);
            this.shape.setBase(b);
        }
        if ((double)point <= this.t && (double)(point + this.shapeLength) > this.t) {
            value += this.shape.generateWithinShapelet((int)(this.t - (double)point));
        }
        this.t += 1.0;
        return value;
    }

    @Override
    public double generate() {
        return this.generateConfig1();
    }

    public static void generateExampleData() {
        int i;
        int length;
        GLOBALSERIESLENGTH = length = 500;
        Model.setGlobalRandomSeed(3);
        Model.setDefaultSigma(0.0);
        MatrixProfileModelVersion2 m1 = new MatrixProfileModelVersion2();
        MatrixProfileModelVersion2 m2 = new MatrixProfileModelVersion2();
        double[][] d = new double[20][];
        for (i = 0; i < 10; ++i) {
            d[i] = m1.generateSeries(length);
        }
        for (i = 10; i < 20; ++i) {
            d[i] = m1.generateSeries(length);
        }
        OutFile of = new OutFile("C:\\temp\\MP_ExampleSeries.csv");
        for (int i2 = 0; i2 < length; ++i2) {
            for (int j = 0; j < 10; ++j) {
                of.writeString(d[j][i2] + ",");
            }
            of.writeString("\n");
        }
    }

    public String toString() {
        String str = "";
        for (Integer i : this.locations) {
            str = str + i + ",";
        }
        return str;
    }

    public static void main(String[] args) {
        MatrixProfileModelVersion2.generateExampleData();
        System.exit(0);
        int length = 500;
        Model.setGlobalRandomSeed(10);
        Model.setDefaultSigma(0.1);
        MatrixProfileModelVersion2 m1 = new MatrixProfileModelVersion2();
        MatrixProfileModelVersion2 m2 = new MatrixProfileModelVersion2();
        double[] d1 = m1.generateSeries(length);
        double[] d2 = m2.generateSeries(length);
        OutFile of = new OutFile("C:\\temp\\MP_Ex.csv");
        for (int i = 0; i < length; ++i) {
            of.writeLine(d1[i] + "," + d2[i]);
        }
    }
}

