/*
 * Decompiled with CFR 0.152.
 */
package statistics.simulators;

import fileIO.OutFile;
import java.util.ArrayList;
import java.util.Collections;
import statistics.simulators.DictionaryModel;
import statistics.simulators.Model;

public class IntervalModel
extends Model {
    private int nosIntervals = 3;
    private int seriesLength = 300;
    private int noiseToSignal = 4;
    private int intervalLength = this.seriesLength / (this.nosIntervals * this.noiseToSignal);
    private int base = -1;
    private int amplitude = 2;
    private DictionaryModel.Shape baseShape = new DictionaryModel.Shape(this.intervalLength);
    ArrayList<Integer> locations = new ArrayList();

    public IntervalModel() {
    }

    public IntervalModel(int n) {
        this();
        this.nosIntervals = n;
        this.intervalLength = this.seriesLength / (this.nosIntervals * 2);
        this.baseShape.setLength(this.intervalLength);
        this.createIntervals();
    }

    public void setNoiseToSignal(int n) {
        this.noiseToSignal = n;
        this.intervalLength = this.seriesLength / (this.nosIntervals * this.noiseToSignal);
        this.baseShape.setLength(this.intervalLength);
    }

    public void setNosIntervals(int n) {
        this.nosIntervals = n;
        this.intervalLength = this.seriesLength / (this.nosIntervals * this.noiseToSignal);
        this.baseShape.setLength(this.intervalLength);
    }

    public void setSeriesLength(int n) {
        this.seriesLength = n;
        this.intervalLength = this.seriesLength / (this.nosIntervals * this.noiseToSignal);
        this.baseShape.setLength(this.intervalLength);
    }

    public void setBaseShapeType(DictionaryModel.ShapeType st) {
        this.baseShape.setType(st);
        this.baseShape.setLength(this.intervalLength);
    }

    public final void createIntervals() {
        this.locations = new ArrayList(this.nosIntervals);
        this.setNonOverlappingIntervals();
        this.baseShape.setLength(this.intervalLength);
    }

    public void setIntervals(ArrayList<Integer> l, int length) {
        this.locations = new ArrayList<Integer>(l);
        this.intervalLength = length;
        this.baseShape.setLength(this.intervalLength);
    }

    public ArrayList<Integer> getIntervals() {
        return this.locations;
    }

    public int getIntervalLength() {
        return this.intervalLength;
    }

    public boolean setNonOverlappingIntervals() {
        int i;
        for (i = 0; i < this.nosIntervals; ++i) {
            boolean ok = false;
            int l = this.intervalLength / 2;
            block1: while (!ok) {
                ok = true;
                l = rand.nextInt(this.seriesLength - this.intervalLength) + this.intervalLength / 2;
                for (int in : this.locations) {
                    if ((l < in - this.intervalLength || l >= in + this.intervalLength) && (l >= in - this.intervalLength || l + this.intervalLength <= in)) continue;
                    ok = false;
                    continue block1;
                }
            }
            this.locations.add(l);
        }
        for (i = 0; i < this.locations.size(); ++i) {
            int val = this.locations.get(i);
            this.locations.set(i, val - this.intervalLength / 2);
        }
        Collections.sort(this.locations);
        return true;
    }

    @Override
    public double generate() {
        int point;
        int insertionPoint;
        double value = this.error.simulate();
        for (insertionPoint = 0; insertionPoint < this.locations.size() && (double)(this.locations.get(insertionPoint) + this.intervalLength) < this.t; ++insertionPoint) {
        }
        if (insertionPoint >= this.locations.size()) {
            insertionPoint = this.locations.size() - 1;
        }
        if ((double)(point = this.locations.get(insertionPoint).intValue()) <= this.t && (double)(point + this.intervalLength) > this.t) {
            value += this.baseShape.generateWithinShapelet((int)(this.t - (double)point));
        }
        this.t += 1.0;
        return value;
    }

    @Override
    public void setParameters(double[] p) {
        this.nosIntervals = (int)p[0];
        this.intervalLength = (int)p[1];
    }

    public void randomiseShape(IntervalModel m) {
        this.baseShape.randomiseShape();
        if (m != null) {
            while (this.baseShape.equals(m.baseShape)) {
                this.baseShape.randomiseShape();
            }
        }
    }

    public static void main(String[] args) {
        int length = 500;
        Model.setGlobalRandomSeed(10);
        Model.setDefaultSigma(0.0);
        IntervalModel m1 = new IntervalModel();
        m1.setBaseShapeType(DictionaryModel.ShapeType.SINE);
        m1.setNosIntervals(3);
        m1.setSeriesLength(length);
        m1.createIntervals();
        IntervalModel m2 = new IntervalModel();
        m2.setBaseShapeType(DictionaryModel.ShapeType.SPIKE);
        m2.setNosIntervals(3);
        m2.setIntervals(m1.getIntervals(), m1.getIntervalLength());
        double[] d1 = m1.generateSeries(length);
        double[] d2 = m2.generateSeries(length);
        OutFile of = new OutFile("C:\\temp\\intervalEx.csv");
        for (int i = 0; i < length; ++i) {
            of.writeLine(d1[i] + "," + d2[i]);
        }
    }

    public String toString() {
        String s = "NosIntervals," + this.nosIntervals;
        s = s + "\nIntervalLength," + this.intervalLength;
        s = s + "\nNoiseToSignal," + this.noiseToSignal;
        s = s + "\nShape," + this.baseShape.toString() + " ,Locations,";
        for (int i = 0; i < this.nosIntervals; ++i) {
            s = s + this.locations.get(i) + " ";
        }
        return s;
    }
}

