/*
 * Decompiled with CFR 0.152.
 */
package statistics.simulators;

import fileIO.OutFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import statistics.simulators.Model;

public class DictionaryModel
extends Model {
    private static int DEFAULTNUMSHAPELETS = 5;
    private static int DEFAULTSERIESLENGTH = 1000;
    public static int DEFAULTSHAPELETLENGTH = 29;
    protected Shape shape1;
    protected Shape shape2;
    protected int numShape1 = DEFAULTNUMSHAPELETS;
    protected int[] shape1Locations = new int[this.numShape1];
    protected int numShape2 = DEFAULTNUMSHAPELETS;
    protected int[] shape2Locations = new int[this.numShape2];
    protected int totalNumShapes = this.numShape1 + this.numShape2;
    protected int seriesLength = DEFAULTSERIESLENGTH;
    protected int shapeletLength = DEFAULTSHAPELETLENGTH;

    public DictionaryModel() {
        this(new double[]{DEFAULTSERIESLENGTH, DEFAULTNUMSHAPELETS, DEFAULTNUMSHAPELETS, DEFAULTSHAPELETLENGTH});
    }

    public DictionaryModel(double[] param) {
        this.setDefaults();
        if (param != null) {
            switch (param.length) {
                default: {
                    this.shapeletLength = (int)param[3];
                }
                case 3: {
                    this.numShape2 = (int)param[2];
                }
                case 2: {
                    this.numShape1 = (int)param[1];
                }
                case 1: 
            }
            this.seriesLength = (int)param[0];
        }
        this.totalNumShapes = this.numShape1 + this.numShape2;
        this.shape1Locations = new int[this.numShape1];
        this.shape2Locations = new int[this.numShape2];
        this.shape1 = new Shape(this.shapeletLength);
        this.shape1.length = this.shapeletLength;
        this.shape1.randomiseShape();
        this.shape2 = new Shape(this.shapeletLength);
        this.shape2.randomiseShape();
        while (this.shape2.type == this.shape1.type) {
            this.shape2.randomiseShape();
        }
        while (!this.setNonOverlappingLocations()) {
            --this.totalNumShapes;
            if (this.numShape1 > this.numShape2) {
                --this.numShape1;
                continue;
            }
            --this.numShape2;
        }
    }

    public final void setDefaults() {
        this.seriesLength = DEFAULTSERIESLENGTH;
        this.numShape1 = DEFAULTNUMSHAPELETS;
        this.shapeletLength = DEFAULTSHAPELETLENGTH;
    }

    public ShapeType getShape1() {
        return this.shape1.type;
    }

    public ShapeType getShape2() {
        return this.shape2.type;
    }

    public void setShape1Type(ShapeType st) {
        this.shape1.setType(st);
        this.shape1.setLength(this.shapeletLength);
    }

    public void setShape2Type(ShapeType st) {
        this.shape2.setType(st);
        this.shape2.setLength(this.shapeletLength);
    }

    public void setNumShape1(int n) {
        this.numShape1 = n;
    }

    public void setNumShape2(int n) {
        this.numShape2 = n;
    }

    public final boolean setNonOverlappingLocations() {
        int i;
        if (this.seriesLength - this.shapeletLength * this.totalNumShapes < this.totalNumShapes) {
            return false;
        }
        ArrayList<Integer> locations = new ArrayList<Integer>();
        for (i = 0; i < this.totalNumShapes; ++i) {
            boolean ok = false;
            int l = this.shapeletLength / 2;
            block1: while (!ok) {
                ok = true;
                l = rand.nextInt(this.seriesLength - this.shapeletLength) + this.shapeletLength / 2;
                Iterator iterator = locations.iterator();
                while (iterator.hasNext()) {
                    int in = (Integer)iterator.next();
                    if ((l < in - this.shapeletLength || l >= in + this.shapeletLength) && (l >= in - this.shapeletLength || l + this.shapeletLength <= in)) continue;
                    ok = false;
                    continue block1;
                }
            }
            locations.add(l);
        }
        for (i = 0; i < locations.size(); ++i) {
            int val = (Integer)locations.get(i);
            locations.set(i, val - this.shapeletLength / 2);
        }
        this.shape1Locations = new int[this.numShape1];
        for (i = 0; i < this.numShape1; ++i) {
            this.shape1Locations[i] = (Integer)locations.get(i);
        }
        this.shape2Locations = new int[this.numShape2];
        for (i = 0; i < this.numShape2; ++i) {
            this.shape2Locations[i] = (Integer)locations.get(i + this.numShape1);
        }
        Arrays.sort(this.shape1Locations);
        Arrays.sort(this.shape2Locations);
        return true;
    }

    public final boolean setNonOverlappingLocationsOld() {
        int i;
        int i2;
        boolean s = false;
        int spaces = this.seriesLength - this.shapeletLength * this.totalNumShapes + 1;
        int nosIntervals = this.totalNumShapes + 1;
        ArrayList<Integer> intervals = new ArrayList<Integer>();
        int[] temp = new int[nosIntervals];
        for (i2 = 0; i2 < spaces; ++i2) {
            int n = new Random().nextInt(nosIntervals);
            temp[n] = temp[n] + 1;
        }
        for (i2 = 0; i2 < nosIntervals; ++i2) {
            intervals.add(temp[i2]);
        }
        ArrayList shapeLocations = new ArrayList(this.totalNumShapes);
        shapeLocations.add(intervals.get(0));
        int current = (Integer)shapeLocations.get(0) + this.shapeletLength;
        for (i = 1; i < this.totalNumShapes; ++i) {
            shapeLocations.add(current + (Integer)intervals.get(i));
            current = (Integer)shapeLocations.get(i) + this.shapeletLength;
        }
        Collections.shuffle(shapeLocations, rand);
        for (i = 0; i < this.numShape1; ++i) {
            this.shape1Locations[i] = (Integer)shapeLocations.get(i);
        }
        for (i = 0; i < this.numShape2; ++i) {
            this.shape2Locations[i] = (Integer)shapeLocations.get(i + this.numShape1);
        }
        Arrays.sort(this.shape1Locations);
        Arrays.sort(this.shape2Locations);
        return true;
    }

    @Override
    public double generate(double x) {
        int insertionPoint;
        int t = (int)x;
        double value = this.error.simulate();
        for (insertionPoint = 0; insertionPoint < this.shape1Locations.length && this.shape1Locations[insertionPoint] + this.shapeletLength < t; ++insertionPoint) {
        }
        if (insertionPoint >= this.shape1Locations.length) {
            insertionPoint = this.shape1Locations.length - 1;
        }
        if (this.shape1Locations[insertionPoint] <= t && this.shape1Locations[insertionPoint] + this.shapeletLength > t) {
            value += this.shape1.generateWithinShapelet(t - this.shape1Locations[insertionPoint]);
        } else {
            for (insertionPoint = 0; insertionPoint < this.shape2Locations.length && this.shape2Locations[insertionPoint] + this.shapeletLength < t; ++insertionPoint) {
            }
            if (insertionPoint >= this.shape2Locations.length) {
                insertionPoint = this.shape2Locations.length - 1;
            }
            if (this.shape2Locations[insertionPoint] <= t && this.shape2Locations[insertionPoint] + this.shapeletLength > t) {
                value += this.shape2.generateWithinShapelet(t - this.shape2Locations[insertionPoint]);
            }
        }
        return value;
    }

    @Override
    public double generate() {
        double value = this.generate(this.t);
        this.t += 1.0;
        return value;
    }

    @Override
    public double[] generateSeries(int n) {
        this.t = 0.0;
        this.setNonOverlappingLocations();
        double[] d = new double[n];
        for (int i = 0; i < n; ++i) {
            d[i] = this.generate();
        }
        return d;
    }

    @Override
    public void setParameters(double[] param) {
        if (param != null) {
            switch (param.length) {
                default: {
                    this.shapeletLength = (int)param[3];
                }
                case 3: {
                    this.numShape2 = (int)param[2];
                }
                case 2: {
                    this.numShape1 = (int)param[1];
                }
                case 1: 
            }
            this.seriesLength = (int)param[0];
        }
    }

    @Override
    public String getModelType() {
        return "DictionarySimulator";
    }

    @Override
    public String getAttributeName() {
        return "Dict";
    }

    @Override
    public String getHeader() {
        String header = super.getHeader();
        header = header + "%  \t Shapelet Length =" + this.shapeletLength;
        header = header + "\n%  \t Series Length =" + this.seriesLength;
        header = header + "\n%  \t Number of Shapelets =" + this.numShape1;
        header = header + "\n% \t Shape = " + (Object)((Object)this.shape1.type);
        return header;
    }

    public static void testRandSeed() {
        Model.setDefaultSigma(0.1);
        Model.setGlobalRandomSeed(0);
        DEFAULTSHAPELETLENGTH = 29;
        DEFAULTSERIESLENGTH = 100;
        double[][] d = new double[ShapeType.values().length][DEFAULTSERIESLENGTH];
        int j = 0;
        for (ShapeType s : ShapeType.values()) {
            DictionaryModel shape = new DictionaryModel(new double[]{DEFAULTSERIESLENGTH, 1.0, 1.0, DEFAULTSHAPELETLENGTH});
            shape.setShape1Type(s);
            shape.setShape2Type(s);
            System.out.println(" SHAPE =" + (Object)((Object)s));
            for (int i = 0; i < DEFAULTSERIESLENGTH; ++i) {
                d[j][i] = shape.generate(i);
            }
            ++j;
        }
        OutFile out = new OutFile("C:\\temp\\dictNoNoiseRep1.csv");
        for (int i = 0; i < DEFAULTSERIESLENGTH; ++i) {
            for (j = 0; j < d.length; ++j) {
                out.writeString(d[j][i] + ",");
            }
            out.writeString("\n");
        }
    }

    public static void testRandomisedPlacement() {
        Model.setDefaultSigma(0.1);
        Model.setGlobalRandomSeed(0);
        DEFAULTSHAPELETLENGTH = 29;
        DEFAULTSERIESLENGTH = 100;
        OutFile of = new OutFile("C:\\temp\\locationsDict.csv");
        of.writeString(",Shape1,,Shape2");
        for (int i = 0; i < 10000; ++i) {
            int j;
            DictionaryModel shape = new DictionaryModel(new double[]{DEFAULTSERIESLENGTH, 1.0, 1.0, DEFAULTSHAPELETLENGTH});
            shape.setNonOverlappingLocations();
            for (j = 0; j < shape.numShape1; ++j) {
                of.writeString("," + shape.shape1Locations[j]);
            }
            of.writeString(",");
            for (j = 0; j < shape.numShape2; ++j) {
                of.writeString("," + shape.shape2Locations[j]);
            }
            of.writeString("\n");
        }
    }

    public static void main(String[] args) throws IOException {
        Model.setDefaultSigma(0.0);
        Model.setGlobalRandomSeed(0);
        int sLength = 30;
        int length = 100;
        Shape s = new Shape(sLength);
        boolean c = false;
        double[][] data = new double[10][];
        for (sLength = 10; sLength <= 10; sLength += 4) {
            OutFile of = new OutFile("C:\\temp\\headShoulders" + sLength + ".csv");
            System.out.println("SLength = " + sLength + " Length =" + length);
            DictionaryModel shape = new DictionaryModel(new double[]{length, 2.0, 1.0, sLength});
            Model.setGlobalRandomSeed(4);
            for (int i = 0; i < data.length; ++i) {
                Model.setGlobalRandomSeed(i);
                data[i] = shape.generateSeries(length);
            }
            for (int j = 0; j < length; ++j) {
                for (int i = 0; i < data.length; ++i) {
                    of.writeString(data[i][j] + ",");
                }
                of.writeString("\n");
            }
        }
    }

    public static class Shape {
        public ShapeType type;
        public int length;
        private double base;
        private double amp;
        public static double DEFAULTBASE = -2.0;
        public static double DEFAULTAMP = 4.0;

        public void setBase(double b) {
            this.base = b;
        }

        public void setAmp(double a) {
            this.amp = a;
        }

        public double getBase() {
            return this.base;
        }

        public double getAmp() {
            return this.amp;
        }

        public Shape() {
            this(ShapeType.HEADSHOULDERS, DEFAULTSHAPELETLENGTH, DEFAULTBASE, DEFAULTAMP);
            if (this.type == ShapeType.HEADSHOULDERS) {
                this.base /= 2.0;
            }
        }

        public Shape(int length) {
            this(ShapeType.HEADSHOULDERS, length, DEFAULTBASE, DEFAULTAMP);
            if (this.type == ShapeType.HEADSHOULDERS) {
                this.base /= 2.0;
            }
        }

        public Shape(int l, double b, double a) {
            this.randomiseShape();
            this.length = l;
            this.base = b;
            this.amp = a;
        }

        public Shape(ShapeType t, int l, double b, double a) {
            this.type = t;
            this.length = l;
            this.base = b;
            this.amp = a;
            if (this.type == ShapeType.HEADSHOULDERS) {
                this.base /= 2.0;
            }
        }

        public void setLength(int newLength) {
            this.length = newLength;
        }

        public double generateWithinShapelet(int offset) {
            double value = 0.0;
            int lower = 0;
            int mid = 0;
            int upper = 0;
            switch (this.type) {
                case TRIANGLE: {
                    mid = this.length / 2;
                    if (offset <= mid) {
                        if (offset == 0) {
                            value = this.base;
                            break;
                        }
                        value = (double)offset / (double)mid * this.amp + this.base;
                        break;
                    }
                    if (offset >= this.length) {
                        value = this.base;
                        break;
                    }
                    if (this.length % 2 == 1) {
                        value = (double)(this.length - offset - 1) / (double)mid * this.amp + this.base;
                        break;
                    }
                    value = (double)(this.length - offset) / (double)mid * this.amp + this.base;
                    break;
                }
                case HEADSHOULDERS: {
                    lower = this.length / 3;
                    upper = 2 * lower;
                    if (this.length % 3 == 2) {
                        upper += 2;
                    }
                    if (!((value = offset < lower ? this.amp / 2.0 * Math.sin(Math.PI * 2 / (double)((this.length / 3 - 1) * 2) * (double)offset) + this.base : (offset >= upper ? this.amp / 2.0 * Math.sin(Math.PI * 2 / (double)((this.length / 3 - 1) * 2) * (double)(offset - upper)) + this.base : this.amp * Math.sin(Math.PI * 2 / (double)((upper - lower - 1) * 2) * (double)(offset - this.length / 3)) + this.base)) < this.base)) break;
                    value = this.base;
                    break;
                }
                case SINE: {
                    value = this.amp * Math.sin(Math.PI * 2 / (double)(this.length - 1) * (double)offset) / 2.0;
                    break;
                }
                case STEP: {
                    if (offset < this.length / 2) {
                        value = this.base;
                        break;
                    }
                    value = this.base + this.amp;
                    break;
                }
                case SPIKE: {
                    lower = this.length / 4;
                    upper = 3 * lower;
                    if (offset <= lower) {
                        if (offset == 0) {
                            value = 0.0;
                            break;
                        }
                        value = -this.amp / 2.0 * ((double)offset / (double)lower);
                        break;
                    }
                    value = offset > lower && offset < upper ? -this.amp / 2.0 + this.amp * ((double)(offset - lower) / (double)(upper - lower - 1)) : this.amp / 2.0 - this.amp / 2.0 * ((double)(offset - upper + 1) / (double)(this.length - upper));
                }
            }
            return value;
        }

        public void setType(ShapeType newType) {
            this.type = newType;
            this.base = newType == ShapeType.HEADSHOULDERS ? DEFAULTBASE / 2.0 : DEFAULTBASE;
        }

        public String toString() {
            String shp = "" + (Object)((Object)this.type) + ",length," + this.length + ",this.base," + this.base + ",amp," + this.amp;
            return shp;
        }

        public void randomiseShape() {
            ShapeType[] types = ShapeType.values();
            int ranType = Model.rand.nextInt(types.length);
            this.setType(types[ranType]);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Shape)) {
                return false;
            }
            return this.type == ((Shape)o).type;
        }
    }

    public static enum ShapeType {
        TRIANGLE,
        HEADSHOULDERS,
        SINE,
        STEP,
        SPIKE;

    }
}

