/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Distribution;

public class WeibullDistribution
extends Distribution {
    double shape;
    double scale;
    double c;

    public WeibullDistribution(double k, double b) {
        this.setParameters(k, b);
    }

    public WeibullDistribution() {
        this(1.0, 1.0);
    }

    public void setParameters(double k, double b) {
        if (k <= 0.0) {
            k = 1.0;
        }
        if (b <= 0.0) {
            b = 1.0;
        }
        this.shape = k;
        this.scale = b;
        this.c = this.shape / Math.pow(this.scale, this.shape);
        double upper = Math.ceil(this.getMean() + 4.0 * this.getSD());
        double width = upper / 100.0;
        super.setParameters(0.0, upper, width, 1);
    }

    @Override
    public double getDensity(double x) {
        return this.c * Math.pow(x, this.shape - 1.0) * Math.exp(-Math.pow(x / this.scale, this.shape));
    }

    @Override
    public double getMaxDensity() {
        double mode = this.shape < 1.0 ? this.getDomain().getLowerValue() : this.scale * Math.pow((this.shape - 1.0) / this.shape, 1.0 / this.shape);
        return this.getDensity(mode);
    }

    @Override
    public double getMean() {
        return this.scale * WeibullDistribution.gamma(1.0 + 1.0 / this.shape);
    }

    @Override
    public double getVariance() {
        double mu = this.getMean();
        return this.scale * this.scale * WeibullDistribution.gamma(1.0 + 2.0 / this.shape) - mu * mu;
    }

    @Override
    public double getCDF(double x) {
        return 1.0 - Math.exp(-Math.pow(x / this.scale, this.shape));
    }

    @Override
    public double getQuantile(double p) {
        return this.scale * Math.pow(-Math.log(1.0 - p), 1.0 / this.shape);
    }

    @Override
    public double getFailureRate(double x) {
        return this.shape * Math.pow(x, this.shape - 1.0) / Math.pow(this.scale, this.shape);
    }

    public double getShape() {
        return this.shape;
    }

    public void setShape(double k) {
        this.setParameters(k, this.scale);
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double b) {
        this.setParameters(this.shape, b);
    }
}

