/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Distribution;

public class WalkPositionDistribution
extends Distribution {
    private int steps;
    private double probability;

    public WalkPositionDistribution(int n, double p) {
        this.setParameters(n, p);
    }

    public WalkPositionDistribution() {
        this(10, 0.5);
    }

    public void setParameters(int n, double p) {
        if (n < 0) {
            n = 0;
        }
        if (p < 0.0) {
            p = 0.0;
        } else if (p > 1.0) {
            p = 1.0;
        }
        this.steps = n;
        this.probability = p;
        super.setParameters(-this.steps, this.steps, 2.0, 0);
    }

    @Override
    public double getDensity(double x) {
        int k = (int)Math.rint(x);
        int m = (k + this.steps) / 2;
        return WalkPositionDistribution.comb(this.steps, m) * Math.pow(this.probability, m) * Math.pow(1.0 - this.probability, this.steps - m);
    }

    @Override
    public double getMaxDensity() {
        double mode = 2.0 * Math.min(Math.floor((double)(this.steps + 1) * this.probability), (double)this.steps) - (double)this.steps;
        return this.getDensity(mode);
    }

    @Override
    public double getMean() {
        return (double)(2 * this.steps) * this.probability - (double)this.steps;
    }

    @Override
    public double getVariance() {
        return (double)(4 * this.steps) * this.probability * (1.0 - this.probability);
    }

    public double getSteps() {
        return this.steps;
    }

    public double getProbability() {
        return this.probability;
    }

    @Override
    public double simulate() {
        int position = 0;
        for (int i = 1; i <= this.steps; ++i) {
            int step = Math.random() < this.probability ? 1 : -1;
            position += step;
        }
        return position;
    }
}

