/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Distribution;

public class LogisticDistribution
extends Distribution {
    public LogisticDistribution() {
        super.setParameters(-7.0, 7.0, 0.14, 1);
    }

    @Override
    public double getDensity(double x) {
        double e = Math.exp(x);
        return e / ((1.0 + e) * (1.0 + e));
    }

    @Override
    public double getMaxDensity() {
        return 0.25;
    }

    @Override
    public double getCDF(double x) {
        double e = Math.exp(x);
        return e / (1.0 + e);
    }

    @Override
    public double getQuantile(double p) {
        return Math.log(p / (1.0 - p));
    }

    @Override
    public double getMean() {
        return 0.0;
    }

    @Override
    public double getVariance() {
        return 3.289868133696453;
    }
}

