/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Distribution;

public class FisherDistribution
extends Distribution {
    private int nDegrees;
    private int dDegrees;
    private double c;

    public FisherDistribution(int n, int d) {
        this.setParameters(n, d);
    }

    public FisherDistribution() {
        this(5, 5);
    }

    public void setParameters(int n, int d) {
        if (n < 1) {
            n = 1;
        }
        if (d < 1) {
            d = 1;
        }
        this.nDegrees = n;
        this.dDegrees = d;
        this.c = FisherDistribution.logGamma(0.5 * (double)(this.nDegrees + this.dDegrees)) - FisherDistribution.logGamma(0.5 * (double)this.nDegrees) - FisherDistribution.logGamma(0.5 * (double)this.dDegrees) + 0.5 * (double)this.nDegrees * (Math.log(this.nDegrees) - Math.log(this.dDegrees));
        double upper = this.dDegrees <= 4 ? 20.0 : this.getMean() + 4.0 * this.getSD();
        double width = 0.01 * upper;
        super.setParameters(0.0, upper, width, 1);
    }

    @Override
    public double getDensity(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        if (x == 0.0 & this.nDegrees == 1) {
            return Double.POSITIVE_INFINITY;
        }
        return Math.exp(this.c + (0.5 * (double)this.nDegrees - 1.0) * Math.log(x) - 0.5 * (double)(this.nDegrees + this.dDegrees) * Math.log(1.0 + (double)this.nDegrees * x / (double)this.dDegrees));
    }

    @Override
    public double getMaxDensity() {
        double mode = this.nDegrees == 1 ? this.getDomain().getLowerValue() : (double)((this.nDegrees - 2) * this.dDegrees) / (double)(this.nDegrees * (this.dDegrees + 2));
        return this.getDensity(mode);
    }

    @Override
    public double getMean() {
        if (this.dDegrees <= 2) {
            return Double.POSITIVE_INFINITY;
        }
        return (double)this.dDegrees / (double)(this.dDegrees - 2);
    }

    @Override
    public double getVariance() {
        if (this.dDegrees <= 2) {
            return Double.NaN;
        }
        if (this.dDegrees <= 4) {
            return Double.POSITIVE_INFINITY;
        }
        return 2.0 * (double)(this.dDegrees / (this.dDegrees - 2)) * (double)(this.dDegrees / (this.dDegrees - 2)) * (double)(this.dDegrees + this.nDegrees - 2) / (double)(this.nDegrees * (this.dDegrees - 4));
    }

    @Override
    public double getCDF(double x) {
        double u = (double)this.dDegrees / ((double)this.dDegrees + (double)this.nDegrees * x);
        if (x < 0.0) {
            return 0.0;
        }
        return 1.0 - FisherDistribution.betaCDF(u, 0.5 * (double)this.dDegrees, 0.5 * (double)this.nDegrees);
    }

    public double getNDegrees() {
        return this.nDegrees;
    }

    public void setNDegrees(int n) {
        this.setParameters(n, this.dDegrees);
    }

    public double getDDegrees() {
        return this.dDegrees;
    }

    public void setDDegrees(int d) {
        this.setParameters(this.nDegrees, d);
    }

    @Override
    public double simulate() {
        double Z;
        double theta;
        double r;
        double U = 0.0;
        for (int i = 1; i <= this.dDegrees; ++i) {
            r = Math.sqrt(-2.0 * Math.log(Math.random()));
            theta = Math.PI * 2 * Math.random();
            Z = r * Math.cos(theta);
            U += Z * Z;
        }
        double V = 0.0;
        for (int j = 1; j <= this.dDegrees; ++j) {
            r = Math.sqrt(-2.0 * Math.log(Math.random()));
            theta = Math.PI * 2 * Math.random();
            Z = r * Math.cos(theta);
            V += Z * Z;
        }
        return U / (double)this.nDegrees / (V / (double)this.dDegrees);
    }
}

