/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import java.util.Random;
import statistics.distributions.Domain;

public abstract class Distribution {
    public static final int DISCRETE = 0;
    public static final int CONTINUOUS = 1;
    public static final int MIXED = 2;
    private int type;
    private Domain domain;
    public static Random RNG = new Random();

    public static void setDistributionSeed(int r) {
        RNG.setSeed(r);
    }

    public void setRandomSeed(int r) {
        RNG.setSeed(r);
    }

    public abstract double getDensity(double var1);

    public void setParameters(double a, double b, double w, int t) {
        if (t < 0) {
            t = 0;
        } else if (t > 2) {
            t = 2;
        }
        this.type = t;
        this.domain = this.type == 0 ? new Domain(a - 0.5 * w, b + 0.5 * w, w) : new Domain(a, b, w);
    }

    public Domain getDomain() {
        return this.domain;
    }

    public final int getType() {
        return this.type;
    }

    public double getMaxDensity() {
        double max = 0.0;
        for (int i = 0; i < this.domain.getSize(); ++i) {
            double d = this.getDensity(this.domain.getValue(i));
            if (!(d > max & d < Double.POSITIVE_INFINITY)) continue;
            max = d;
        }
        return max;
    }

    public double getMean() {
        double sum = 0.0;
        double w = this.type == 0 ? 1.0 : this.domain.getWidth();
        for (int i = 0; i < this.domain.getSize(); ++i) {
            double x = this.domain.getValue(i);
            sum += x * this.getDensity(x) * w;
        }
        return sum;
    }

    public double getVariance() {
        double sum = 0.0;
        double mu = this.getMean();
        double w = this.type == 0 ? 1.0 : this.domain.getWidth();
        for (int i = 0; i < this.domain.getSize(); ++i) {
            double x = this.domain.getValue(i);
            sum += (x - mu) * (x - mu) * this.getDensity(x) * w;
        }
        return sum;
    }

    public double getSD() {
        return Math.sqrt(this.getVariance());
    }

    public double getCDF(double x) {
        double sum = 0.0;
        double w = this.type == 0 ? 1.0 : this.domain.getWidth();
        int j = this.domain.getIndex(x);
        if (j < 0) {
            return 0.0;
        }
        if (j >= this.domain.getSize()) {
            return 1.0;
        }
        for (int i = 0; i <= j; ++i) {
            sum += this.getDensity(this.domain.getValue(i)) * w;
        }
        if (this.type == 1) {
            double y = this.domain.getValue(j) - 0.5 * w;
            sum += this.getDensity((x + y) / 2.0) * (x - y);
        }
        return sum;
    }

    public double getQuantile(double p) {
        double sum = 0.0;
        double w = this.type == 0 ? 1.0 : this.domain.getWidth();
        if (p <= 0.0) {
            return this.domain.getLowerValue();
        }
        if (p >= 1.0) {
            return this.domain.getUpperValue();
        }
        int n = this.domain.getSize();
        int i = 0;
        double x = this.domain.getValue(i);
        sum = this.getDensity(x) * w;
        while (sum < p & i < n) {
            x = this.domain.getValue(++i);
            sum += this.getDensity(x) * w;
        }
        return x;
    }

    public double simulate() {
        return this.getQuantile(RNG.nextDouble());
    }

    public double getMedian() {
        return this.getQuantile(0.5);
    }

    public double getFailureRate(double x) {
        return this.getDensity(x) / (1.0 - this.getCDF(x));
    }

    public static double perm(double n, int k) {
        if ((double)k > n | k < 0) {
            return 0.0;
        }
        double prod = 1.0;
        for (int i = 1; i <= k; ++i) {
            prod *= n - (double)i + 1.0;
        }
        return prod;
    }

    public static double factorial(int k) {
        return Distribution.perm(k, k);
    }

    public static double comb(double n, int k) {
        return Distribution.perm(n, k) / Distribution.factorial(k);
    }

    public static double logGamma(double x) {
        double[] coef = new double[]{76.18009173, -86.50532033, 24.01409822, -1.231739516, 0.00120858003, -5.36382E-6};
        double step = 2.50662827465;
        double fpf = 5.5;
        double t = x - 1.0;
        double tmp = t + fpf;
        tmp = (t + 0.5) * Math.log(tmp) - tmp;
        double ser = 1.0;
        for (int i = 1; i <= 6; ++i) {
            ser += coef[i - 1] / (t += 1.0);
        }
        return tmp + Math.log(step * ser);
    }

    public static double gamma(double x) {
        return Math.exp(Distribution.logGamma(x));
    }

    public static double gammaCDF(double x, double a) {
        if (x <= 0.0) {
            return 0.0;
        }
        if (x < a + 1.0) {
            return Distribution.gammaSeries(x, a);
        }
        return 1.0 - Distribution.gammaCF(x, a);
    }

    private static double gammaSeries(double x, double a) {
        int maxit = 100;
        double eps = 3.0E-7;
        double sum = 1.0 / a;
        double ap = a;
        double gln = Distribution.logGamma(a);
        double del = sum;
        for (int n = 1; n <= maxit; ++n) {
            del = del * x / (ap += 1.0);
            if (Math.abs(del) < Math.abs(sum += del) * eps) break;
        }
        return sum * Math.exp(-x + a * Math.log(x) - gln);
    }

    private static double gammaCF(double x, double a) {
        int maxit = 100;
        double eps = 3.0E-7;
        double gln = Distribution.logGamma(a);
        double g = 0.0;
        double gOld = 0.0;
        double a0 = 1.0;
        double a1 = x;
        double b0 = 0.0;
        double b1 = 1.0;
        double fac = 1.0;
        for (int n = 1; n <= maxit; ++n) {
            double an = 1.0 * (double)n;
            double ana = an - a;
            a0 = (a1 + a0 * ana) * fac;
            b0 = (b1 + b0 * ana) * fac;
            double anf = an * fac;
            a1 = x * a0 + anf * a1;
            b1 = x * b0 + anf * b1;
            if (a1 == 0.0) continue;
            fac = 1.0 / a1;
            g = b1 * fac;
            if (Math.abs((g - gOld) / g) < eps) break;
            gOld = g;
        }
        return Math.exp(-x + a * Math.log(x) - gln) * g;
    }

    public static double betaCDF(double x, double a, double b) {
        double bt = x == 0.0 | x == 1.0 ? 0.0 : Math.exp(Distribution.logGamma(a + b) - Distribution.logGamma(a) - Distribution.logGamma(b) + a * Math.log(x) + b * Math.log(1.0 - x));
        if (x < (a + 1.0) / (a + b + 2.0)) {
            return bt * Distribution.betaCF(x, a, b) / a;
        }
        return 1.0 - bt * Distribution.betaCF(1.0 - x, b, a) / b;
    }

    private static double betaCF(double x, double a, double b) {
        int maxit = 100;
        double eps = 3.0E-7;
        double am = 1.0;
        double bm = 1.0;
        double az = 1.0;
        double qab = a + b;
        double qap = a + 1.0;
        double qam = a - 1.0;
        double bz = 1.0 - qab * x / qap;
        for (int m = 1; m <= maxit; ++m) {
            double em = m;
            double tem = em + em;
            double d = em * (b - (double)m) * x / ((qam + tem) * (a + tem));
            double ap = az + d * am;
            double bp = bz + d * bm;
            d = -(a + em) * (qab + em) * x / ((a + tem) * (qap + tem));
            double app = ap + d * az;
            double bpp = bp + d * bz;
            double aOld = az;
            am = ap / bpp;
            bm = bp / bpp;
            az = app / bpp;
            bz = 1.0;
            if (Math.abs(az - aOld) < eps * Math.abs(az)) break;
        }
        return az;
    }
}

