/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Distribution;

public class DiscreteUniformDistribution
extends Distribution {
    double values;

    public DiscreteUniformDistribution(double a, double b, double w) {
        this.setParameters(a, b, w);
    }

    public DiscreteUniformDistribution() {
        this(1.0, 6.0, 1.0);
    }

    public void setParameters(double a, double b, double w) {
        super.setParameters(a, b, w, 0);
    }

    @Override
    public double getDensity(double x) {
        if (this.getDomain().getLowerValue() <= x & x <= this.getDomain().getUpperValue()) {
            return 1.0 / (double)this.getDomain().getSize();
        }
        return 0.0;
    }

    @Override
    public double getMaxDensity() {
        return 1.0 / (double)this.getDomain().getSize();
    }

    @Override
    public double simulate() {
        return this.getDomain().getLowerValue() + Math.random() * (double)this.getDomain().getSize() * this.getDomain().getWidth();
    }
}

