/*
 * Decompiled with CFR 0.152.
 */
package multivariate_timeseriesweka.classifiers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import utilities.MultivariateInstanceTools;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.RandomizableIteratedSingleClassifierEnhancer;
import weka.core.Instance;
import weka.core.Instances;

public class ConcatenateClassifier
extends AbstractClassifier {
    Classifier original_model;
    Instances concat_train;
    Instances concat_test;
    long seed;

    public ConcatenateClassifier(Classifier cla) {
        this.original_model = cla;
    }

    public void setSeed(long sd) {
        this.seed = sd;
        if (this.original_model instanceof RandomizableIteratedSingleClassifierEnhancer) {
            RandomizableIteratedSingleClassifierEnhancer r = (RandomizableIteratedSingleClassifierEnhancer)this.original_model;
            r.setSeed((int)this.seed);
        } else {
            Method[] methods;
            for (Method method : methods = this.original_model.getClass().getMethods()) {
                Class<?>[] paras = method.getParameterTypes();
                String name = method.getName().toLowerCase();
                if (!name.contains("random") && !name.contains("seed") || paras.length != 1 || paras[0] != Integer.TYPE && paras[0] != Long.TYPE) continue;
                try {
                    if (paras[0] == Integer.TYPE) {
                        method.invoke((Object)this.original_model, (int)this.seed);
                        continue;
                    }
                    method.invoke((Object)this.original_model, this.seed);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    System.out.println(ex);
                    System.out.println("Tried to set the seed method name: " + method.getName());
                }
            }
        }
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.concat_train = MultivariateInstanceTools.concatinateInstances(MultivariateInstanceTools.splitMultivariateInstances(data));
        this.original_model.buildClassifier(this.concat_train);
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.concat_test == null) {
            this.concat_test = MultivariateInstanceTools.concatinateInstances(MultivariateInstanceTools.splitMultivariateInstances(instance.dataset()));
        }
        double[] dist = this.original_model.distributionForInstance(this.concat_test.get(instance.dataset().indexOf(instance)));
        return dist;
    }
}

