/*
 * Decompiled with CFR 0.152.
 */
package multivariate_timeseriesweka;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import timeseriesweka.filters.shapelet_transforms.ShapeletTransformFactoryOptions;
import timeseriesweka.filters.shapelet_transforms.ShapeletTransformTimingUtilities;
import timeseriesweka.filters.shapelet_transforms.distance_functions.SubSeqDistance;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearchOptions;
import utilities.MultivariateInstanceTools;
import utilities.TriFunction;
import weka.core.Instances;

public class DefaultShapeletOptions {
    public static final Map<String, Function<Instances, ShapeletTransformFactoryOptions>> FACTORY_OPTIONS;
    public static final Map<String, TriFunction<Instances, Long, Long, ShapeletTransformFactoryOptions>> TIMED_FACTORY_OPTIONS;

    public static ShapeletTransformFactoryOptions createIndependentShapeletSearch_TIMED(Instances train, long time, long seed) {
        int n = train.numInstances();
        int m = MultivariateInstanceTools.channelLength(train);
        ShapeletSearchOptions.Builder searchBuilder = new ShapeletSearchOptions.Builder();
        searchBuilder.setMin(3);
        searchBuilder.setMax(m);
        searchBuilder.setSearchType(ShapeletSearch.SearchType.FULL);
        searchBuilder.setNumDimensions(MultivariateInstanceTools.numChannels(train));
        int K = n > 2000 ? 2000 : n;
        BigInteger opCountTarget = new BigInteger(Long.toString(time / 10L));
        BigInteger opCount = ShapeletTransformTimingUtilities.calculateOps(n, m, 1, 1);
        if (opCount.compareTo(opCountTarget) == 1) {
            System.out.println("initiate timed");
            BigDecimal oct = new BigDecimal(opCountTarget);
            BigDecimal oc = new BigDecimal(opCount);
            BigDecimal prop = oct.divide(oc, MathContext.DECIMAL64);
            long numShapelets = ShapeletTransformTimingUtilities.calculateNumberOfShapelets(n, m, 3, m);
            numShapelets = (long)((double)numShapelets * prop.doubleValue());
            searchBuilder.setSeed(seed);
            searchBuilder.setSearchType(ShapeletSearch.SearchType.IMP_RANDOM);
            searchBuilder.setNumShapelets(numShapelets);
            K = numShapelets > (long)K ? K : (int)numShapelets;
        }
        ShapeletTransformFactoryOptions options = new ShapeletTransformFactoryOptions.Builder().setKShapelets(K).setSearchOptions(searchBuilder.build()).setDistanceType(SubSeqDistance.DistanceType.DIMENSION).useBinaryClassValue().useClassBalancing().useCandidatePruning().build();
        return options;
    }

    public static ShapeletTransformFactoryOptions createSHAPELET_I_TIMED(Instances train, long time, long seed) {
        int n = train.numInstances();
        int m = MultivariateInstanceTools.channelLength(train);
        ShapeletSearchOptions.Builder searchBuilder = new ShapeletSearchOptions.Builder();
        searchBuilder.setMin(3);
        searchBuilder.setMax(m);
        int K = n > 2000 ? 2000 : n;
        BigInteger opCountTarget = new BigInteger(Long.toString(time / 10L));
        BigInteger opCount = ShapeletTransformTimingUtilities.calculateOps(n, m, 1, 1);
        opCount = opCount.multiply(BigInteger.valueOf(MultivariateInstanceTools.numChannels(train)));
        if (opCount.compareTo(opCountTarget) == 1) {
            BigDecimal oct = new BigDecimal(opCountTarget);
            BigDecimal oc = new BigDecimal(opCount);
            BigDecimal prop = oct.divide(oc, MathContext.DECIMAL64);
            long numShapelets = ShapeletTransformTimingUtilities.calculateNumberOfShapelets(n, m, 3, m);
            numShapelets = (long)((double)numShapelets * prop.doubleValue());
            searchBuilder.setSeed(seed);
            searchBuilder.setSearchType(ShapeletSearch.SearchType.IMP_RANDOM);
            searchBuilder.setNumShapelets(numShapelets);
            K = numShapelets > (long)K ? K : (int)numShapelets;
        }
        ShapeletTransformFactoryOptions options = new ShapeletTransformFactoryOptions.Builder().setKShapelets(K).setSearchOptions(searchBuilder.build()).setDistanceType(SubSeqDistance.DistanceType.INDEPENDENT).useBinaryClassValue().useClassBalancing().useCandidatePruning().build();
        return options;
    }

    public static ShapeletTransformFactoryOptions createSHAPELET_D_TIMED(Instances train, long time, long seed) {
        int n = train.numInstances();
        int m = MultivariateInstanceTools.channelLength(train);
        ShapeletSearchOptions.Builder searchBuilder = new ShapeletSearchOptions.Builder();
        searchBuilder.setMin(3);
        searchBuilder.setMax(m);
        int K = n > 2000 ? 2000 : n;
        BigInteger opCountTarget = new BigInteger(Long.toString(time / 10L));
        BigInteger opCount = ShapeletTransformTimingUtilities.calculateOps(n, m, 1, 1);
        opCount = opCount.multiply(BigInteger.valueOf(MultivariateInstanceTools.numChannels(train)));
        if (opCount.compareTo(opCountTarget) == 1) {
            BigDecimal oct = new BigDecimal(opCountTarget);
            BigDecimal oc = new BigDecimal(opCount);
            BigDecimal prop = oct.divide(oc, MathContext.DECIMAL64);
            long numShapelets = ShapeletTransformTimingUtilities.calculateNumberOfShapelets(n, m, 3, m);
            numShapelets = (long)((double)numShapelets * prop.doubleValue());
            searchBuilder.setSeed(seed);
            searchBuilder.setSearchType(ShapeletSearch.SearchType.IMP_RANDOM);
            searchBuilder.setNumShapelets(numShapelets);
            K = numShapelets > (long)K ? K : (int)numShapelets;
        }
        ShapeletTransformFactoryOptions options = new ShapeletTransformFactoryOptions.Builder().setKShapelets(K).setSearchOptions(searchBuilder.build()).setDistanceType(SubSeqDistance.DistanceType.DEPENDENT).useBinaryClassValue().useClassBalancing().useCandidatePruning().build();
        return options;
    }

    public static ShapeletTransformFactoryOptions createIndependentShapeletSearch(Instances train) {
        ShapeletSearchOptions sOps = new ShapeletSearchOptions.Builder().setMin(3).setMax(MultivariateInstanceTools.channelLength(train)).setSearchType(ShapeletSearch.SearchType.FULL).setNumDimensions(MultivariateInstanceTools.numChannels(train)).build();
        ShapeletTransformFactoryOptions options = new ShapeletTransformFactoryOptions.Builder().setSearchOptions(sOps).setDistanceType(SubSeqDistance.DistanceType.DIMENSION).setKShapelets(train.numInstances()).useBinaryClassValue().useClassBalancing().useCandidatePruning().build();
        return options;
    }

    public static ShapeletTransformFactoryOptions createSHAPELET_I(Instances train) {
        ShapeletTransformFactoryOptions options = new ShapeletTransformFactoryOptions.Builder().setMinLength(3).setMaxLength(MultivariateInstanceTools.channelLength(train)).setDistanceType(SubSeqDistance.DistanceType.INDEPENDENT).setKShapelets(train.numInstances()).useBinaryClassValue().useClassBalancing().useCandidatePruning().build();
        return options;
    }

    public static ShapeletTransformFactoryOptions createSHAPELET_D(Instances train) {
        ShapeletTransformFactoryOptions options = new ShapeletTransformFactoryOptions.Builder().setMinLength(3).setMaxLength(MultivariateInstanceTools.channelLength(train)).setDistanceType(SubSeqDistance.DistanceType.DEPENDENT).setKShapelets(train.numInstances()).useBinaryClassValue().useClassBalancing().useCandidatePruning().build();
        return options;
    }

    static {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("INDEPENDENT", DefaultShapeletOptions::createIndependentShapeletSearch);
        map.put("SHAPELET_I", DefaultShapeletOptions::createSHAPELET_I);
        map.put("SHAPELET_D", DefaultShapeletOptions::createSHAPELET_D);
        FACTORY_OPTIONS = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put("INDEPENDENT", DefaultShapeletOptions::createIndependentShapeletSearch_TIMED);
        map.put("SHAPELET_I", DefaultShapeletOptions::createSHAPELET_I_TIMED);
        map.put("SHAPELET_D", DefaultShapeletOptions::createSHAPELET_D_TIMED);
        TIMED_FACTORY_OPTIONS = Collections.unmodifiableMap(map);
    }
}

