/*
 * Decompiled with CFR 0.152.
 */
package multivariate_timeseriesweka;

import fileIO.OutFile;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import timeseriesweka.filters.SummaryStats;
import utilities.ClassifierTools;
import utilities.InstanceTools;
import utilities.MultivariateInstanceTools;
import weka.core.Instances;

public class DataSets {
    public static String dropboxPath = "E:\\LocalData\\Dropbox\\Multivariate TSC\\Aarons Official\\";
    public static String[] multivariateNames = new String[]{"AALTD_0", "AALTD_1", "AALTD_2", "AALTD_3", "AALTD_4", "AALTD_5", "AALTD_6", "AALTD_7", "ArabicDigit", "ArticularyWordLL", "ArticularyWordT1", "ArticularyWordUL", "CricketLeft", "CricketRight", "HandwritingAccelerometer", "HandwritingGyroscope", "JapaneseVowels", "MVMotionA", "MVMotionG", "MVMotionAG", "PEMS", "PenDigits", "UWaveGesture", "VillarData"};

    public static void createAndWriteSummaryStats() throws Exception {
        for (String dataset : multivariateNames) {
            int j;
            int i;
            Instances train;
            try {
                train = ClassifierTools.loadData(new File(dropboxPath + dataset + "/" + dataset + "_TRAIN.arff"));
            }
            catch (IOException ex) {
                continue;
            }
            OutFile out = new OutFile(dropboxPath + dataset + "_summarystats.txt");
            Instances[] channels = MultivariateInstanceTools.splitMultivariateInstances(train);
            out.writeLine("num instances " + train.numInstances());
            out.writeLine("num dimenions " + channels.length);
            out.writeLine("dimension length " + channels[0].numAttributes());
            out.writeLine("num classes " + train.numClasses());
            out.writeLine("[mean, variance, skewness, kurtosis, min, max]");
            double[][][] overallStatsByClass = new double[channels.length][train.numClasses()][6];
            double[][] overallStats = new double[channels.length][6];
            for (i = 0; i < channels.length; ++i) {
                overallStatsByClass[i] = DataSets.calculateStatsForInstances(channels[i]);
            }
            for (i = 0; i < channels.length; ++i) {
                j = 0;
                while (j < 6) {
                    for (int k = 0; k < train.numClasses(); ++k) {
                        double[] dArray = overallStats[i];
                        int n = j;
                        dArray[n] = dArray[n] + overallStatsByClass[i][k][j];
                    }
                    double[] dArray = overallStats[i];
                    int n = j++;
                    dArray[n] = dArray[n] / (double)train.numClasses();
                }
                out.writeLine("Channel " + i + " " + Arrays.toString(overallStats[i]));
            }
            for (i = 0; i < channels.length; ++i) {
                out.writeLine("Channel " + i);
                for (j = 0; j < overallStatsByClass[i].length; ++j) {
                    out.writeLine("class: " + j + " " + Arrays.toString(overallStatsByClass[i][j]));
                }
            }
            out.closeFile();
        }
    }

    public static double[][] calculateStatsForInstances(Instances dataset) throws Exception {
        Instances filter = new SummaryStats().process(dataset);
        Map<Double, Instances> instancesMap = InstanceTools.createClassInstancesMap(filter);
        double[][] seriesStats = new double[instancesMap.size()][6];
        for (Map.Entry<Double, Instances> pair : instancesMap.entrySet()) {
            int i;
            Instances inst = pair.getValue();
            double[][] data = InstanceTools.fromWekaInstancesArray(inst, true);
            double[] averagedStats = new double[6];
            for (i = 0; i < averagedStats.length; ++i) {
                for (int j = 0; j < inst.numInstances(); ++j) {
                    int n = i;
                    averagedStats[n] = averagedStats[n] + data[j][i];
                }
            }
            i = 0;
            while (i < averagedStats.length) {
                int n = i++;
                averagedStats[n] = averagedStats[n] / (double)inst.numInstances();
            }
            seriesStats[(int)pair.getKey().doubleValue()] = averagedStats;
        }
        return seriesStats;
    }

    public static void main(String[] args) throws Exception {
        DataSets.createAndWriteSummaryStats();
    }
}

