/*
 * Decompiled with CFR 0.152.
 */
package development.old_experiments;

import development.DataSets;
import development.Experiments;
import fileIO.OutFile;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Random;
import timeseriesweka.classifiers.ensembles.SaveableEnsemble;
import timeseriesweka.classifiers.ensembles.elastic_ensemble.ED1NN;
import utilities.ClassifierTools;
import utilities.InstanceTools;
import utilities.SaveParameterInfo;
import utilities.TrainAccuracyEstimate;
import vector_classifiers.HESCA;
import vector_classifiers.RotationForestLimitedAttributes;
import vector_classifiers.TunedRandomForest;
import vector_classifiers.TunedRotationForest;
import vector_classifiers.TunedSVM;
import weka.classifiers.Classifier;
import weka.classifiers.functions.Logistic;
import weka.classifiers.lazy.IBk;
import weka.classifiers.trees.RandomForest;
import weka.core.Instances;

public class July2017Experiments {
    public static String[] classifiers = new String[]{"SVM"};
    public static double propInTrain = 0.5;
    public static int folds = 30;
    public static Random rand = new Random(0L);
    static boolean debug = true;
    static boolean generateTrainFiles = true;

    public static Classifier setClassifier(String classifier, int fold) {
        switch (classifier) {
            case "logistic": {
                Logistic log = new Logistic();
                return log;
            }
            case "TunedSVMRBF": {
                TunedSVM svm = new TunedSVM();
                svm.setKernelType(TunedSVM.KernelType.RBF);
                svm.optimiseParas(true);
                svm.optimiseKernel(false);
                svm.setBuildLogisticModels(true);
                svm.setSeed(fold);
                return svm;
            }
            case "RotF": {
                TunedRotationForest r = new TunedRotationForest();
                r.setNumIterations(200);
                r.justBuildTheClassifier();
                return r;
            }
            case "RandRotF1": {
                RotationForestLimitedAttributes r3 = new RotationForestLimitedAttributes();
                r3.setNumIterations(200);
                r3.setMaxNumAttributes(100);
                r3.justBuildTheClassifier();
                return r3;
            }
            case "HESCA": {
                String[] names = new String[]{"RotFCV", "RandFOOB", "SVM"};
                Classifier[] c = new Classifier[]{new IBk(), new IBk(), new IBk()};
                HESCA h = new HESCA();
                h.setClassifiers(c, names, null);
                h.setDebug(true);
                return h;
            }
            case "RotFCV": {
                TunedRotationForest r = new TunedRotationForest();
                r.setNumIterations(200);
                r.tuneParameters(false);
                r.estimateAccFromTrain(true);
                return r;
            }
            case "RandFCV": {
                TunedRandomForest randF = new TunedRandomForest();
                randF.tuneParameters(false);
                randF.setNumTrees(500);
                randF.debug(debug);
                randF.setSeed(fold);
                randF.setEstimateAcc(true);
                randF.setCrossValidate(true);
                return randF;
            }
            case "RandFOOB": {
                TunedRandomForest randF = new TunedRandomForest();
                randF.tuneParameters(false);
                randF.setNumTrees(500);
                randF.debug(debug);
                randF.setSeed(fold);
                randF.setEstimateAcc(true);
                randF.setCrossValidate(false);
                return randF;
            }
            case "TunedRandFCV": {
                int[] numTrees = new int[]{10, 50, 100, 200, 300, 400, 500, 600, 700, 800, 900};
                TunedRandomForest randF = new TunedRandomForest();
                randF.tuneParameters(true);
                randF.setSeed(fold);
                randF.setEstimateAcc(true);
                randF.setCrossValidate(true);
                randF.setNumTreesRange(numTrees);
                return randF;
            }
            case "TunedRandFOOB": {
                int[] numTrees = new int[]{10, 50, 100, 200, 300, 400, 500, 600, 700, 800, 900};
                TunedRandomForest randF = new TunedRandomForest();
                randF.tuneParameters(true);
                randF.setSeed(fold);
                randF.setEstimateAcc(true);
                randF.setCrossValidate(false);
                randF.setNumTreesRange(numTrees);
                return randF;
            }
            case "TunedRotFCV": {
                int[] numTrees = new int[]{10, 50, 100, 200, 300, 400, 500, 600, 700, 800, 900};
                TunedRotationForest r = new TunedRotationForest();
                r.tuneParameters(true);
                r.setSeed(fold);
                r.setNumTreesRange(numTrees);
                return r;
            }
        }
        throw new RuntimeException("Unknown classifier = " + classifier + " in Feb 2017 class");
    }

    public static void singleClassifierAndFoldSingleDataSet(String[] args) {
        String predictions;
        String classifier = args[0];
        String problem = args[1];
        int fold = Integer.parseInt(args[2]) - 1;
        Classifier c = July2017Experiments.setClassifier(classifier, fold);
        Instances all = ClassifierTools.loadData(DataSets.problemPath + problem + "/" + problem);
        Instances[] split = InstanceTools.resampleInstances(all, fold, propInTrain);
        File f = new File(DataSets.resultsPath + classifier);
        if (!f.exists()) {
            f.mkdir();
        }
        if (!(f = new File(predictions = DataSets.resultsPath + classifier + "/Predictions" + "/" + problem)).exists()) {
            f.mkdirs();
        }
        if (!(f = new File(predictions + "/testFold" + fold + ".csv")).exists() || f.length() == 0L) {
            if (c instanceof TrainAccuracyEstimate) {
                ((TrainAccuracyEstimate)((Object)c)).writeCVTrainToFile(predictions + "/trainFold" + fold + ".csv");
            }
            if (c instanceof HESCA) {
                System.out.println("Turning on file read ");
                ((HESCA)c).setResultsFileLocationParameters(DataSets.resultsPath, problem, fold);
                ((HESCA)c).setBuildIndividualsFromResultsFiles(true);
            }
            double acc = July2017Experiments.singleClassifierAndFoldSingleDataSet(split[0], split[1], c, fold, predictions);
            System.out.println(classifier + "," + problem + "," + fold + "," + acc);
        }
    }

    public static double singleClassifierAndFoldSingleDataSet(Instances train, Instances test, Classifier c, int fold, String resultsPath) {
        double acc = 0.0;
        OutFile p = null;
        try {
            c.buildClassifier(train);
            StringBuilder str = new StringBuilder();
            DecimalFormat df = new DecimalFormat("##.######");
            for (int j = 0; j < test.numInstances(); ++j) {
                int act = (int)test.instance(j).classValue();
                test.instance(j).setClassMissing();
                double[] probs = c.distributionForInstance(test.instance(j));
                int pred = 0;
                for (int i = 1; i < probs.length; ++i) {
                    if (!(probs[i] > probs[pred])) continue;
                    pred = i;
                }
                if (act == pred) {
                    acc += 1.0;
                }
                str.append(act);
                str.append(",");
                str.append(pred);
                str.append(",");
                for (double d : probs) {
                    str.append(",");
                    str.append(df.format(d));
                }
                str.append("\n");
            }
            acc /= (double)test.numInstances();
            p = new OutFile(resultsPath + "/testFold" + fold + ".csv");
            if (p == null) {
                throw new Exception(" file wont open!! " + resultsPath + "/testFold" + fold + ".csv");
            }
            p.writeLine(train.relationName() + "," + c.getClass().getName() + ",test");
            if (c instanceof SaveParameterInfo) {
                p.writeLine(((SaveParameterInfo)((Object)c)).getParameters());
            } else {
                p.writeLine("No parameter info");
            }
            p.writeLine(acc + "");
            p.writeLine(str.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(" Error =" + e + " in method singleClassifierAndFold in class Feb2017");
            System.out.println(" Classifier = " + c.getClass().getName());
            System.out.println(" Results path=" + resultsPath);
            System.out.println(" Outfile = " + p);
            System.out.println(" Train Split = " + train.toSummaryString());
            System.out.println(" Test Split = " + test.toSummaryString());
            e.printStackTrace();
            System.out.println(" TRAIN " + train.relationName() + " has " + train.numAttributes() + " attributes and " + train.numInstances() + " instances");
            System.out.println(" TEST " + test.relationName() + " has " + test.numAttributes() + " attributes" + test.numInstances() + " instances");
            System.exit(0);
        }
        return acc;
    }

    public static void singleClassifierAndFoldTrainTestSplit(String[] args) {
        String predictions;
        String classifier = args[0];
        String problem = args[1];
        int fold = Integer.parseInt(args[2]) - 1;
        Classifier c = July2017Experiments.setClassifier(classifier, fold);
        Instances train = ClassifierTools.loadData(DataSets.problemPath + problem + "/" + problem + "_TRAIN");
        Instances test = ClassifierTools.loadData(DataSets.problemPath + problem + "/" + problem + "_TEST");
        File f = new File(DataSets.resultsPath + classifier);
        if (!f.exists()) {
            f.mkdir();
        }
        if (!(f = new File(predictions = DataSets.resultsPath + classifier + "/Predictions")).exists()) {
            f.mkdir();
        }
        if (!(f = new File(predictions = predictions + "/" + problem)).exists()) {
            f.mkdir();
        }
        if (!(f = new File(predictions + "/testFold" + fold + ".csv")).exists() || f.length() == 0L) {
            if (c instanceof TrainAccuracyEstimate) {
                ((TrainAccuracyEstimate)((Object)c)).writeCVTrainToFile(predictions + "/trainFold" + fold + ".csv");
            }
            double acc = July2017Experiments.singleClassifierAndFoldTrainTestSplit(train, test, c, fold, predictions);
            System.out.println(classifier + "," + problem + "," + fold + "," + acc);
        }
    }

    public static double singleClassifierAndFoldTrainTestSplit(Instances train, Instances test, Classifier c, int fold, String resultsPath) {
        Instances[] data = InstanceTools.resampleTrainAndTestInstances(train, test, fold);
        double acc = 0.0;
        if (c instanceof SaveableEnsemble) {
            ((SaveableEnsemble)((Object)c)).saveResults(resultsPath + "/internalCV_" + fold + ".csv", resultsPath + "/internalTestPreds_" + fold + ".csv");
        }
        try {
            c.buildClassifier(data[0]);
            if (debug && c instanceof RandomForest) {
                System.out.println(" Number of features in MAIN=" + ((RandomForest)c).getNumFeatures());
            }
            StringBuilder str = new StringBuilder();
            DecimalFormat df = new DecimalFormat("##.######");
            for (int j = 0; j < data[1].numInstances(); ++j) {
                int act = (int)data[1].instance(j).classValue();
                data[1].instance(j).setClassMissing();
                double[] probs = c.distributionForInstance(data[1].instance(j));
                int pred = 0;
                for (int i = 1; i < probs.length; ++i) {
                    if (!(probs[i] > probs[pred])) continue;
                    pred = i;
                }
                if (act == pred) {
                    acc += 1.0;
                }
                str.append(act);
                str.append(",");
                str.append(pred);
                str.append(",,");
                for (double d : probs) {
                    str.append(df.format(d));
                    str.append(",");
                }
                str.append("\n");
            }
            acc /= (double)data[1].numInstances();
            OutFile p = new OutFile(resultsPath + "/testFold" + fold + ".csv");
            p.writeLine(train.relationName() + "," + c.getClass().getName() + ",test");
            if (c instanceof SaveParameterInfo) {
                p.writeLine(((SaveParameterInfo)((Object)c)).getParameters());
            } else {
                p.writeLine("No parameter info");
            }
            p.writeLine(acc + "");
            p.writeLine(str.toString());
        }
        catch (Exception e) {
            System.out.println(" Error =" + e + " in method simpleExperiment" + e);
            e.printStackTrace();
            System.out.println(" TRAIN " + train.relationName() + " has " + train.numAttributes() + " attributes and " + train.numInstances() + " instances");
            System.out.println(" TEST " + test.relationName() + " has " + test.numAttributes() + " attributes" + test.numInstances() + " instances");
            System.exit(0);
        }
        return acc;
    }

    public static void main(String[] args) throws Exception {
        File f;
        July2017Experiments.sanityCheckBones();
        System.exit(0);
        for (String str : args) {
            System.out.println(str);
        }
        if (args.length != 6) {
            DataSets.problemPath = "C:\\Users\\ajb\\Dropbox\\TSC Problems\\";
            DataSets.resultsPath = "c:\\Temp\\";
            f = new File(DataSets.resultsPath);
            if (!f.isDirectory()) {
                f.mkdirs();
            }
            generateTrainFiles = true;
            String[] newArgs = new String[]{"RandF", "ItalyPowerDemand", "1"};
            Experiments.singleClassifierAndFoldTrainTestSplit(newArgs);
            System.exit(0);
        } else {
            DataSets.problemPath = args[0];
            DataSets.resultsPath = args[1];
            generateTrainFiles = Boolean.parseBoolean(args[2]);
            f = new File(DataSets.resultsPath);
            if (!f.isDirectory()) {
                f.mkdirs();
            }
            String[] newArgs = new String[args.length - 3];
            for (int i = 3; i < args.length; ++i) {
                newArgs[i - 3] = args[i];
            }
            Experiments.singleClassifierAndFoldTrainTestSplit(newArgs);
        }
    }

    public static void runTSCDataSet(String[] args) {
        if (args.length > 0) {
            DataSets.problemPath = DataSets.clusterPath + "TSCProblems/";
            DataSets.resultsPath = DataSets.clusterPath + "Results/RepoResults/";
            File f = new File(DataSets.resultsPath);
            if (!f.isDirectory()) {
                f.mkdirs();
            }
            July2017Experiments.singleClassifierAndFoldTrainTestSplit(args);
        } else {
            DataSets.problemPath = DataSets.dropboxPath + "TSC Problems/";
            DataSets.resultsPath = DataSets.dropboxPath + "Results/RepoResults/";
            File f = new File(DataSets.resultsPath);
            if (!f.isDirectory()) {
                f.mkdirs();
            }
            String[] paras = new String[]{"RandFCV", "ItalyPowerDemand", "1"};
            July2017Experiments.singleClassifierAndFoldTrainTestSplit(paras);
            long t1 = System.currentTimeMillis();
            for (int i = 2; i <= 11; ++i) {
                paras[2] = i + "";
                July2017Experiments.singleClassifierAndFoldSingleDataSet(paras);
            }
            long t2 = System.currentTimeMillis();
            paras[0] = "RandFOOB";
            July2017Experiments.singleClassifierAndFoldSingleDataSet(paras);
            long t3 = System.currentTimeMillis();
            for (int i = 2; i <= 11; ++i) {
                paras[2] = i + "";
                July2017Experiments.singleClassifierAndFoldSingleDataSet(paras);
            }
            long t4 = System.currentTimeMillis();
            System.out.println("Standard = " + (t2 - t1) + ", Enhanced = " + (t4 - t3));
        }
    }

    public static void sanityCheckBones() {
        String[] files;
        for (String str : files = new String[]{"MiddlePhalanxOutlineAgeGroup", "MiddlePhalanxTW", "MiddlePhalanxOutlineCorrect", "DistalPhalanxOutlineCorrect", "DistalPhalanxOutlineAgeGroup", "DistalPhalanxTW"}) {
            Instances train = ClassifierTools.loadData("C:\\Users\\ajb\\Dropbox\\TSC Problems\\" + str + "\\" + str + "_TRAIN");
            Instances test = ClassifierTools.loadData("C:\\Users\\ajb\\Dropbox\\TSC Problems\\" + str + "\\" + str + "_TEST");
            ED1NN c = new ED1NN();
            double a = ClassifierTools.singleTrainTestSplitAccuracy(c, train, test);
            System.out.println(str + " correct ACC = " + a);
            Instances train2 = ClassifierTools.loadData("C:\\Users\\ajb\\Dropbox\\TSC Problems\\" + str + "\\" + str + "_TEST");
            Instances test2 = ClassifierTools.loadData("C:\\Users\\ajb\\Dropbox\\TSC Problems\\" + str + "\\" + str + "_TRAIN");
            ED1NN c2 = new ED1NN();
            double a2 = ClassifierTools.singleTrainTestSplitAccuracy(c2, train2, test2);
            System.out.println(str + " inverted ACC = " + a2);
        }
    }

    public static void runUCIDataSet(String[] args) {
        if (args.length > 0) {
            DataSets.problemPath = DataSets.clusterPath + "UCIContinuous/";
            DataSets.resultsPath = DataSets.clusterPath + "Results/UCIResults/";
            File f = new File(DataSets.resultsPath);
            if (!f.isDirectory()) {
                f.mkdirs();
            }
            July2017Experiments.singleClassifierAndFoldSingleDataSet(args);
        } else {
            DataSets.problemPath = DataSets.dropboxPath + "UCI Problems/";
            DataSets.resultsPath = DataSets.dropboxPath + "Results/UCIResults/";
            File f = new File(DataSets.resultsPath);
            if (!f.isDirectory()) {
                f.mkdirs();
            }
            String[] paras = new String[]{"", "semeion", "1"};
            DataSets.problemPath = "C:/Data/UCI Problems/";
            DataSets.resultsPath = DataSets.dropboxPath + "Results/UCIResults/";
            File file = new File("C:\\Users\\ajb\\Dropbox\\Results\\UCIResults");
            paras[0] = "RotFCV";
            paras[2] = "1";
            July2017Experiments.singleClassifierAndFoldSingleDataSet(paras);
            long t1 = System.currentTimeMillis();
            for (int i = 2; i <= 11; ++i) {
                paras[2] = i + "";
                July2017Experiments.singleClassifierAndFoldSingleDataSet(paras);
            }
            long t2 = System.currentTimeMillis();
            paras[0] = "EnhancedRotF";
            July2017Experiments.singleClassifierAndFoldSingleDataSet(paras);
            long t3 = System.currentTimeMillis();
            for (int i = 2; i <= 11; ++i) {
                paras[2] = i + "";
                July2017Experiments.singleClassifierAndFoldSingleDataSet(paras);
            }
            long t4 = System.currentTimeMillis();
            System.out.println("Standard = " + (t2 - t1) + ", Enhanced = " + (t4 - t3));
        }
    }
}

