/*
 * Decompiled with CFR 0.152.
 */
package development;

import ResultsProcessing.MatlabController;
import development.DataSets;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import utilities.ClassifierResults;
import utilities.ClassifierResultsAnalysis;
import utilities.DebugPrinting;
import utilities.ErrorReport;
import utilities.generic_storage.Pair;

public class MultipleClassifierEvaluation
implements DebugPrinting {
    private String writePath;
    private String experimentName;
    private List<String> datasets;
    private Map<String, ClassifierResults[][][]> classifiersResults;
    private int numFolds;
    private ArrayList<Pair<String, Function<ClassifierResults, Double>>> statistics;
    private boolean buildMatlabDiagrams;
    private boolean cleanResults;
    private boolean testResultsOnly;

    public MultipleClassifierEvaluation(String writePath, String experimentName, int numFolds) {
        this.writePath = writePath;
        this.experimentName = experimentName;
        this.numFolds = numFolds;
        this.buildMatlabDiagrams = false;
        this.cleanResults = true;
        this.testResultsOnly = true;
        this.datasets = new ArrayList<String>();
        this.classifiersResults = new HashMap<String, ClassifierResults[][][]>();
        this.statistics = ClassifierResultsAnalysis.getDefaultStatistics();
    }

    public MultipleClassifierEvaluation setTestResultsOnly(boolean b) {
        this.testResultsOnly = b;
        return this;
    }

    public MultipleClassifierEvaluation setBuildMatlabDiagrams(boolean b) {
        this.buildMatlabDiagrams = b;
        return this;
    }

    public MultipleClassifierEvaluation setCleanResults(boolean b) {
        this.cleanResults = b;
        return this;
    }

    public MultipleClassifierEvaluation setDatasets(List<String> datasets) {
        this.datasets = datasets;
        return this;
    }

    public MultipleClassifierEvaluation setDatasets(String[] datasets) {
        this.datasets = Arrays.asList(datasets);
        return this;
    }

    public MultipleClassifierEvaluation addDataset(String dataset) {
        this.datasets.add(dataset);
        return this;
    }

    public MultipleClassifierEvaluation removeDataset(String dataset) {
        this.datasets.remove(dataset);
        return this;
    }

    public MultipleClassifierEvaluation clearDatasets() {
        this.datasets.clear();
        return this;
    }

    public MultipleClassifierEvaluation setUseDefaultEvaluationStatistics() {
        this.statistics = ClassifierResultsAnalysis.getDefaultStatistics();
        return this;
    }

    public MultipleClassifierEvaluation setUseAccuracyOnly() {
        this.statistics = ClassifierResultsAnalysis.getAccuracyStatisticOnly();
        return this;
    }

    public MultipleClassifierEvaluation setUseAllStatistics() {
        this.statistics = ClassifierResultsAnalysis.getAllStatistics();
        return this;
    }

    public MultipleClassifierEvaluation addEvaluationStatistic(String statName, Function<ClassifierResults, Double> classifierResultsManipulatorFunction) {
        this.statistics.add(new Pair<String, Function<ClassifierResults, Double>>(statName, classifierResultsManipulatorFunction));
        return this;
    }

    public MultipleClassifierEvaluation removeEvaluationStatistic(String statName) {
        for (Pair<String, Function<ClassifierResults, Double>> statistic : this.statistics) {
            if (!((String)statistic.var1).equalsIgnoreCase(statName)) continue;
            this.statistics.remove(statistic);
        }
        return this;
    }

    public MultipleClassifierEvaluation clearEvaluationStatistics(String statName) {
        this.statistics.clear();
        return this;
    }

    public MultipleClassifierEvaluation addClassifier(String classifierName, ClassifierResults[][] trainDatasetFoldResults, ClassifierResults[][] testDatasetFoldResults) throws Exception {
        if (this.datasets.size() == 0) {
            throw new Exception("No datasets set for evaluation");
        }
        for (int d = 0; d < testDatasetFoldResults.length; ++d) {
            for (int f = 0; f < testDatasetFoldResults[d].length; ++f) {
                if (!this.testResultsOnly && trainDatasetFoldResults != null) {
                    trainDatasetFoldResults[d][f].findAllStatsOnce();
                    if (this.cleanResults) {
                        trainDatasetFoldResults[d][f].cleanPredictionInfo();
                    }
                }
                testDatasetFoldResults[d][f].findAllStatsOnce();
                if (!this.cleanResults) continue;
                testDatasetFoldResults[d][f].cleanPredictionInfo();
            }
        }
        this.classifiersResults.put(classifierName, new ClassifierResults[][][]{trainDatasetFoldResults, testDatasetFoldResults});
        return this;
    }

    public MultipleClassifierEvaluation addClassifiers(String[] classifierNames, ClassifierResults[][][] trainClassifierDatasetFoldResults, ClassifierResults[][][] testClassifierDatasetFoldResults) throws Exception {
        for (int i = 0; i < classifierNames.length; ++i) {
            this.addClassifier(classifierNames[i], trainClassifierDatasetFoldResults[i], trainClassifierDatasetFoldResults[i]);
        }
        return this;
    }

    public MultipleClassifierEvaluation readInClassifier(String classifierName, String baseReadPath) throws Exception {
        if (this.datasets.size() == 0) {
            throw new Exception("No datasets set for evaluation");
        }
        if (baseReadPath.charAt(baseReadPath.length() - 1) != '/') {
            baseReadPath = baseReadPath + "/";
        }
        this.printlnDebug(classifierName + " reading");
        int totalFnfs = 0;
        ErrorReport er = new ErrorReport("FileNotFoundExceptions thrown (### total):\n");
        ClassifierResults[][][] results = new ClassifierResults[2][this.datasets.size()][this.numFolds];
        if (this.testResultsOnly) {
            results[0] = null;
        }
        for (int d = 0; d < this.datasets.size(); ++d) {
            for (int f = 0; f < this.numFolds; ++f) {
                if (!this.testResultsOnly) {
                    String trainFile = baseReadPath + classifierName + "/Predictions/" + this.datasets.get(d) + "/trainFold" + f + ".csv";
                    try {
                        results[0][d][f] = new ClassifierResults(trainFile);
                        results[0][d][f].findAllStatsOnce();
                        if (this.cleanResults) {
                            results[0][d][f].cleanPredictionInfo();
                        }
                    }
                    catch (FileNotFoundException ex) {
                        er.log(trainFile + "\n");
                        ++totalFnfs;
                    }
                }
                String testFile = baseReadPath + classifierName + "/Predictions/" + this.datasets.get(d) + "/testFold" + f + ".csv";
                try {
                    results[1][d][f] = new ClassifierResults(testFile);
                    results[1][d][f].findAllStatsOnce();
                    if (!this.cleanResults) continue;
                    results[1][d][f].cleanPredictionInfo();
                    continue;
                }
                catch (FileNotFoundException ex) {
                    er.log(testFile + "\n");
                    ++totalFnfs;
                }
            }
        }
        er.getLog().replace("###", totalFnfs + "");
        er.throwIfErrors();
        this.printlnDebug(classifierName + " successfully read in");
        this.classifiersResults.put(classifierName, results);
        return this;
    }

    public MultipleClassifierEvaluation readInClassifiers(String[] classifierNames, String baseReadPath) throws Exception {
        ErrorReport er = new ErrorReport("Results files not found:\n");
        for (int i = 0; i < classifierNames.length; ++i) {
            try {
                this.readInClassifier(classifierNames[i], baseReadPath);
                continue;
            }
            catch (Exception e) {
                er.log("Classifier Errors: " + classifierNames[i] + "\n" + e);
            }
        }
        er.throwIfErrors();
        return this;
    }

    public MultipleClassifierEvaluation removeClassifier(String classifierName) {
        this.classifiersResults.remove(classifierName);
        return this;
    }

    public MultipleClassifierEvaluation clearClassifiers() {
        this.classifiersResults.clear();
        return this;
    }

    public void runComparison() {
        ArrayList<ClassifierResultsAnalysis.ClassifierEvaluation> results = new ArrayList<ClassifierResultsAnalysis.ClassifierEvaluation>(this.classifiersResults.size());
        for (Map.Entry<String, ClassifierResults[][][]> classifier : this.classifiersResults.entrySet()) {
            results.add(new ClassifierResultsAnalysis.ClassifierEvaluation(classifier.getKey(), classifier.getValue()[1], classifier.getValue()[0], null));
        }
        ClassifierResultsAnalysis.buildMatlabDiagrams = this.buildMatlabDiagrams;
        ClassifierResultsAnalysis.testResultsOnly = this.testResultsOnly;
        this.printlnDebug("Writing started");
        ClassifierResultsAnalysis.writeAllEvaluationFiles(this.writePath, this.experimentName, this.statistics, results, this.datasets.toArray(new String[0]));
        this.printlnDebug("Writing finished");
        if (this.buildMatlabDiagrams) {
            MatlabController.getInstance().discconnectMatlab();
        }
    }

    public static void main(String[] args) throws Exception {
        String basePath = "C:/JamesLPHD/HESCA/UCI/UCIResults/";
        MultipleClassifierEvaluation mcc = new MultipleClassifierEvaluation("C:/JamesLPHD/analysisTest/", "testrunPWS10", 30);
        mcc.setTestResultsOnly(true);
        mcc.setBuildMatlabDiagrams(true);
        mcc.setCleanResults(true);
        mcc.setDebugPrinting(true);
        mcc.setUseDefaultEvaluationStatistics();
        mcc.setDatasets(DataSets.UCIContinuousFileNames);
        mcc.readInClassifiers(new String[]{"NN", "C4.5", "RotF", "RandF"}, basePath);
        mcc.runComparison();
    }
}

