/*
 * Decompiled with CFR 0.152.
 */
package development;

import development.MultipleClassifiersPairwiseTest;
import fileIO.InFile;
import fileIO.OutFile;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import statistics.distributions.BinomialDistribution;
import statistics.tests.OneSampleTests;
import utilities.ClassifierResults;

public class CollateResults {
    public static File[] dir;
    static String basePath;
    static String[] classifiers;
    static ArrayList<String> problems;
    static String problemPath;
    static int folds;
    static int numClassifiers;
    static int[] numParas;
    static DecimalFormat df;
    static double[][] data;
    static boolean countPartials;
    public static int MAXNUMPARAS;

    public static void readData(String[] args) {
        int i;
        int numInitArgs = 4;
        basePath = args[0];
        System.out.println("Base path = " + basePath);
        problemPath = args[1];
        System.out.println("Problem path = " + problemPath);
        folds = Integer.parseInt(args[2]);
        System.out.println("Folds = " + folds);
        String partial = args[3].toLowerCase();
        countPartials = partial.equals("true");
        numClassifiers = (args.length - numInitArgs) / 2;
        classifiers = new String[numClassifiers];
        for (i = 0; i < classifiers.length; ++i) {
            CollateResults.classifiers[i] = args[i + numInitArgs];
        }
        numParas = new int[classifiers.length];
        for (i = 0; i < classifiers.length; ++i) {
            CollateResults.numParas[i] = Integer.parseInt(args[i + numInitArgs + classifiers.length]);
        }
        File f = new File(problemPath);
        problems = new ArrayList();
        if (problemPath.contains(".txt") || problemPath.contains(".csv")) {
            if (!f.exists()) {
                System.out.println("Error loading problems  from file =" + problemPath);
            } else {
                InFile inf = new InFile(problemPath);
                String prob = inf.readLine();
                while (prob != null) {
                    problems.add(prob);
                    prob = inf.readLine();
                }
            }
        } else {
            if (!f.isDirectory()) {
                System.out.println("Error in problem path =" + problemPath);
            }
            for (File p : dir = f.listFiles()) {
                if (!p.isDirectory()) continue;
                problems.add(p.getName());
            }
        }
        Collections.sort(problems);
    }

    public static boolean validateSingleFoldFile(String str) {
        File f = new File(str);
        if (f.exists()) {
            if (f.length() == 0L) {
                f.delete();
            } else {
                try {
                    return true;
                }
                catch (Exception e) {
                    System.out.println("Exception thrown trying to read file " + str);
                    System.out.println("Exception = " + e + "  THIS MAY BE A GOTCHA LATER");
                    e.printStackTrace();
                    return false;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void collateFolds() {
        for (int i = 0; i < classifiers.length; ++i) {
            String cls = classifiers[i];
            System.out.println("Processing classifier =" + cls);
            File f = new File(basePath + cls);
            if (f.isDirectory()) {
                System.out.println("Base path " + basePath + cls + " exists");
                File stats = new File(basePath + cls + "/SummaryStats");
                if (!stats.isDirectory()) {
                    stats.mkdir();
                }
                String filePath = basePath + cls + "/SummaryStats/";
                OutFile clsResults = new OutFile(filePath + cls + "TestAcc.csv");
                OutFile f1Results = new OutFile(filePath + cls + "TestF1.csv");
                OutFile BAccResults = new OutFile(filePath + cls + "TestBAcc.csv");
                OutFile nllResults = new OutFile(filePath + cls + "TestNLL.csv");
                OutFile AUROCResults = new OutFile(filePath + cls + "TestAUROC.csv");
                OutFile trainResults = new OutFile(filePath + cls + "TrainCVAcc.csv");
                OutFile[] paraFiles = new OutFile[numParas[i]];
                for (int j = 0; j < paraFiles.length; ++j) {
                    paraFiles[j] = new OutFile(filePath + cls + "Parameter" + (j + 1) + ".csv");
                }
                OutFile timings = new OutFile(filePath + cls + "Timings.csv");
                OutFile allAccSearchValues = new OutFile(filePath + cls + "AllTuningAccuracies.csv");
                OutFile missing = null;
                OutFile counts = new OutFile(filePath + cls + "Counts.csv");
                OutFile partials = null;
                if (countPartials) {
                    partials = new OutFile(filePath + cls + "PartialCounts.csv");
                }
                OutFile of = new OutFile(filePath + cls + "Corrupted.csv");
                int missingCount = 0;
                for (String name : problems) {
                    clsResults.writeString(name);
                    trainResults.writeString(name);
                    f1Results.writeString(name);
                    BAccResults.writeString(name);
                    nllResults.writeString(name);
                    AUROCResults.writeString(name);
                    allAccSearchValues.writeString(name);
                    timings.writeString(name);
                    for (OutFile out : paraFiles) {
                        out.writeString(name + ",");
                    }
                    String path = basePath + cls + "/" + name + "/results/";
                    if (missing != null && missingCount > 0) {
                        missing.writeString("\n");
                    }
                    missingCount = 0;
                    if (countPartials) {
                        partials.writeString(name);
                    }
                    for (int j = 0; j < folds; ++j) {
                        boolean valid = CollateResults.validateSingleFoldFile(path + "//testFold" + j + ".csv");
                        if (valid) {
                            InFile inf = null;
                            String[] trainRes = null;
                            try {
                                inf = new InFile(path + "//testFold" + j + ".csv");
                                inf.readLine();
                                trainRes = inf.readLine().split(",");
                                clsResults.writeString("," + inf.readDouble());
                                if (trainRes.length > 1) {
                                    String str = trainRes[1].trim();
                                    timings.writeString("," + df.format(Double.parseDouble(str)));
                                    if (trainRes.length > 3) {
                                        str = trainRes[3].trim();
                                        trainResults.writeString("," + Double.parseDouble(str));
                                        int pos = 5;
                                        for (int k = 0; k < numParas[i]; ++k) {
                                            if (trainRes.length > pos) {
                                                paraFiles[k].writeString(trainRes[pos] + ",");
                                                pos += 2;
                                                continue;
                                            }
                                            paraFiles[k].writeString(",");
                                        }
                                        while (pos < trainRes.length) {
                                            allAccSearchValues.writeString("," + trainRes[pos++]);
                                        }
                                    }
                                } else {
                                    trainResults.writeString(",");
                                    for (int k = 0; k < numParas[i]; ++k) {
                                        paraFiles[k].writeString(",");
                                    }
                                }
                                inf.closeFile();
                                ClassifierResults res = new ClassifierResults();
                                res.loadFromFile(path + "//testFold" + j + ".csv");
                                res.findAllStats();
                                f1Results.writeString("," + res.f1);
                                BAccResults.writeString("," + res.balancedAcc);
                                nllResults.writeString("," + res.nll);
                                AUROCResults.writeString("," + res.meanAUROC);
                            }
                            catch (Exception e) {
                                System.out.println(" Error " + e + " in " + path);
                                if (trainRes != null) {
                                    System.out.println(" second line read has " + trainRes.length + " entries :");
                                    for (String str : trainRes) {
                                        System.out.print(str + ",");
                                    }
                                    System.out.println("XX" + trainRes[1] + "XX AND TRIMMED: XX" + trainRes[1].trim() + "XX");
                                    of.writeLine(name + "," + j);
                                    e.printStackTrace();
                                    System.exit(1);
                                }
                            }
                            finally {
                                if (inf != null) {
                                    inf.closeFile();
                                }
                            }
                            if (!countPartials) continue;
                            partials.writeString(",0");
                            continue;
                        }
                        if (missing == null) {
                            missing = new OutFile(filePath + cls + "MissingFolds.csv");
                        }
                        if (missingCount == 0) {
                            missing.writeString(name);
                        }
                        ++missingCount;
                        missing.writeString("," + j);
                        if (!countPartials) continue;
                        int x = 0;
                        for (int k = 1; k < MAXNUMPARAS; ++k) {
                            if (!CollateResults.validateSingleFoldFile(path + "//fold" + j + "_" + k + ".csv")) continue;
                            ++x;
                        }
                        if (!countPartials) continue;
                        partials.writeString("," + x);
                    }
                    counts.writeLine(name + "," + (folds - missingCount));
                    if (countPartials) {
                        partials.writeString("\n");
                    }
                    clsResults.writeString("\n");
                    trainResults.writeString("\n");
                    f1Results.writeString("\n");
                    BAccResults.writeString("\n");
                    nllResults.writeString("\n");
                    AUROCResults.writeString("\n");
                    timings.writeString("\n");
                    allAccSearchValues.writeString("\n");
                    for (int k = 0; k < paraFiles.length; ++k) {
                        paraFiles[k].writeString("\n");
                    }
                }
                clsResults.closeFile();
                trainResults.closeFile();
                for (int k = 0; k < paraFiles.length; ++k) {
                    paraFiles[k].closeFile();
                }
                continue;
            }
            System.out.println("Classifier " + cls + " has no results directory: " + basePath + cls);
        }
    }

    public static void averageOverFolds() {
        File nf;
        String name = classifiers[0];
        for (int i = 1; i < classifiers.length; ++i) {
            name = name + classifiers[i];
        }
        String filePath = basePath + name + "/";
        if (classifiers.length == 1) {
            filePath = filePath + "SummaryStats/";
        }
        if (!(nf = new File(filePath)).isDirectory()) {
            nf.mkdirs();
        }
        String[] allStats = new String[]{"MeanTestAcc", "MeanTrainCVAcc", "MeanTestNLL", "MeanTestBAcc", "MeanTestAUROC", "MeanTestF1", "MeanTimings"};
        String[] testStats = new String[]{"TestAcc", "TrainCVAcc", "TestNLL", "TestBAcc", "TestAUROC", "TestF1", "Timings"};
        OutFile[] means = new OutFile[allStats.length];
        for (int i = 0; i < means.length; ++i) {
            means[i] = new OutFile(filePath + allStats[i] + name + ".csv");
        }
        OutFile[] stDev = new OutFile[allStats.length];
        for (int i = 0; i < stDev.length; ++i) {
            stDev[i] = new OutFile(filePath + allStats[i] + "StDev" + name + ".csv");
        }
        OutFile count = new OutFile(filePath + "Counts" + name + ".csv");
        for (int i = 0; i < classifiers.length; ++i) {
            for (OutFile of : means) {
                of.writeString("," + classifiers[i]);
            }
            OutFile[] outFileArray = stDev;
            int n = outFileArray.length;
            for (int j = 0; j < n; ++j) {
                OutFile of;
                of = outFileArray[j];
                of.writeString("," + classifiers[i]);
            }
            count.writeString("," + classifiers[i]);
        }
        for (OutFile of : means) {
            of.writeString("\n");
        }
        for (OutFile of : stDev) {
            of.writeString("\n");
        }
        count.writeString("\n");
        InFile[] allClassifiers = new InFile[classifiers.length];
        for (int i = 0; i < allClassifiers.length; ++i) {
            String str = basePath + classifiers[i] + "/SummaryStats/" + classifiers[i];
            System.out.println("Loading " + str + "Counts.csv");
            String p = str + "Counts.csv";
            if (new File(p).exists()) {
                allClassifiers[i] = new InFile(p);
                continue;
            }
            allClassifiers[i] = null;
            System.out.println("File " + p + " does not exist");
        }
        for (String str : problems) {
            count.writeString(str);
            for (int i = 0; i < allClassifiers.length; ++i) {
                if (allClassifiers[i] != null) {
                    allClassifiers[i].readString();
                    count.writeString("," + allClassifiers[i].readInt());
                    continue;
                }
                count.writeString(",");
            }
            count.writeString("\n");
        }
        for (int j = 0; j < allStats.length; ++j) {
            for (int i = 0; i < allClassifiers.length; ++i) {
                String str = basePath + classifiers[i] + "/SummaryStats/" + classifiers[i];
                String p = str + testStats[j] + ".csv";
                if (new File(p).exists()) {
                    allClassifiers[i] = new InFile(p);
                    continue;
                }
                allClassifiers[i] = null;
                System.out.println("File " + p + " does not exist");
            }
            for (String str : problems) {
                means[j].writeString(str);
                stDev[j].writeString(str);
                String prev = "First";
                for (int i = 0; i < allClassifiers.length; ++i) {
                    if (allClassifiers[i] == null) {
                        means[j].writeString(",");
                        stDev[j].writeString(",");
                        continue;
                    }
                    try {
                        String r = allClassifiers[i].readLine();
                        String[] res = r.split(",");
                        double mean = 0.0;
                        double sumSquare = 0.0;
                        for (int m = 1; m < res.length; ++m) {
                            double d = Double.parseDouble(res[m].trim());
                            mean += d;
                            sumSquare += d * d;
                        }
                        if (res.length > 1) {
                            int size = res.length - 1;
                            double stdDev = sumSquare / (double)size - (mean /= (double)size) * mean;
                            stdDev = Math.sqrt(stdDev);
                            means[j].writeString("," + df.format(mean));
                            stDev[j].writeString("," + df.format(stdDev));
                        } else {
                            means[j].writeString(",");
                            stDev[j].writeString(",");
                        }
                        prev = r;
                        continue;
                    }
                    catch (Exception ex) {
                        System.out.println("failed to read line: " + ex + " previous line = " + prev + " file index =" + j + " classifier index =" + i);
                    }
                }
                means[j].writeString("\n");
                stDev[j].writeString("\n");
                if (j != 0) continue;
                count.writeString("\n");
            }
            for (InFile inf : allClassifiers) {
                if (inf == null) continue;
                inf.closeFile();
            }
        }
    }

    public static void basicSummaryComparisons() {
        DecimalFormat df = new DecimalFormat("###.#####");
        if (classifiers.length <= 1) {
            return;
        }
        String name = classifiers[0];
        for (int i = 1; i < classifiers.length; ++i) {
            name = name + classifiers[i];
        }
        OutFile s = new OutFile(basePath + "summaryTests" + name + ".csv");
        String[] allStatistics = new String[]{"TestAcc", "TestBAcc", "TestNLL", "TestAUROC"};
        data = new double[problems.size()][classifiers.length];
        s.writeLine(name);
        for (String str : allStatistics) {
            s.writeLine("**************" + str + "********************");
            System.out.println("Loading " + basePath + name + "/" + str + name + ".csv");
            InFile f = new InFile(basePath + name + "/" + str + name + ".csv");
            f.readLine();
            for (int i = 0; i < problems.size(); ++i) {
                int j;
                String ss = f.readLine();
                String[] d = ss.split(",");
                for (j = 0; j < classifiers.length; ++j) {
                    CollateResults.data[i][j] = -1.0;
                }
                for (j = 0; j < d.length - 1; ++j) {
                    try {
                        double v;
                        CollateResults.data[i][j] = v = Double.parseDouble(d[j + 1]);
                        continue;
                    }
                    catch (Exception v) {
                        // empty catch block
                    }
                }
            }
            for (int x = 0; x < classifiers.length - 1; ++x) {
                for (int y = x + 1; y < classifiers.length; ++y) {
                    int wins = 0;
                    int draws = 0;
                    int losses = 0;
                    int sigWins = 0;
                    int sigLosses = 0;
                    double meanDiff = 0.0;
                    double sumSq = 0.0;
                    double count = 0.0;
                    for (int i = 0; i < problems.size(); ++i) {
                        if (data[i][x] == -1.0 || data[i][y] == -1.0) continue;
                        if (data[i][x] > data[i][y]) {
                            ++wins;
                        } else if (data[i][x] == data[i][y]) {
                            ++draws;
                        } else {
                            ++losses;
                        }
                        meanDiff += data[i][x] - data[i][y];
                        sumSq += (data[i][x] - data[i][y]) * (data[i][x] - data[i][y]);
                        count += 1.0;
                    }
                    System.out.println(str + "," + classifiers[x] + "," + classifiers[y] + ",WIN/DRAW/LOSE," + wins + "," + draws + "," + losses);
                    BinomialDistribution bin = new BinomialDistribution();
                    bin.setParameters(wins + losses, 0.5);
                    double p = bin.getCDF(wins);
                    if (p > 0.5) {
                        p = 1.0 - p;
                    }
                    s.writeLine(str + "," + classifiers[x] + "," + classifiers[y] + ",WIN/DRAW/LOSE," + wins + "," + draws + "," + losses + ", p =," + df.format(p));
                    System.out.println(str + "," + classifiers[x] + "," + classifiers[y] + ",COUNT," + count + ",MeanDiff," + df.format(meanDiff / count) + ",StDevDiff," + df.format(sumSq - meanDiff * meanDiff / count) + " p =" + df.format(p));
                    InFile first = new InFile(basePath + classifiers[x] + "/" + classifiers[x] + str + ".csv");
                    InFile second = new InFile(basePath + classifiers[y] + "/" + classifiers[y] + str + ".csv");
                    for (int i = 0; i < problems.size(); ++i) {
                        String[] probX = first.readLine().split(",");
                        String[] probY = second.readLine().split(",");
                        if (probX.length <= folds || probY.length <= folds) continue;
                        double[] diffs = new double[folds];
                        boolean notAllTheSame = false;
                        for (int j = 0; j < folds; ++j) {
                            diffs[j] = Double.parseDouble(probX[j + 1]) - Double.parseDouble(probY[j + 1]);
                            if (notAllTheSame || probX[j + 1].equals(probY[j + 1])) continue;
                            notAllTheSame = true;
                        }
                        if (notAllTheSame) {
                            OneSampleTests test = new OneSampleTests();
                            String res = test.performTests(diffs);
                            System.out.println("Results = " + res);
                            String[] results = res.split(",");
                            double tTestPValue = Double.parseDouble(results[2]);
                            if (tTestPValue >= 0.95) {
                                ++sigWins;
                                continue;
                            }
                            if (!(tTestPValue <= 0.05)) continue;
                            ++sigLosses;
                            continue;
                        }
                        System.out.println("**************ALL THE SAME problem = " + probX[0] + " *************");
                    }
                    s.writeLine(str + "," + classifiers[x] + "," + classifiers[y] + ",SIGWIN/SIGLOSS," + sigWins + "," + sigLosses);
                    System.out.println(str + "," + classifiers[x] + "," + classifiers[y] + ",SIGWIN/SIGLOSS," + sigWins + "," + sigLosses);
                    s.writeLine(str + "," + classifiers[x] + "," + classifiers[y] + ",COUNT," + count + ",MeanDiff," + df.format(meanDiff / count) + ",StDevDiff," + df.format(sumSq - meanDiff * meanDiff / count));
                    System.out.println(str + "," + classifiers[x] + "," + classifiers[y] + ",COUNT," + count + ",MeanDiff," + df.format(meanDiff / count) + ",StDevDiff," + df.format(sumSq - meanDiff * meanDiff / count));
                }
            }
            ArrayList<double[]> res = new ArrayList<double[]>();
            for (int i = 0; i < data.length; ++i) {
                int j;
                for (j = 0; j < data[i].length && data[i][j] != -1.0; ++j) {
                }
                if (j != data[i].length) continue;
                res.add(data[i]);
            }
            System.out.println("REDUCED DATA SIZE = " + res.size());
            double[][] d2 = new double[res.size()][];
            for (int i = 0; i < res.size(); ++i) {
                d2[i] = (double[])res.get(i);
            }
            StringBuilder resultsString = MultipleClassifiersPairwiseTest.runSignRankTest(d2, classifiers);
            s.writeString(resultsString.toString());
            System.out.println(resultsString);
        }
        s.closeFile();
    }

    public static void collate(String[] args) {
        CollateResults.readData(args);
        System.out.println(" number of classifiers =" + numClassifiers);
        System.out.println("Collating folds ....");
        CollateResults.collateFolds();
        System.out.println("Collate folds finished. \n Averaging over folds....");
        CollateResults.averageOverFolds();
        System.out.println("averaging folds finished.\n Basic stats comparison ....");
        CollateResults.basicSummaryComparisons();
    }

    public static void main(String[] args) {
        if (args.length > 1) {
            CollateResults.collate(args);
        } else {
            String[] str = new String[]{"//cmptscsvr.cmp.uea.ac.uk/ueatsc/gcc/", "//cmptscsvr.cmp.uea.ac.uk/ueatsc/Data/UCIContinuous/", "30", "false", "UBMLP", "1"};
            CollateResults.collate(str);
        }
    }

    static {
        df = new DecimalFormat("##.######");
        countPartials = false;
        MAXNUMPARAS = 1180;
    }
}

