/*
 * Decompiled with CFR 0.152.
 */
package development;

import development.DataSets;
import fileIO.InFile;
import fileIO.OutFile;
import java.io.File;
import java.util.ArrayList;
import java.util.TreeSet;
import utilities.ClassifierTools;
import utilities.InstanceTools;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;

public class BiasVarianceEvaluation {
    int numTest;
    int numClasses;
    double bias;
    double variance;
    public static String resultsPath = "C:/Data/BVTest/";
    public static String dataPath = "C:/Data/BVTest/";
    public static String algorithm = "RIF_PS_ACF";
    public static String[] fileNames = DataSets.fileNames;

    public static BVResult findBV(String algo, String problem) {
        InFile f = new InFile(resultsPath + "BV/" + algo + "/" + problem + "TEST.csv");
        int lines = f.countLines();
        f = new InFile(resultsPath + "BV/" + algo + "/" + problem + "TEST.csv");
        int[] actual = new int[lines];
        int[][] preds = new int[lines][];
        for (int i = 0; i < lines; ++i) {
            String[] stringArray = f.readLine().split(",");
            actual[i] = Integer.parseInt(stringArray[1]);
            int p = stringArray.length - 3;
            preds[i] = new int[p];
            for (int j = 0; j < p; ++j) {
                preds[i][j] = Integer.parseInt(stringArray[j + 3]);
            }
        }
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (int i : actual) {
            ts.add(i);
        }
        int n = ts.size();
        System.out.println("Number of classes =" + n);
        BVResult bv = BiasVarianceEvaluation.findBV(actual, preds, n);
        System.out.println(algo + "BV for " + problem + " = " + bv.toString());
        return bv;
    }

    public static BVResult findBV(int[] allActual, int[][] allPreds, int numClasses) {
        int numCases = allActual.length;
        BVResult res = new BVResult();
        System.out.println("num instances  =" + numCases);
        int correct = 0;
        int count = 0;
        int[] mainPredictions = new int[numCases];
        for (int i = 0; i < numCases; ++i) {
            int j;
            int[] preds = allPreds[i];
            int actual = allActual[i];
            double[] p = new double[numClasses];
            int numClassifiers = preds.length;
            if (numClassifiers < 2) continue;
            int[] nArray = preds;
            int n = nArray.length;
            for (int k = 0; k < n; ++k) {
                int j2;
                int n2 = j2 = nArray[k];
                p[n2] = p[n2] + 1.0;
                ++count;
                if (j2 != actual) continue;
                ++correct;
            }
            mainPredictions[i] = 0;
            for (j = 0; j < p.length; ++j) {
                if (!(p[j] > p[mainPredictions[i]])) continue;
                mainPredictions[i] = j;
            }
            j = 0;
            while (j < p.length) {
                int n3 = j++;
                p[n3] = p[n3] / (double)numClassifiers;
            }
            double bSum = 0.0;
            double vSum = 0.0;
            for (int j3 = 0; j3 < numClasses; ++j3) {
                boolean x = actual == j3;
                bSum += ((double)x - p[j3]) * ((double)x - p[j3]) - p[j3] * (1.0 - p[j3]) / (double)(numClassifiers - 1);
                vSum += p[j3] * p[j3];
            }
            res.biasKohavi += bSum;
            res.varianceKohavi += 1.0 - vSum;
            if (mainPredictions[i] != actual) {
                res.biasDomingos += 1.0;
            }
            double v = 0.0;
            for (int j4 = 0; j4 < preds.length; ++j4) {
                if (preds[j4] == mainPredictions[i]) continue;
                v += 1.0;
            }
            res.varianceDomingos += v / (double)preds.length;
            if (mainPredictions[i] == actual) {
                res.unbiasedVariance += v / (double)preds.length;
                res.netVariance += v / (double)preds.length;
                continue;
            }
            res.biasedVariance += v / (double)preds.length;
            res.netVariance -= v / (double)preds.length;
        }
        res.acc = (double)correct / (double)count;
        res.biasKohavi /= (double)numCases;
        res.varianceKohavi /= (double)numCases;
        res.biasDomingos /= (double)numCases;
        res.varianceDomingos /= (double)numCases;
        res.biasedVariance /= (double)numCases;
        res.unbiasedVariance /= (double)numCases;
        res.netVariance /= (double)numCases;
        System.out.println("K_BIAS =" + res.biasKohavi + " K_VARIANCE = " + res.varianceKohavi);
        System.out.println("D_BIAS =" + res.biasDomingos + " D_VARIANCE = " + res.varianceDomingos + " UNBIASED_VAR=" + res.unbiasedVariance + " BIASED_VAR=" + res.biasedVariance + " NET_VAR=" + res.netVariance);
        return res;
    }

    public static void findMappings(String problem) {
        Instances train = ClassifierTools.loadData(dataPath + problem + "/" + problem + "_TRAIN");
        Instances test = ClassifierTools.loadData(dataPath + problem + "/" + problem + "_TEST");
        train.insertAttributeAt(new Attribute("Index"), 0);
        test.insertAttributeAt(new Attribute("Index"), 0);
        int value = 0;
        for (Instance in : train) {
            in.setValue(0, (double)value++);
        }
        for (Instance in : test) {
            in.setValue(0, (double)value++);
        }
        OutFile folds = new OutFile(resultsPath + "Folds/" + problem + ".csv");
        for (int i = 0; i < 100; ++i) {
            Instances[] split = InstanceTools.resampleTrainAndTestInstances(train, test, i);
            folds.writeLine("Fold," + i);
            int count = 0;
            for (Instance in : split[0]) {
                if (in.value(0) < (double)train.numInstances()) {
                    folds.writeLine(count + "," + (int)in.value(0) + ",TRAIN,TRAIN");
                } else {
                    folds.writeLine(count + "," + (int)in.value(0) + ",TEST,TRAIN");
                }
                ++count;
            }
            for (Instance in : split[1]) {
                if (in.value(0) < (double)train.numInstances()) {
                    folds.writeLine(count + "," + (int)in.value(0) + ",TRAIN,TEST");
                } else {
                    folds.writeLine(count + "," + (int)in.value(0) + ",TEST,TEST");
                }
                ++count;
            }
        }
    }

    public static void formatPredictions(String problem, int folds) {
        File f = new File(resultsPath + "Folds/" + problem + ".csv");
        File f2 = new File(resultsPath + algorithm + "/Predictions");
        if (!f.exists()) {
            System.out.println("ERROR, file " + f + " not present");
            System.exit(0);
        }
        if (!f2.exists()) {
            System.out.println("ERROR, file " + f2 + " not present");
            System.exit(0);
        }
        String dataSet = resultsPath + problem;
        Instances train = ClassifierTools.loadData(dataPath + problem + "/" + problem + "_TRAIN");
        Instances test = ClassifierTools.loadData(dataPath + problem + "/" + problem + "_TEST");
        int numInstances = train.numInstances() + test.numInstances();
        int trainSize = train.numInstances();
        int testSize = test.numInstances();
        System.out.println(" NUMBER OF INSTANCES=" + numInstances);
        System.out.println("Train size =" + trainSize + " test size =" + testSize);
        int[] actualClassVals = new int[numInstances];
        int pos = 0;
        for (Instance t : train) {
            actualClassVals[pos++] = (int)t.classValue();
        }
        for (Instance t : test) {
            actualClassVals[pos++] = (int)t.classValue();
        }
        InFile allFolds = new InFile(resultsPath + "Folds/" + problem + ".csv");
        int[][] resampleMap = new int[folds][numInstances];
        ArrayList[] testPredictions = new ArrayList[numInstances];
        ArrayList[] trainPredictions = new ArrayList[numInstances];
        for (int j = 0; j < numInstances; ++j) {
            testPredictions[j] = new ArrayList();
            trainPredictions[j] = new ArrayList();
        }
        for (int i = 0; i < folds; ++i) {
            int j;
            String str2 = allFolds.readLine();
            for (int j2 = 0; j2 < numInstances; ++j2) {
                int map;
                int a = allFolds.readInt();
                if (a != j2) {
                    System.out.println("ERROR in reading in the mapping, misalligned somehow. DEBUG");
                    System.exit(0);
                }
                resampleMap[i][j2] = map = allFolds.readInt();
                allFolds.readString();
                allFolds.readString();
            }
            InFile testPredF = new InFile(resultsPath + algorithm + "/Predictions/" + problem + "/testFold" + i + ".csv");
            for (int k = 0; k < 3; ++k) {
                testPredF.readLine();
            }
            int[][] temp = new int[2][numInstances];
            for (j = trainSize; j < numInstances; ++j) {
                temp[0][j] = testPredF.readInt();
                temp[1][j] = testPredF.readInt();
                String string = testPredF.readLine();
            }
            for (j = 0; j < numInstances; ++j) {
                int foldPos = resampleMap[i][j];
                int actual = temp[0][j];
                int predicted = temp[1][j];
                if (j >= trainSize && actual != actualClassVals[foldPos]) {
                    Instance x;
                    System.out.println(problem + " CLASS MISSMATCH Resample pos =" + j + "  Original position =" + foldPos);
                    System.out.println("CLASS MISMATCH IN ACTUAL..... NEEDS DEBUGGING");
                    System.out.println("Instance resample pos =" + j + " in test fold +" + i + " pos =" + (j - trainSize) + " position in original =" + foldPos + " Class from array =" + actualClassVals[foldPos] + " class from TestFold class =" + actual + " instance =" + j);
                    if (foldPos < trainSize) {
                        System.out.println(" Instance in train ");
                        x = train.instance(foldPos);
                    } else {
                        System.out.println(" Instance in test first value");
                        x = test.instance(foldPos - trainSize);
                    }
                    System.out.println("class =" + x.classValue() + " first val=" + x.value(0));
                    System.exit(0);
                }
                if (j < trainSize) {
                    trainPredictions[foldPos].add(predicted);
                    continue;
                }
                testPredictions[foldPos].add(predicted);
            }
        }
        OutFile testF = new OutFile(resultsPath + "BV/" + algorithm + "/" + problem + "Test.csv");
        for (int i = 0; i < testPredictions.length; ++i) {
            testF.writeString(i + "," + actualClassVals[i] + ",");
            for (Integer in : testPredictions[i]) {
                testF.writeString("," + in);
            }
            testF.writeString("\n");
        }
    }

    public static void fullBV(String algo) {
        algorithm = algo;
        OutFile bv = new OutFile(resultsPath + "BV/" + algorithm + "BV.csv");
        for (int i = 59; i < fileNames.length; ++i) {
            String problem = fileNames[i];
            System.out.println(i + "PROBLEM FILE :" + problem);
            BiasVarianceEvaluation.formatPredictions(problem, 100);
            BVResult b = BiasVarianceEvaluation.findBV(algorithm, problem);
            bv.writeLine(problem + "," + b.toString());
        }
    }

    public static void main(String[] args) {
        dataPath = "C:/Users/ajb/Dropbox/TSC Problems/";
        resultsPath = "C:/Users/ajb/Dropbox/NewCOTEResults/";
        BiasVarianceEvaluation.fullBV("RotF");
    }

    public static class BVResult {
        public double biasKohavi = 0.0;
        public double varianceKohavi = 0.0;
        public double biasDomingos;
        public double varianceDomingos;
        public double unbiasedVariance;
        public double biasedVariance;
        public double netVariance;
        public double acc = 0.0;

        BVResult() {
        }

        public String toString() {
            return this.acc + ",," + this.biasKohavi + "," + this.varianceKohavi + ",," + this.biasDomingos + "," + this.varianceDomingos + "," + this.unbiasedVariance + "," + this.biasedVariance + "," + this.netVariance;
        }
    }
}

