/*
 * Decompiled with CFR 0.152.
 */
package applications;

import development.DataSets;
import development.MatrixProfileExperiments;
import fileIO.InFile;
import fileIO.OutFile;
import java.io.File;
import java.text.DecimalFormat;
import timeseriesweka.classifiers.ensembles.SaveableEnsemble;
import utilities.ClassifierTools;
import utilities.SaveParameterInfo;
import weka.classifiers.Classifier;
import weka.core.Instance;
import weka.core.Instances;

public class EpilepsyX {
    public static String[] personID = new String[]{"ID001", "ID002", "ID003", "ID004", "ID005", "ID006"};
    static String[] classifiers = new String[]{"ED", "RotF", "DTW", "EE", "HESCA", "TSF", "ST", "BOSS", "RISE", "FLATCOTE", "HIVECOTE"};

    static Instances[] sample(int person) {
        Instances all = ClassifierTools.loadData(DataSets.problemPath + "/EpilepsyX/EpilepsyX");
        Instances[] split = new Instances[]{new Instances(all, 0), new Instances(all, 0)};
        for (Instance ins : all) {
            if (ins.stringValue(0).equals(personID[person])) {
                split[1].add(ins);
                continue;
            }
            split[0].add(ins);
        }
        split[0].deleteAttributeAt(0);
        split[1].deleteAttributeAt(0);
        return split;
    }

    public static void collateResults() {
        String resultsPath = "C:/Research/Results/EpilepsyXResults/";
        OutFile out = new OutFile(resultsPath + "collatedResults.csv");
        for (String c : classifiers) {
            out.writeString("," + c);
        }
        out.writeString("\n");
        for (int i = 0; i < personID.length; ++i) {
            out.writeString(personID[i]);
            for (String c : classifiers) {
                String p = resultsPath + c + "/Predictions/EpilepsyX/" + "testFold" + i + ".csv";
                File f = new File(p);
                if (f.exists() && f.length() > 0L) {
                    InFile inf = new InFile(p);
                    inf.readLine();
                    inf.readLine();
                    out.writeString("," + inf.readDouble());
                    continue;
                }
                out.writeString(",");
            }
            out.writeString("\n");
        }
    }

    public static void singleClassifierAndPerson(String[] args) {
        String predictions;
        String classifier = args[0];
        int fold = Integer.parseInt(args[1]) - 1;
        Classifier c = MatrixProfileExperiments.setClassifier(classifier);
        Instances[] split = EpilepsyX.sample(fold);
        File f = new File(DataSets.resultsPath + classifier);
        if (!f.exists()) {
            f.mkdir();
        }
        if (!(f = new File(predictions = DataSets.resultsPath + classifier + "/Predictions")).exists()) {
            f.mkdir();
        }
        if (!(f = new File(predictions = predictions + "/EpilepsyX")).exists()) {
            f.mkdir();
        }
        if (!(f = new File(predictions + "/testFold" + fold + ".csv")).exists() || f.length() == 0L) {
            double acc = EpilepsyX.singleClassifierAndPerson(split[0], split[1], c, fold, predictions);
            System.out.println(classifier + "," + "EpilepsyX" + "," + fold + "," + acc);
        }
    }

    public static double singleClassifierAndPerson(Instances train, Instances test, Classifier c, int fold, String resultsPath) {
        double acc = 0.0;
        if (c instanceof SaveableEnsemble) {
            ((SaveableEnsemble)((Object)c)).saveResults(resultsPath + "/internalCV_" + fold + ".csv", resultsPath + "/internalTestPreds_" + fold + ".csv");
        }
        try {
            c.buildClassifier(train);
            StringBuilder str = new StringBuilder();
            DecimalFormat df = new DecimalFormat("##.######");
            for (int j = 0; j < test.numInstances(); ++j) {
                int act = (int)test.instance(j).classValue();
                test.instance(j).setClassMissing();
                double[] probs = c.distributionForInstance(test.instance(j));
                int pred = 0;
                for (int i = 1; i < probs.length; ++i) {
                    if (!(probs[i] > probs[pred])) continue;
                    pred = i;
                }
                if (act == pred) {
                    acc += 1.0;
                }
                str.append(act);
                str.append(",");
                str.append(pred);
                str.append(",,");
                for (double d : probs) {
                    str.append(df.format(d));
                    str.append(",");
                }
                str.append("\n");
            }
            acc /= (double)test.numInstances();
            OutFile p = new OutFile(resultsPath + "/testFold" + fold + ".csv");
            p.writeLine(train.relationName() + "," + c.getClass().getName() + ",test");
            if (c instanceof SaveParameterInfo) {
                p.writeLine(((SaveParameterInfo)((Object)c)).getParameters());
            } else {
                p.writeLine("No parameter info");
            }
            p.writeLine(acc + "");
            p.writeLine(str.toString());
        }
        catch (Exception e) {
            System.out.println(" Error =" + e + " in method simpleExperiment" + e);
            e.printStackTrace();
            System.out.println(" TRAIN " + train.relationName() + " has " + train.numAttributes() + " attributes and " + train.numInstances() + " instances");
            System.out.println(" TEST " + test.relationName() + " has " + test.numAttributes() + " attributes" + test.numInstances() + " instances");
            System.exit(0);
        }
        return acc;
    }

    public static void createEpilepsyScripts(boolean grace) {
        String path = "C:\\Users\\ajb\\Dropbox\\Code\\Cluster Scripts\\EpilepsyXScripts\\";
        File f = new File(path);
        if (!f.isDirectory()) {
            f.mkdir();
        }
        int mem = 4000;
        OutFile of2 = grace ? new OutFile(path + "EpilepsyXGrace.txt") : new OutFile(path + "EpilepsyX.txt");
        for (String s : classifiers) {
            OutFile of = grace ? new OutFile(path + s + "Grace.bsub") : new OutFile(path + s + ".bsub");
            of.writeLine("#!/bin/csh");
            if (grace) {
                of.writeLine("#BSUB -q short");
            } else {
                of.writeLine("#BSUB -q long-eth");
            }
            of.writeLine("#BSUB -J " + s + "[1-6]");
            of.writeLine("#BSUB -oo output/EpilepsyX" + s + ".out");
            of.writeLine("#BSUB -eo error/EpilepsyX" + s + ".err");
            if (grace) {
                of.writeLine("#BSUB -R \"rusage[mem=" + mem + "]\"");
                of.writeLine("#BSUB -M " + mem);
                of.writeLine(" module add java/jdk/1.8.0_31");
            } else {
                of.writeLine("#BSUB -R \"rusage[mem=" + (4000 + mem) + "]\"");
                of.writeLine("#BSUB -M " + (4000 + mem));
                of.writeLine("module add java/jdk1.8.0_51");
            }
            of.writeLine("java -jar EpilepsyX.jar " + s + "  $LSB_JOBINDEX");
            if (grace) {
                of2.writeLine("bsub < Scripts/EpilepsyXScripts/" + s + "Grace.bsub");
                continue;
            }
            of2.writeLine("bsub < Scripts/EpilepsyXScripts/" + s + ".bsub");
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            DataSets.problemPath = DataSets.clusterPath + "TSC Problems/";
            DataSets.resultsPath = DataSets.clusterPath + "Results/EpilepsyXResults/";
            EpilepsyX.singleClassifierAndPerson(args);
        } else {
            DataSets.problemPath = DataSets.dropboxPath + "TSC Problems/";
            DataSets.resultsPath = DataSets.dropboxPath + "Results/EpilepsyXResults/";
            String[] paras = new String[]{"RotF", "6"};
            EpilepsyX.singleClassifierAndPerson(paras);
        }
    }
}

