/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.AttributeStats;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.SimpleBatchFilter;

public class RELAGGS
extends SimpleBatchFilter
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -3333791375278589231L;
    protected int m_MaxCardinality = 20;
    protected Range m_SelectedRange = new Range("first-last");
    protected Hashtable<String, AttributeStats> m_AttStats = new Hashtable();

    @Override
    public String globalInfo() {
        return "A propositionalization filter inspired by the RELAGGS algorithm.\nIt processes all relational attributes that fall into the user defined range (all others are skipped, i.e., not added to the output). Currently, the filter only processes one level of nesting.\nThe class attribute is not touched.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "M.-A. Krogel and S. Wrobel");
        result.setValue(TechnicalInformation.Field.TITLE, "Facets of Aggregation Approaches to Propositionalization");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Work-in-Progress Track at the Thirteenth International Conference on Inductive Logic Programming (ILP)");
        result.setValue(TechnicalInformation.Field.EDITOR, "T. Horvath and A. Yamamoto");
        result.setValue(TechnicalInformation.Field.YEAR, "2003");
        result.setValue(TechnicalInformation.Field.PDF, "http://kd.cs.uni-magdeburg.de/~krogel/papers/aggs.pdf");
        return result;
    }

    @Override
    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        result.addElement(new Option("\tSpecify list of string attributes to convert to words.\n\t(default: select all relational attributes)", "R", 1, "-R <index1,index2-index4,...>"));
        result.addElement(new Option("\tInverts the matching sense of the selection.", "V", 0, "-V"));
        result.addElement(new Option("\tMax. cardinality of nominal attributes. If a nominal attribute\n\thas more values than this upper limit, then it will be skipped.\n\t(default: 20)", "C", 1, "-C <num>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('R', options);
        if (tmpStr.length() != 0) {
            this.setSelectedRange(tmpStr);
        } else {
            this.setSelectedRange("first-last");
        }
        this.setInvertSelection(Utils.getFlag('V', options));
        tmpStr = Utils.getOption('C', options);
        if (tmpStr.length() != 0) {
            this.setMaxCardinality(Integer.parseInt(tmpStr));
        } else {
            this.setMaxCardinality(20);
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-R");
        result.add(this.getSelectedRange().getRanges());
        if (this.getInvertSelection()) {
            result.add("-V");
        }
        result.add("-C");
        result.add("" + this.getMaxCardinality());
        return result.toArray(new String[result.size()]);
    }

    public String maxCardinalityTipText() {
        return "The maximum number of values a nominal attribute can have before it's skipped.";
    }

    public void setMaxCardinality(int value) {
        this.m_MaxCardinality = value;
    }

    public int getMaxCardinality() {
        return this.m_MaxCardinality;
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on; this is a comma separated list of attribute indices, with \"first\" and \"last\" valid values; Specify an inclusive range with \"-\"; eg: \"first-3,5,6-10,last\".";
    }

    public void setSelectedRange(String value) {
        this.m_SelectedRange = new Range(value);
    }

    public Range getSelectedRange() {
        return this.m_SelectedRange;
    }

    public String invertSelectionTipText() {
        return "Set attribute selection mode. If false, only selected attributes in the range will be worked on; if true, only non-selected attributes will be processed.";
    }

    public void setInvertSelection(boolean value) {
        this.m_SelectedRange.setInvert(value);
    }

    public boolean getInvertSelection() {
        return this.m_SelectedRange.getInvert();
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        this.m_SelectedRange.setUpper(inputFormat.numAttributes() - 1);
        FastVector<Attribute> atts = new FastVector<Attribute>();
        int clsIndex = -1;
        for (int i = 0; i < inputFormat.numAttributes(); ++i) {
            if (i == inputFormat.classIndex()) {
                clsIndex = atts.size();
                atts.addElement((Attribute)inputFormat.attribute(i).copy());
                continue;
            }
            if (!inputFormat.attribute(i).isRelationValued()) {
                atts.addElement((Attribute)inputFormat.attribute(i).copy());
                continue;
            }
            if (!this.m_SelectedRange.isInRange(i)) {
                if (!this.getDebug()) continue;
                System.out.println("Attribute " + (i + 1) + " (" + inputFormat.attribute(i).name() + ") skipped.");
                continue;
            }
            String prefix = inputFormat.attribute(i).name() + "_";
            Instances relFormat = inputFormat.attribute(i).relation();
            for (int n = 0; n < relFormat.numAttributes(); ++n) {
                Attribute att = relFormat.attribute(n);
                if (att.isNumeric()) {
                    atts.addElement(new Attribute(prefix + att.name() + "_MIN"));
                    atts.addElement(new Attribute(prefix + att.name() + "_MAX"));
                    atts.addElement(new Attribute(prefix + att.name() + "_AVG"));
                    atts.addElement(new Attribute(prefix + att.name() + "_STDEV"));
                    atts.addElement(new Attribute(prefix + att.name() + "_SUM"));
                    continue;
                }
                if (att.isNominal()) {
                    if (att.numValues() <= this.m_MaxCardinality) {
                        for (int m = 0; m < att.numValues(); ++m) {
                            atts.addElement(new Attribute(prefix + att.name() + "_" + att.value(m) + "_CNT"));
                        }
                        continue;
                    }
                    if (!this.getDebug()) continue;
                    System.out.println("Attribute " + (i + 1) + "/" + (n + 1) + " (" + inputFormat.attribute(i).name() + "/" + att.name() + ") skipped, " + att.numValues() + " > " + this.m_MaxCardinality + ".");
                    continue;
                }
                if (!this.getDebug()) continue;
                System.out.println("Attribute " + (i + 1) + "/" + (n + 1) + " (" + inputFormat.attribute(i).name() + "/" + att.name() + ") skipped.");
            }
        }
        Instances result = new Instances(inputFormat.relationName(), atts, 0);
        result.setClassIndex(clsIndex);
        this.initOutputLocators(result, new int[0]);
        return result;
    }

    @Override
    public Instances process(Instances instances) throws Exception {
        AttributeStats stats;
        Attribute att;
        int n;
        Instances relInstances;
        int k;
        int i;
        Instances result = this.getOutputFormat();
        this.m_AttStats.clear();
        for (i = 0; i < instances.numAttributes(); ++i) {
            if (i == instances.classIndex() || !instances.attribute(i).isRelationValued() || !this.m_SelectedRange.isInRange(i)) continue;
            for (k = 0; k < instances.numInstances(); ++k) {
                relInstances = instances.instance(k).relationalValue(i);
                for (n = 0; n < relInstances.numAttributes(); ++n) {
                    att = relInstances.attribute(n);
                    stats = null;
                    if (!att.isNumeric() && (!att.isNominal() || att.numValues() > this.m_MaxCardinality)) continue;
                    stats = relInstances.attributeStats(n);
                    this.m_AttStats.put(k + "-" + i + "-" + n, stats);
                }
            }
        }
        for (k = 0; k < instances.numInstances(); ++k) {
            Instance inst = instances.instance(k);
            DenseInstance newInst = new DenseInstance(result.numAttributes());
            newInst.setWeight(inst.weight());
            int l = 0;
            for (i = 0; i < instances.numAttributes(); ++i) {
                if (!instances.attribute(i).isRelationValued()) {
                    newInst.setValue(l, inst.value(i));
                    ++l;
                    continue;
                }
                if (!this.m_SelectedRange.isInRange(i)) continue;
                relInstances = inst.relationalValue(i);
                for (n = 0; n < relInstances.numAttributes(); ++n) {
                    att = relInstances.attribute(n);
                    stats = this.m_AttStats.get(k + "-" + i + "-" + n);
                    if (att.isNumeric()) {
                        newInst.setValue(l, stats.numericStats.min);
                        newInst.setValue(++l, stats.numericStats.max);
                        newInst.setValue(++l, stats.numericStats.mean);
                        newInst.setValue(++l, stats.numericStats.stdDev);
                        newInst.setValue(++l, stats.numericStats.sum);
                        ++l;
                        continue;
                    }
                    if (!att.isNominal() || att.numValues() > this.m_MaxCardinality) continue;
                    for (int m = 0; m < att.numValues(); ++m) {
                        newInst.setValue(l, (double)stats.nominalCounts[m]);
                        ++l;
                    }
                }
            }
            result.add(newInst);
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5547 $");
    }

    public static void main(String[] args) {
        RELAGGS.runFilter(new RELAGGS(), args);
    }
}

