/*
 * Decompiled with CFR 0.152.
 */
package weka.filters;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.filters.Filter;

public abstract class SimpleFilter
extends Filter
implements OptionHandler {
    private static final long serialVersionUID = 5702974949137433141L;
    protected boolean m_Debug = false;

    public abstract String globalInfo();

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tTurns on output of debugging information.", "D", 0, "-D"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.reset();
        this.setDebug(Utils.getFlag('D', options));
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.getDebug()) {
            result.add("-D");
        }
        return result.toArray(new String[result.size()]);
    }

    public void setDebug(boolean value) {
        this.m_Debug = value;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String debugTipText() {
        return "Turns on output of debugging information.";
    }

    protected void reset() {
        this.m_NewBatch = true;
        this.m_FirstBatchDone = false;
    }

    protected abstract boolean hasImmediateOutputFormat();

    protected abstract Instances determineOutputFormat(Instances var1) throws Exception;

    public abstract Instances process(Instances var1) throws Exception;

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.reset();
        if (this.hasImmediateOutputFormat()) {
            this.setOutputFormat(this.determineOutputFormat(instanceInfo));
        }
        return this.hasImmediateOutputFormat();
    }
}

