/*
 * Decompiled with CFR 0.152.
 */
package weka.filters;

import weka.core.Instances;
import weka.filters.SimpleBatchFilter;

public class NormalizeAttribute
extends SimpleBatchFilter {
    Instances trainData;
    double[] min;
    double[] max;
    double[] mean;
    double[] stdev;
    int classIndex;
    NormType norm = NormType.INTERVAL;

    public NormalizeAttribute(Instances data) {
        this.trainData = data;
        this.classIndex = data.classIndex();
        this.findStats(data);
    }

    protected void findStats(Instances r) {
        this.max = new double[r.numAttributes()];
        this.min = new double[r.numAttributes()];
        for (int j = 0; j < r.numAttributes(); ++j) {
            this.max[j] = Double.MIN_VALUE;
            this.min[j] = Double.MAX_VALUE;
            for (int i = 0; i < r.numInstances(); ++i) {
                double x = r.instance(i).value(j);
                if (x > this.max[j]) {
                    this.max[j] = x;
                }
                if (!(x < this.min[j])) continue;
                this.min[j] = x;
            }
        }
        this.mean = new double[r.numAttributes()];
        this.stdev = new double[r.numAttributes()];
        for (int j = 0; j < r.numAttributes(); ++j) {
            double sum = 0.0;
            double sumSq = 0.0;
            for (int i = 0; i < r.numInstances(); ++i) {
                double x = r.instance(i).value(j);
                sum += x;
                sumSq += x * x;
            }
            this.stdev[j] = sumSq / (double)r.numInstances() - sum * sum;
            this.mean[j] = sum / (double)r.numInstances();
            this.stdev[j] = Math.sqrt(this.stdev[j]);
        }
    }

    public double[] getRanges() {
        double[] r = new double[this.max.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = this.max[i] - this.min[i];
        }
        return r;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) {
        return new Instances(inputFormat, 0);
    }

    public void setTrainData(Instances data) {
        this.trainData = data;
        this.classIndex = data.classIndex();
        this.findStats(data);
    }

    public void setNormMethod(NormType n) {
        this.norm = n;
    }

    @Override
    public Instances process(Instances inst) throws Exception {
        if (this.classIndex != inst.classIndex()) {
            throw new Exception("Wrong class index =" + inst.classIndex() + " expecting =" + this.classIndex);
        }
        Instances result = new Instances(inst);
        switch (this.norm) {
            case INTERVAL: {
                this.intervalNorm(result);
                break;
            }
            case STD_NORMAL: {
                this.standardNorm(result);
                break;
            }
            default: {
                System.out.println(" Unknown norm!" + (Object)((Object)this.norm));
                throw new Exception("in process");
            }
        }
        return result;
    }

    public void intervalNorm(Instances r) {
        for (int i = 0; i < r.numInstances(); ++i) {
            for (int j = 0; j < r.numAttributes(); ++j) {
                if (j == this.classIndex) continue;
                double x = r.instance(i).value(j);
                r.instance(i).setValue(j, (x - this.min[j]) / (this.max[j] - this.min[j]));
            }
        }
    }

    public void standardNorm(Instances r) {
        for (int j = 0; j < r.numAttributes(); ++j) {
            if (j == this.classIndex) continue;
            for (int i = 0; i < r.numInstances(); ++i) {
                double x = r.instance(i).value(j);
                r.instance(i).setValue(i, (x - this.mean[j]) / this.stdev[j]);
            }
        }
    }

    @Override
    public String globalInfo() {
        return null;
    }

    @Override
    public String getRevision() {
        return null;
    }

    static enum NormType {
        INTERVAL,
        STD_NORMAL;

    }
}

