/*
 * Decompiled with CFR 0.152.
 */
package weka.core.spectral_distance_functions;

import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.neighboursearch.PerformanceStats;
import weka.filters.NormalizeCase;

public class KullbackLeiberDistance
extends EuclideanDistance {
    private static final long serialVersionUID = 1L;

    public KullbackLeiberDistance() {
    }

    public KullbackLeiberDistance(Instances data) {
        super(data);
    }

    @Override
    public double distance(Instance first, Instance second) {
        return this.distance(first, second, Double.POSITIVE_INFINITY, null, false);
    }

    @Override
    public double distance(Instance first, Instance second, PerformanceStats stats) {
        return this.distance(first, second, Double.POSITIVE_INFINITY, stats, false);
    }

    @Override
    public double distance(Instance first, Instance second, double cutOffValue, PerformanceStats stats) {
        return this.distance(first, second, cutOffValue, stats, false);
    }

    public double distance(Instance first, Instance second, double cutOffValue, PerformanceStats stats, boolean print) {
        return this.distance(first, second, cutOffValue);
    }

    @Override
    public double distance(Instance first, Instance second, double cutOffValue) {
        double[] s;
        int sClass;
        double[] f;
        int fClass = first.classIndex();
        if (fClass >= 0) {
            f = new double[first.numAttributes() - 1];
            int count = 0;
            for (int i = 0; i < f.length + 1; ++i) {
                if (i == fClass) continue;
                f[count] = first.value(i);
                ++count;
            }
        } else {
            f = first.toDoubleArray();
        }
        if ((sClass = second.classIndex()) >= 0) {
            s = new double[second.numAttributes() - 1];
            int count = 0;
            for (int i = 0; i < s.length; ++i) {
                if (i == sClass) continue;
                s[count] = second.value(i);
                ++count;
            }
        } else {
            s = second.toDoubleArray();
        }
        if (f.length != s.length) {
            System.out.println("Error in distance calculation for Likelihhod ratio, unequal lengths, exiting program!");
            System.exit(0);
        }
        if (!this.m_DontNormalize) {
            try {
                NormalizeCase.standardNorm(f);
                NormalizeCase.standardNorm(s);
            }
            catch (Exception e) {
                System.out.println(" in log norm distance, Exception =" + e);
                e.printStackTrace();
                System.exit(0);
            }
        }
        return this.distance(f, s, cutOffValue);
    }

    public double distance(double[] a, double[] b, double cutoff) {
        double dist = 0.0;
        for (int i = 0; i < a.length; ++i) {
            if (!((dist += a[i] / b[i] - Math.log(a[i]) / Math.log(b[i]) - 1.0) > cutoff)) continue;
            return Double.POSITIVE_INFINITY;
        }
        return dist;
    }

    @Override
    public String toString() {
        return "Likelihood Ratio";
    }

    @Override
    public String globalInfo() {
        return "Likelihood Ratio";
    }

    @Override
    protected double updateDistance(double currDist, double diff) {
        return 0.0;
    }

    @Override
    public String getRevision() {
        return null;
    }
}

