/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.util.StringTokenizer;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class Stats
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = -8610544539090024102L;
    public double count = 0.0;
    public double sum = 0.0;
    public double sumSq = 0.0;
    public double stdDev = Double.NaN;
    public double mean = Double.NaN;
    public double min = Double.NaN;
    public double max = Double.NaN;

    public void add(double value) {
        this.add(value, 1.0);
    }

    public void add(double value, double n) {
        this.sum += value * n;
        this.sumSq += value * value * n;
        this.count += n;
        if (Double.isNaN(this.min)) {
            this.min = this.max = value;
        } else if (value < this.min) {
            this.min = value;
        } else if (value > this.max) {
            this.max = value;
        }
    }

    public void subtract(double value) {
        this.subtract(value, 1.0);
    }

    public void subtract(double value, double n) {
        this.sum -= value * n;
        this.sumSq -= value * value * n;
        this.count -= n;
    }

    public void calculateDerived() {
        this.mean = Double.NaN;
        this.stdDev = Double.NaN;
        if (this.count > 0.0) {
            this.mean = this.sum / this.count;
            this.stdDev = Double.POSITIVE_INFINITY;
            if (this.count > 1.0) {
                this.stdDev = this.sumSq - this.sum * this.sum / this.count;
                this.stdDev /= this.count - 1.0;
                if (this.stdDev < 0.0) {
                    this.stdDev = 0.0;
                }
                this.stdDev = Math.sqrt(this.stdDev);
            }
        }
    }

    public String toString() {
        this.calculateDerived();
        return "Count   " + Utils.doubleToString(this.count, 8) + '\n' + "Min     " + Utils.doubleToString(this.min, 8) + '\n' + "Max     " + Utils.doubleToString(this.max, 8) + '\n' + "Sum     " + Utils.doubleToString(this.sum, 8) + '\n' + "SumSq   " + Utils.doubleToString(this.sumSq, 8) + '\n' + "Mean    " + Utils.doubleToString(this.mean, 8) + '\n' + "StdDev  " + Utils.doubleToString(this.stdDev, 8) + '\n';
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) {
        try {
            String line;
            Stats ps = new Stats();
            LineNumberReader r = new LineNumberReader(new InputStreamReader(System.in));
            while ((line = r.readLine()) != null) {
                if ((line = line.trim()).equals("") || line.startsWith("@") || line.startsWith("%")) continue;
                StringTokenizer s = new StringTokenizer(line, " ,\t\n\r\f");
                int count = 0;
                double v1 = 0.0;
                while (s.hasMoreTokens()) {
                    double val = new Double(s.nextToken());
                    if (count != 0) {
                        System.err.println("MSG: Too many values in line \"" + line + "\", skipped.");
                        break;
                    }
                    v1 = val;
                    ++count;
                }
                if (count != true) continue;
                ps.add(v1);
            }
            ps.calculateDerived();
            System.err.println(ps);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

